/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTagOptionResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<CreateTagOptionResponse.Builder, CreateTagOptionResponse> {
    private static final SdkField<TagOptionDetail> TAG_OPTION_DETAIL_FIELD = SdkField
            .<TagOptionDetail> builder(MarshallingType.SDK_POJO).memberName("TagOptionDetail")
            .getter(getter(CreateTagOptionResponse::tagOptionDetail)).setter(setter(Builder::tagOptionDetail))
            .constructor(TagOptionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptionDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_OPTION_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TagOptionDetail tagOptionDetail;

    private CreateTagOptionResponse(BuilderImpl builder) {
        super(builder);
        this.tagOptionDetail = builder.tagOptionDetail;
    }

    /**
     * <p>
     * Information about the TagOption.
     * </p>
     * 
     * @return Information about the TagOption.
     */
    public final TagOptionDetail tagOptionDetail() {
        return tagOptionDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tagOptionDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTagOptionResponse)) {
            return false;
        }
        CreateTagOptionResponse other = (CreateTagOptionResponse) obj;
        return Objects.equals(tagOptionDetail(), other.tagOptionDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTagOptionResponse").add("TagOptionDetail", tagOptionDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagOptionDetail":
            return Optional.ofNullable(clazz.cast(tagOptionDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagOptionDetail", TAG_OPTION_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTagOptionResponse, T> g) {
        return obj -> g.apply((CreateTagOptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTagOptionResponse> {
        /**
         * <p>
         * Information about the TagOption.
         * </p>
         * 
         * @param tagOptionDetail
         *        Information about the TagOption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptionDetail(TagOptionDetail tagOptionDetail);

        /**
         * <p>
         * Information about the TagOption.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagOptionDetail.Builder} avoiding the
         * need to create one manually via {@link TagOptionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagOptionDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #tagOptionDetail(TagOptionDetail)}.
         * 
         * @param tagOptionDetail
         *        a consumer that will call methods on {@link TagOptionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagOptionDetail(TagOptionDetail)
         */
        default Builder tagOptionDetail(Consumer<TagOptionDetail.Builder> tagOptionDetail) {
            return tagOptionDetail(TagOptionDetail.builder().applyMutation(tagOptionDetail).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private TagOptionDetail tagOptionDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTagOptionResponse model) {
            super(model);
            tagOptionDetail(model.tagOptionDetail);
        }

        public final TagOptionDetail.Builder getTagOptionDetail() {
            return tagOptionDetail != null ? tagOptionDetail.toBuilder() : null;
        }

        public final void setTagOptionDetail(TagOptionDetail.BuilderImpl tagOptionDetail) {
            this.tagOptionDetail = tagOptionDetail != null ? tagOptionDetail.build() : null;
        }

        @Override
        public final Builder tagOptionDetail(TagOptionDetail tagOptionDetail) {
            this.tagOptionDetail = tagOptionDetail;
            return this;
        }

        @Override
        public CreateTagOptionResponse build() {
            return new CreateTagOptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
