/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisioningParametersResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProvisioningParametersResponse.Builder, DescribeProvisioningParametersResponse> {
    private static final SdkField<List<ProvisioningArtifactParameter>> PROVISIONING_ARTIFACT_PARAMETERS_FIELD = SdkField
            .<List<ProvisioningArtifactParameter>> builder(MarshallingType.LIST)
            .memberName("ProvisioningArtifactParameters")
            .getter(getter(DescribeProvisioningParametersResponse::provisioningArtifactParameters))
            .setter(setter(Builder::provisioningArtifactParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ConstraintSummary>> CONSTRAINT_SUMMARIES_FIELD = SdkField
            .<List<ConstraintSummary>> builder(MarshallingType.LIST)
            .memberName("ConstraintSummaries")
            .getter(getter(DescribeProvisioningParametersResponse::constraintSummaries))
            .setter(setter(Builder::constraintSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConstraintSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConstraintSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageInstruction>> USAGE_INSTRUCTIONS_FIELD = SdkField
            .<List<UsageInstruction>> builder(MarshallingType.LIST)
            .memberName("UsageInstructions")
            .getter(getter(DescribeProvisioningParametersResponse::usageInstructions))
            .setter(setter(Builder::usageInstructions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageInstructions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageInstruction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageInstruction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagOptionSummary>> TAG_OPTIONS_FIELD = SdkField
            .<List<TagOptionSummary>> builder(MarshallingType.LIST)
            .memberName("TagOptions")
            .getter(getter(DescribeProvisioningParametersResponse::tagOptions))
            .setter(setter(Builder::tagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagOptionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagOptionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisioningArtifactPreferences> PROVISIONING_ARTIFACT_PREFERENCES_FIELD = SdkField
            .<ProvisioningArtifactPreferences> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisioningArtifactPreferences")
            .getter(getter(DescribeProvisioningParametersResponse::provisioningArtifactPreferences))
            .setter(setter(Builder::provisioningArtifactPreferences))
            .constructor(ProvisioningArtifactPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactPreferences")
                    .build()).build();

    private static final SdkField<List<ProvisioningArtifactOutput>> PROVISIONING_ARTIFACT_OUTPUTS_FIELD = SdkField
            .<List<ProvisioningArtifactOutput>> builder(MarshallingType.LIST)
            .memberName("ProvisioningArtifactOutputs")
            .getter(getter(DescribeProvisioningParametersResponse::provisioningArtifactOutputs))
            .setter(setter(Builder::provisioningArtifactOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactOutputs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProvisioningArtifactOutput>> PROVISIONING_ARTIFACT_OUTPUT_KEYS_FIELD = SdkField
            .<List<ProvisioningArtifactOutput>> builder(MarshallingType.LIST)
            .memberName("ProvisioningArtifactOutputKeys")
            .getter(getter(DescribeProvisioningParametersResponse::provisioningArtifactOutputKeys))
            .setter(setter(Builder::provisioningArtifactOutputKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactOutputKeys")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROVISIONING_ARTIFACT_PARAMETERS_FIELD, CONSTRAINT_SUMMARIES_FIELD, USAGE_INSTRUCTIONS_FIELD,
                    TAG_OPTIONS_FIELD, PROVISIONING_ARTIFACT_PREFERENCES_FIELD, PROVISIONING_ARTIFACT_OUTPUTS_FIELD,
                    PROVISIONING_ARTIFACT_OUTPUT_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProvisioningArtifactParameter> provisioningArtifactParameters;

    private final List<ConstraintSummary> constraintSummaries;

    private final List<UsageInstruction> usageInstructions;

    private final List<TagOptionSummary> tagOptions;

    private final ProvisioningArtifactPreferences provisioningArtifactPreferences;

    private final List<ProvisioningArtifactOutput> provisioningArtifactOutputs;

    private final List<ProvisioningArtifactOutput> provisioningArtifactOutputKeys;

    private DescribeProvisioningParametersResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactParameters = builder.provisioningArtifactParameters;
        this.constraintSummaries = builder.constraintSummaries;
        this.usageInstructions = builder.usageInstructions;
        this.tagOptions = builder.tagOptions;
        this.provisioningArtifactPreferences = builder.provisioningArtifactPreferences;
        this.provisioningArtifactOutputs = builder.provisioningArtifactOutputs;
        this.provisioningArtifactOutputKeys = builder.provisioningArtifactOutputKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningArtifactParameters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningArtifactParameters() {
        return provisioningArtifactParameters != null && !(provisioningArtifactParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the parameters used to provision the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningArtifactParameters} method.
     * </p>
     * 
     * @return Information about the parameters used to provision the product.
     */
    public final List<ProvisioningArtifactParameter> provisioningArtifactParameters() {
        return provisioningArtifactParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConstraintSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConstraintSummaries() {
        return constraintSummaries != null && !(constraintSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the constraints used to provision the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConstraintSummaries} method.
     * </p>
     * 
     * @return Information about the constraints used to provision the product.
     */
    public final List<ConstraintSummary> constraintSummaries() {
        return constraintSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageInstructions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageInstructions() {
        return usageInstructions != null && !(usageInstructions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any additional metadata specifically related to the provisioning of the product. For example, see the
     * <code>Version</code> field of the CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageInstructions} method.
     * </p>
     * 
     * @return Any additional metadata specifically related to the provisioning of the product. For example, see the
     *         <code>Version</code> field of the CloudFormation template.
     */
    public final List<UsageInstruction> usageInstructions() {
        return usageInstructions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagOptions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagOptions() {
        return tagOptions != null && !(tagOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the TagOptions associated with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagOptions} method.
     * </p>
     * 
     * @return Information about the TagOptions associated with the resource.
     */
    public final List<TagOptionSummary> tagOptions() {
        return tagOptions;
    }

    /**
     * <p>
     * An object that contains information about preferences, such as Regions and accounts, for the provisioning
     * artifact.
     * </p>
     * 
     * @return An object that contains information about preferences, such as Regions and accounts, for the provisioning
     *         artifact.
     */
    public final ProvisioningArtifactPreferences provisioningArtifactPreferences() {
        return provisioningArtifactPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningArtifactOutputs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     *
     * @deprecated This property is deprecated and returns the Id and Description of the Provisioning Artifact. Use
     *             ProvisioningArtifactOutputKeys instead to get the Keys and Descriptions of the outputs.
     */
    @Deprecated
    public final boolean hasProvisioningArtifactOutputs() {
        return provisioningArtifactOutputs != null && !(provisioningArtifactOutputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output of the provisioning artifact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningArtifactOutputs} method.
     * </p>
     * 
     * @return The output of the provisioning artifact.
     * @deprecated This property is deprecated and returns the Id and Description of the Provisioning Artifact. Use
     *             ProvisioningArtifactOutputKeys instead to get the Keys and Descriptions of the outputs.
     */
    @Deprecated
    public final List<ProvisioningArtifactOutput> provisioningArtifactOutputs() {
        return provisioningArtifactOutputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningArtifactOutputKeys property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningArtifactOutputKeys() {
        return provisioningArtifactOutputKeys != null && !(provisioningArtifactOutputKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned product
     * launched from this provisioning artifact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningArtifactOutputKeys} method.
     * </p>
     * 
     * @return A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned
     *         product launched from this provisioning artifact.
     */
    public final List<ProvisioningArtifactOutput> provisioningArtifactOutputKeys() {
        return provisioningArtifactOutputKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasProvisioningArtifactParameters() ? provisioningArtifactParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConstraintSummaries() ? constraintSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageInstructions() ? usageInstructions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagOptions() ? tagOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningArtifactOutputs() ? provisioningArtifactOutputs() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasProvisioningArtifactOutputKeys() ? provisioningArtifactOutputKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningParametersResponse)) {
            return false;
        }
        DescribeProvisioningParametersResponse other = (DescribeProvisioningParametersResponse) obj;
        return hasProvisioningArtifactParameters() == other.hasProvisioningArtifactParameters()
                && Objects.equals(provisioningArtifactParameters(), other.provisioningArtifactParameters())
                && hasConstraintSummaries() == other.hasConstraintSummaries()
                && Objects.equals(constraintSummaries(), other.constraintSummaries())
                && hasUsageInstructions() == other.hasUsageInstructions()
                && Objects.equals(usageInstructions(), other.usageInstructions()) && hasTagOptions() == other.hasTagOptions()
                && Objects.equals(tagOptions(), other.tagOptions())
                && Objects.equals(provisioningArtifactPreferences(), other.provisioningArtifactPreferences())
                && hasProvisioningArtifactOutputs() == other.hasProvisioningArtifactOutputs()
                && Objects.equals(provisioningArtifactOutputs(), other.provisioningArtifactOutputs())
                && hasProvisioningArtifactOutputKeys() == other.hasProvisioningArtifactOutputKeys()
                && Objects.equals(provisioningArtifactOutputKeys(), other.provisioningArtifactOutputKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeProvisioningParametersResponse")
                .add("ProvisioningArtifactParameters",
                        hasProvisioningArtifactParameters() ? provisioningArtifactParameters() : null)
                .add("ConstraintSummaries", hasConstraintSummaries() ? constraintSummaries() : null)
                .add("UsageInstructions", hasUsageInstructions() ? usageInstructions() : null)
                .add("TagOptions", hasTagOptions() ? tagOptions() : null)
                .add("ProvisioningArtifactPreferences", provisioningArtifactPreferences())
                .add("ProvisioningArtifactOutputs", hasProvisioningArtifactOutputs() ? provisioningArtifactOutputs() : null)
                .add("ProvisioningArtifactOutputKeys",
                        hasProvisioningArtifactOutputKeys() ? provisioningArtifactOutputKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactParameters":
            return Optional.ofNullable(clazz.cast(provisioningArtifactParameters()));
        case "ConstraintSummaries":
            return Optional.ofNullable(clazz.cast(constraintSummaries()));
        case "UsageInstructions":
            return Optional.ofNullable(clazz.cast(usageInstructions()));
        case "TagOptions":
            return Optional.ofNullable(clazz.cast(tagOptions()));
        case "ProvisioningArtifactPreferences":
            return Optional.ofNullable(clazz.cast(provisioningArtifactPreferences()));
        case "ProvisioningArtifactOutputs":
            return Optional.ofNullable(clazz.cast(provisioningArtifactOutputs()));
        case "ProvisioningArtifactOutputKeys":
            return Optional.ofNullable(clazz.cast(provisioningArtifactOutputKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProvisioningArtifactParameters", PROVISIONING_ARTIFACT_PARAMETERS_FIELD);
        map.put("ConstraintSummaries", CONSTRAINT_SUMMARIES_FIELD);
        map.put("UsageInstructions", USAGE_INSTRUCTIONS_FIELD);
        map.put("TagOptions", TAG_OPTIONS_FIELD);
        map.put("ProvisioningArtifactPreferences", PROVISIONING_ARTIFACT_PREFERENCES_FIELD);
        map.put("ProvisioningArtifactOutputs", PROVISIONING_ARTIFACT_OUTPUTS_FIELD);
        map.put("ProvisioningArtifactOutputKeys", PROVISIONING_ARTIFACT_OUTPUT_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningParametersResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisioningParametersResponse> {
        /**
         * <p>
         * Information about the parameters used to provision the product.
         * </p>
         * 
         * @param provisioningArtifactParameters
         *        Information about the parameters used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactParameters(Collection<ProvisioningArtifactParameter> provisioningArtifactParameters);

        /**
         * <p>
         * Information about the parameters used to provision the product.
         * </p>
         * 
         * @param provisioningArtifactParameters
         *        Information about the parameters used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactParameters(ProvisioningArtifactParameter... provisioningArtifactParameters);

        /**
         * <p>
         * Information about the parameters used to provision the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisioningArtifactParameters(List<ProvisioningArtifactParameter>)}.
         * 
         * @param provisioningArtifactParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactParameters(java.util.Collection<ProvisioningArtifactParameter>)
         */
        Builder provisioningArtifactParameters(Consumer<ProvisioningArtifactParameter.Builder>... provisioningArtifactParameters);

        /**
         * <p>
         * Information about the constraints used to provision the product.
         * </p>
         * 
         * @param constraintSummaries
         *        Information about the constraints used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries);

        /**
         * <p>
         * Information about the constraints used to provision the product.
         * </p>
         * 
         * @param constraintSummaries
         *        Information about the constraints used to provision the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintSummaries(ConstraintSummary... constraintSummaries);

        /**
         * <p>
         * Information about the constraints used to provision the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #constraintSummaries(List<ConstraintSummary>)}.
         * 
         * @param constraintSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintSummaries(java.util.Collection<ConstraintSummary>)
         */
        Builder constraintSummaries(Consumer<ConstraintSummary.Builder>... constraintSummaries);

        /**
         * <p>
         * Any additional metadata specifically related to the provisioning of the product. For example, see the
         * <code>Version</code> field of the CloudFormation template.
         * </p>
         * 
         * @param usageInstructions
         *        Any additional metadata specifically related to the provisioning of the product. For example, see the
         *        <code>Version</code> field of the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageInstructions(Collection<UsageInstruction> usageInstructions);

        /**
         * <p>
         * Any additional metadata specifically related to the provisioning of the product. For example, see the
         * <code>Version</code> field of the CloudFormation template.
         * </p>
         * 
         * @param usageInstructions
         *        Any additional metadata specifically related to the provisioning of the product. For example, see the
         *        <code>Version</code> field of the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageInstructions(UsageInstruction... usageInstructions);

        /**
         * <p>
         * Any additional metadata specifically related to the provisioning of the product. For example, see the
         * <code>Version</code> field of the CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.UsageInstruction.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.UsageInstruction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.UsageInstruction.Builder#build()} is called
         * immediately and its result is passed to {@link #usageInstructions(List<UsageInstruction>)}.
         * 
         * @param usageInstructions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.UsageInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageInstructions(java.util.Collection<UsageInstruction>)
         */
        Builder usageInstructions(Consumer<UsageInstruction.Builder>... usageInstructions);

        /**
         * <p>
         * Information about the TagOptions associated with the resource.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(Collection<TagOptionSummary> tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the resource.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(TagOptionSummary... tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #tagOptions(List<TagOptionSummary>)}.
         * 
         * @param tagOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagOptions(java.util.Collection<TagOptionSummary>)
         */
        Builder tagOptions(Consumer<TagOptionSummary.Builder>... tagOptions);

        /**
         * <p>
         * An object that contains information about preferences, such as Regions and accounts, for the provisioning
         * artifact.
         * </p>
         * 
         * @param provisioningArtifactPreferences
         *        An object that contains information about preferences, such as Regions and accounts, for the
         *        provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactPreferences(ProvisioningArtifactPreferences provisioningArtifactPreferences);

        /**
         * <p>
         * An object that contains information about preferences, such as Regions and accounts, for the provisioning
         * artifact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningArtifactPreferences.Builder}
         * avoiding the need to create one manually via {@link ProvisioningArtifactPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningArtifactPreferences.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #provisioningArtifactPreferences(ProvisioningArtifactPreferences)}.
         * 
         * @param provisioningArtifactPreferences
         *        a consumer that will call methods on {@link ProvisioningArtifactPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactPreferences(ProvisioningArtifactPreferences)
         */
        default Builder provisioningArtifactPreferences(
                Consumer<ProvisioningArtifactPreferences.Builder> provisioningArtifactPreferences) {
            return provisioningArtifactPreferences(ProvisioningArtifactPreferences.builder()
                    .applyMutation(provisioningArtifactPreferences).build());
        }

        /**
         * <p>
         * The output of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactOutputs
         *        The output of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated and returns the Id and Description of the Provisioning Artifact. Use
         *             ProvisioningArtifactOutputKeys instead to get the Keys and Descriptions of the outputs.
         */
        @Deprecated
        Builder provisioningArtifactOutputs(Collection<ProvisioningArtifactOutput> provisioningArtifactOutputs);

        /**
         * <p>
         * The output of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactOutputs
         *        The output of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This property is deprecated and returns the Id and Description of the Provisioning Artifact. Use
         *             ProvisioningArtifactOutputKeys instead to get the Keys and Descriptions of the outputs.
         */
        @Deprecated
        Builder provisioningArtifactOutputs(ProvisioningArtifactOutput... provisioningArtifactOutputs);

        /**
         * <p>
         * The output of the provisioning artifact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisioningArtifactOutputs(List<ProvisioningArtifactOutput>)}.
         * 
         * @param provisioningArtifactOutputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactOutputs(java.util.Collection<ProvisioningArtifactOutput>)
         * @deprecated This property is deprecated and returns the Id and Description of the Provisioning Artifact. Use
         *             ProvisioningArtifactOutputKeys instead to get the Keys and Descriptions of the outputs.
         */
        @Deprecated
        Builder provisioningArtifactOutputs(Consumer<ProvisioningArtifactOutput.Builder>... provisioningArtifactOutputs);

        /**
         * <p>
         * A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned
         * product launched from this provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactOutputKeys
         *        A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned
         *        product launched from this provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactOutputKeys(Collection<ProvisioningArtifactOutput> provisioningArtifactOutputKeys);

        /**
         * <p>
         * A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned
         * product launched from this provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactOutputKeys
         *        A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned
         *        product launched from this provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactOutputKeys(ProvisioningArtifactOutput... provisioningArtifactOutputKeys);

        /**
         * <p>
         * A list of the keys and descriptions of the outputs. These outputs can be referenced from a provisioned
         * product launched from this provisioning artifact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisioningArtifactOutputKeys(List<ProvisioningArtifactOutput>)}.
         * 
         * @param provisioningArtifactOutputKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactOutputKeys(java.util.Collection<ProvisioningArtifactOutput>)
         */
        Builder provisioningArtifactOutputKeys(Consumer<ProvisioningArtifactOutput.Builder>... provisioningArtifactOutputKeys);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProvisioningArtifactParameter> provisioningArtifactParameters = DefaultSdkAutoConstructList.getInstance();

        private List<ConstraintSummary> constraintSummaries = DefaultSdkAutoConstructList.getInstance();

        private List<UsageInstruction> usageInstructions = DefaultSdkAutoConstructList.getInstance();

        private List<TagOptionSummary> tagOptions = DefaultSdkAutoConstructList.getInstance();

        private ProvisioningArtifactPreferences provisioningArtifactPreferences;

        private List<ProvisioningArtifactOutput> provisioningArtifactOutputs = DefaultSdkAutoConstructList.getInstance();

        private List<ProvisioningArtifactOutput> provisioningArtifactOutputKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningParametersResponse model) {
            super(model);
            provisioningArtifactParameters(model.provisioningArtifactParameters);
            constraintSummaries(model.constraintSummaries);
            usageInstructions(model.usageInstructions);
            tagOptions(model.tagOptions);
            provisioningArtifactPreferences(model.provisioningArtifactPreferences);
            provisioningArtifactOutputs(model.provisioningArtifactOutputs);
            provisioningArtifactOutputKeys(model.provisioningArtifactOutputKeys);
        }

        public final List<ProvisioningArtifactParameter.Builder> getProvisioningArtifactParameters() {
            List<ProvisioningArtifactParameter.Builder> result = ProvisioningArtifactParametersCopier
                    .copyToBuilder(this.provisioningArtifactParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningArtifactParameters(
                Collection<ProvisioningArtifactParameter.BuilderImpl> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier
                    .copyFromBuilder(provisioningArtifactParameters);
        }

        @Override
        public final Builder provisioningArtifactParameters(
                Collection<ProvisioningArtifactParameter> provisioningArtifactParameters) {
            this.provisioningArtifactParameters = ProvisioningArtifactParametersCopier.copy(provisioningArtifactParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(ProvisioningArtifactParameter... provisioningArtifactParameters) {
            provisioningArtifactParameters(Arrays.asList(provisioningArtifactParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactParameters(
                Consumer<ProvisioningArtifactParameter.Builder>... provisioningArtifactParameters) {
            provisioningArtifactParameters(Stream.of(provisioningArtifactParameters)
                    .map(c -> ProvisioningArtifactParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ConstraintSummary.Builder> getConstraintSummaries() {
            List<ConstraintSummary.Builder> result = ConstraintSummariesCopier.copyToBuilder(this.constraintSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary.BuilderImpl> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copyFromBuilder(constraintSummaries);
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary... constraintSummaries) {
            constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(Consumer<ConstraintSummary.Builder>... constraintSummaries) {
            constraintSummaries(Stream.of(constraintSummaries).map(c -> ConstraintSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UsageInstruction.Builder> getUsageInstructions() {
            List<UsageInstruction.Builder> result = UsageInstructionsCopier.copyToBuilder(this.usageInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageInstructions(Collection<UsageInstruction.BuilderImpl> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copyFromBuilder(usageInstructions);
        }

        @Override
        public final Builder usageInstructions(Collection<UsageInstruction> usageInstructions) {
            this.usageInstructions = UsageInstructionsCopier.copy(usageInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(UsageInstruction... usageInstructions) {
            usageInstructions(Arrays.asList(usageInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageInstructions(Consumer<UsageInstruction.Builder>... usageInstructions) {
            usageInstructions(Stream.of(usageInstructions).map(c -> UsageInstruction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TagOptionSummary.Builder> getTagOptions() {
            List<TagOptionSummary.Builder> result = TagOptionSummariesCopier.copyToBuilder(this.tagOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagOptions(Collection<TagOptionSummary.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copyFromBuilder(tagOptions);
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionSummary> tagOptions) {
            this.tagOptions = TagOptionSummariesCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionSummary... tagOptions) {
            tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionSummary.Builder>... tagOptions) {
            tagOptions(Stream.of(tagOptions).map(c -> TagOptionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ProvisioningArtifactPreferences.Builder getProvisioningArtifactPreferences() {
            return provisioningArtifactPreferences != null ? provisioningArtifactPreferences.toBuilder() : null;
        }

        public final void setProvisioningArtifactPreferences(
                ProvisioningArtifactPreferences.BuilderImpl provisioningArtifactPreferences) {
            this.provisioningArtifactPreferences = provisioningArtifactPreferences != null ? provisioningArtifactPreferences
                    .build() : null;
        }

        @Override
        public final Builder provisioningArtifactPreferences(ProvisioningArtifactPreferences provisioningArtifactPreferences) {
            this.provisioningArtifactPreferences = provisioningArtifactPreferences;
            return this;
        }

        @Deprecated
        public final List<ProvisioningArtifactOutput.Builder> getProvisioningArtifactOutputs() {
            List<ProvisioningArtifactOutput.Builder> result = ProvisioningArtifactOutputsCopier
                    .copyToBuilder(this.provisioningArtifactOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setProvisioningArtifactOutputs(
                Collection<ProvisioningArtifactOutput.BuilderImpl> provisioningArtifactOutputs) {
            this.provisioningArtifactOutputs = ProvisioningArtifactOutputsCopier.copyFromBuilder(provisioningArtifactOutputs);
        }

        @Override
        @Deprecated
        public final Builder provisioningArtifactOutputs(Collection<ProvisioningArtifactOutput> provisioningArtifactOutputs) {
            this.provisioningArtifactOutputs = ProvisioningArtifactOutputsCopier.copy(provisioningArtifactOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder provisioningArtifactOutputs(ProvisioningArtifactOutput... provisioningArtifactOutputs) {
            provisioningArtifactOutputs(Arrays.asList(provisioningArtifactOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder provisioningArtifactOutputs(
                Consumer<ProvisioningArtifactOutput.Builder>... provisioningArtifactOutputs) {
            provisioningArtifactOutputs(Stream.of(provisioningArtifactOutputs)
                    .map(c -> ProvisioningArtifactOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProvisioningArtifactOutput.Builder> getProvisioningArtifactOutputKeys() {
            List<ProvisioningArtifactOutput.Builder> result = ProvisioningArtifactOutputsCopier
                    .copyToBuilder(this.provisioningArtifactOutputKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningArtifactOutputKeys(
                Collection<ProvisioningArtifactOutput.BuilderImpl> provisioningArtifactOutputKeys) {
            this.provisioningArtifactOutputKeys = ProvisioningArtifactOutputsCopier
                    .copyFromBuilder(provisioningArtifactOutputKeys);
        }

        @Override
        public final Builder provisioningArtifactOutputKeys(Collection<ProvisioningArtifactOutput> provisioningArtifactOutputKeys) {
            this.provisioningArtifactOutputKeys = ProvisioningArtifactOutputsCopier.copy(provisioningArtifactOutputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactOutputKeys(ProvisioningArtifactOutput... provisioningArtifactOutputKeys) {
            provisioningArtifactOutputKeys(Arrays.asList(provisioningArtifactOutputKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactOutputKeys(
                Consumer<ProvisioningArtifactOutput.Builder>... provisioningArtifactOutputKeys) {
            provisioningArtifactOutputKeys(Stream.of(provisioningArtifactOutputKeys)
                    .map(c -> ProvisioningArtifactOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeProvisioningParametersResponse build() {
            return new DescribeProvisioningParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
