/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an execution parameter value that is passed to a self-service action when executed on a provisioned
 * product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionParameter.Builder, ExecutionParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ExecutionParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ExecutionParameter::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> DEFAULT_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DefaultValues")
            .getter(getter(ExecutionParameter::defaultValues))
            .setter(setter(Builder::defaultValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            DEFAULT_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final List<String> defaultValues;

    private ExecutionParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValues = builder.defaultValues;
    }

    /**
     * <p>
     * The name of the execution parameter.
     * </p>
     * 
     * @return The name of the execution parameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The execution parameter type.
     * </p>
     * 
     * @return The execution parameter type.
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultValues() {
        return defaultValues != null && !(defaultValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default values for the execution parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultValues} method.
     * </p>
     * 
     * @return The default values for the execution parameter.
     */
    public final List<String> defaultValues() {
        return defaultValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultValues() ? defaultValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionParameter)) {
            return false;
        }
        ExecutionParameter other = (ExecutionParameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && hasDefaultValues() == other.hasDefaultValues() && Objects.equals(defaultValues(), other.defaultValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionParameter").add("Name", name()).add("Type", type())
                .add("DefaultValues", hasDefaultValues() ? defaultValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "DefaultValues":
            return Optional.ofNullable(clazz.cast(defaultValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("DefaultValues", DEFAULT_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionParameter, T> g) {
        return obj -> g.apply((ExecutionParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionParameter> {
        /**
         * <p>
         * The name of the execution parameter.
         * </p>
         * 
         * @param name
         *        The name of the execution parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The execution parameter type.
         * </p>
         * 
         * @param type
         *        The execution parameter type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The default values for the execution parameter.
         * </p>
         * 
         * @param defaultValues
         *        The default values for the execution parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValues(Collection<String> defaultValues);

        /**
         * <p>
         * The default values for the execution parameter.
         * </p>
         * 
         * @param defaultValues
         *        The default values for the execution parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValues(String... defaultValues);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private List<String> defaultValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionParameter model) {
            name(model.name);
            type(model.type);
            defaultValues(model.defaultValues);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getDefaultValues() {
            if (defaultValues instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultValues;
        }

        public final void setDefaultValues(Collection<String> defaultValues) {
            this.defaultValues = ExecutionParameterValueListCopier.copy(defaultValues);
        }

        @Override
        public final Builder defaultValues(Collection<String> defaultValues) {
            this.defaultValues = ExecutionParameterValueListCopier.copy(defaultValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValues(String... defaultValues) {
            defaultValues(Arrays.asList(defaultValues));
            return this;
        }

        @Override
        public ExecutionParameter build() {
            return new ExecutionParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
