/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyUpdateProvisionedProductEngineWorkflowResultRequest extends ServiceCatalogRequest
        implements
        ToCopyableBuilder<NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder, NotifyUpdateProvisionedProductEngineWorkflowResultRequest> {
    private static final SdkField<String> WORKFLOW_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowToken").getter(getter(NotifyUpdateProvisionedProductEngineWorkflowResultRequest::workflowToken))
            .setter(setter(Builder::workflowToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowToken").build()).build();

    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(NotifyUpdateProvisionedProductEngineWorkflowResultRequest::recordId))
            .setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NotifyUpdateProvisionedProductEngineWorkflowResultRequest::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(NotifyUpdateProvisionedProductEngineWorkflowResultRequest::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<List<RecordOutput>> OUTPUTS_FIELD = SdkField
            .<List<RecordOutput>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(NotifyUpdateProvisionedProductEngineWorkflowResultRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(NotifyUpdateProvisionedProductEngineWorkflowResultRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TOKEN_FIELD,
            RECORD_ID_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, OUTPUTS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowToken;

    private final String recordId;

    private final String status;

    private final String failureReason;

    private final List<RecordOutput> outputs;

    private final String idempotencyToken;

    private NotifyUpdateProvisionedProductEngineWorkflowResultRequest(BuilderImpl builder) {
        super(builder);
        this.workflowToken = builder.workflowToken;
        this.recordId = builder.recordId;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.outputs = builder.outputs;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The encrypted contents of the update engine execution payload that Service Catalog sends after the Terraform
     * product update workflow starts.
     * </p>
     * 
     * @return The encrypted contents of the update engine execution payload that Service Catalog sends after the
     *         Terraform product update workflow starts.
     */
    public final String workflowToken() {
        return workflowToken;
    }

    /**
     * <p>
     * The identifier of the record.
     * </p>
     * 
     * @return The identifier of the record.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * <p>
     * The status of the update engine execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EngineWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the update engine execution.
     * @see EngineWorkflowStatus
     */
    public final EngineWorkflowStatus status() {
        return EngineWorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the update engine execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EngineWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the update engine execution.
     * @see EngineWorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason why the update engine execution failed.
     * </p>
     * 
     * @return The reason why the update engine execution failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output of the update engine execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The output of the update engine execution.
     */
    public final List<RecordOutput> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The idempotency token that identifies the update engine execution.
     * </p>
     * 
     * @return The idempotency token that identifies the update engine execution.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowToken());
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyUpdateProvisionedProductEngineWorkflowResultRequest)) {
            return false;
        }
        NotifyUpdateProvisionedProductEngineWorkflowResultRequest other = (NotifyUpdateProvisionedProductEngineWorkflowResultRequest) obj;
        return Objects.equals(workflowToken(), other.workflowToken()) && Objects.equals(recordId(), other.recordId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyUpdateProvisionedProductEngineWorkflowResultRequest")
                .add("WorkflowToken", workflowToken()).add("RecordId", recordId()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowToken":
            return Optional.ofNullable(clazz.cast(workflowToken()));
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowToken", WORKFLOW_TOKEN_FIELD);
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotifyUpdateProvisionedProductEngineWorkflowResultRequest, T> g) {
        return obj -> g.apply((NotifyUpdateProvisionedProductEngineWorkflowResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, NotifyUpdateProvisionedProductEngineWorkflowResultRequest> {
        /**
         * <p>
         * The encrypted contents of the update engine execution payload that Service Catalog sends after the Terraform
         * product update workflow starts.
         * </p>
         * 
         * @param workflowToken
         *        The encrypted contents of the update engine execution payload that Service Catalog sends after the
         *        Terraform product update workflow starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowToken(String workflowToken);

        /**
         * <p>
         * The identifier of the record.
         * </p>
         * 
         * @param recordId
         *        The identifier of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The status of the update engine execution.
         * </p>
         * 
         * @param status
         *        The status of the update engine execution.
         * @see EngineWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineWorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the update engine execution.
         * </p>
         * 
         * @param status
         *        The status of the update engine execution.
         * @see EngineWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineWorkflowStatus
         */
        Builder status(EngineWorkflowStatus status);

        /**
         * <p>
         * The reason why the update engine execution failed.
         * </p>
         * 
         * @param failureReason
         *        The reason why the update engine execution failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The output of the update engine execution.
         * </p>
         * 
         * @param outputs
         *        The output of the update engine execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<RecordOutput> outputs);

        /**
         * <p>
         * The output of the update engine execution.
         * </p>
         * 
         * @param outputs
         *        The output of the update engine execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(RecordOutput... outputs);

        /**
         * <p>
         * The output of the update engine execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<RecordOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<RecordOutput>)
         */
        Builder outputs(Consumer<RecordOutput.Builder>... outputs);

        /**
         * <p>
         * The idempotency token that identifies the update engine execution.
         * </p>
         * 
         * @param idempotencyToken
         *        The idempotency token that identifies the update engine execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String workflowToken;

        private String recordId;

        private String status;

        private String failureReason;

        private List<RecordOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyUpdateProvisionedProductEngineWorkflowResultRequest model) {
            super(model);
            workflowToken(model.workflowToken);
            recordId(model.recordId);
            status(model.status);
            failureReason(model.failureReason);
            outputs(model.outputs);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getWorkflowToken() {
            return workflowToken;
        }

        public final void setWorkflowToken(String workflowToken) {
            this.workflowToken = workflowToken;
        }

        @Override
        public final Builder workflowToken(String workflowToken) {
            this.workflowToken = workflowToken;
            return this;
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EngineWorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<RecordOutput.Builder> getOutputs() {
            List<RecordOutput.Builder> result = RecordOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<RecordOutput.BuilderImpl> outputs) {
            this.outputs = RecordOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<RecordOutput> outputs) {
            this.outputs = RecordOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(RecordOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<RecordOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> RecordOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyUpdateProvisionedProductEngineWorkflowResultRequest build() {
            return new NotifyUpdateProvisionedProductEngineWorkflowResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
