/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a provisioning artifact (also known as a version) for a product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningArtifactDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningArtifactDetail.Builder, ProvisioningArtifactDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProvisioningArtifactDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProvisioningArtifactDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ProvisioningArtifactDetail::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ProvisioningArtifactDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ProvisioningArtifactDetail::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Active").getter(getter(ProvisioningArtifactDetail::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final SdkField<String> GUIDANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Guidance").getter(getter(ProvisioningArtifactDetail::guidanceAsString))
            .setter(setter(Builder::guidance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Guidance").build()).build();

    private static final SdkField<String> SOURCE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRevision").getter(getter(ProvisioningArtifactDetail::sourceRevision))
            .setter(setter(Builder::sourceRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TYPE_FIELD, CREATED_TIME_FIELD, ACTIVE_FIELD, GUIDANCE_FIELD, SOURCE_REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String type;

    private final Instant createdTime;

    private final Boolean active;

    private final String guidance;

    private final String sourceRevision;

    private ProvisioningArtifactDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.createdTime = builder.createdTime;
        this.active = builder.active;
        this.guidance = builder.guidance;
        this.sourceRevision = builder.sourceRevision;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the provisioning artifact.
     * </p>
     * 
     * @return The name of the provisioning artifact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the provisioning artifact.
     * </p>
     * 
     * @return The description of the provisioning artifact.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of provisioning artifact.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXTERNAL</code> - External configuration file
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProvisioningArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of provisioning artifact.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXTERNAL</code> - External configuration file
     *         </p>
     *         </li>
     * @see ProvisioningArtifactType
     */
    public final ProvisioningArtifactType type() {
        return ProvisioningArtifactType.fromValue(type);
    }

    /**
     * <p>
     * The type of provisioning artifact.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXTERNAL</code> - External configuration file
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProvisioningArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of provisioning artifact.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXTERNAL</code> - External configuration file
     *         </p>
     *         </li>
     * @see ProvisioningArtifactType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The UTC time stamp of the creation time.
     * </p>
     * 
     * @return The UTC time stamp of the creation time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Indicates whether the product version is active.
     * </p>
     * 
     * @return Indicates whether the product version is active.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guidance} will
     * return {@link ProvisioningArtifactGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #guidanceAsString}.
     * </p>
     * 
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts
     *         to use.
     * @see ProvisioningArtifactGuidance
     */
    public final ProvisioningArtifactGuidance guidance() {
        return ProvisioningArtifactGuidance.fromValue(guidance);
    }

    /**
     * <p>
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guidance} will
     * return {@link ProvisioningArtifactGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #guidanceAsString}.
     * </p>
     * 
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts
     *         to use.
     * @see ProvisioningArtifactGuidance
     */
    public final String guidanceAsString() {
        return guidance;
    }

    /**
     * <p>
     * Specifies the revision of the external artifact that was used to automatically sync the Service Catalog product
     * and create the provisioning artifact. Service Catalog includes this response parameter as a high level field to
     * the existing <code>ProvisioningArtifactDetail</code> type, which is returned as part of the response for
     * <code>CreateProduct</code>, <code>UpdateProduct</code>, <code>DescribeProductAsAdmin</code>,
     * <code>DescribeProvisioningArtifact</code>, <code>ListProvisioningArtifact</code>, and
     * <code>UpdateProvisioningArticat</code> APIs.
     * </p>
     * <p>
     * This field only exists for Repo-Synced products.
     * </p>
     * 
     * @return Specifies the revision of the external artifact that was used to automatically sync the Service Catalog
     *         product and create the provisioning artifact. Service Catalog includes this response parameter as a high
     *         level field to the existing <code>ProvisioningArtifactDetail</code> type, which is returned as part of
     *         the response for <code>CreateProduct</code>, <code>UpdateProduct</code>,
     *         <code>DescribeProductAsAdmin</code>, <code>DescribeProvisioningArtifact</code>,
     *         <code>ListProvisioningArtifact</code>, and <code>UpdateProvisioningArticat</code> APIs. </p>
     *         <p>
     *         This field only exists for Repo-Synced products.
     */
    public final String sourceRevision() {
        return sourceRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(guidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactDetail)) {
            return false;
        }
        ProvisioningArtifactDetail other = (ProvisioningArtifactDetail) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(active(), other.active())
                && Objects.equals(guidanceAsString(), other.guidanceAsString())
                && Objects.equals(sourceRevision(), other.sourceRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningArtifactDetail").add("Id", id()).add("Name", name())
                .add("Description", description()).add("Type", typeAsString()).add("CreatedTime", createdTime())
                .add("Active", active()).add("Guidance", guidanceAsString()).add("SourceRevision", sourceRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "Guidance":
            return Optional.ofNullable(clazz.cast(guidanceAsString()));
        case "SourceRevision":
            return Optional.ofNullable(clazz.cast(sourceRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Active", ACTIVE_FIELD);
        map.put("Guidance", GUIDANCE_FIELD);
        map.put("SourceRevision", SOURCE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactDetail, T> g) {
        return obj -> g.apply((ProvisioningArtifactDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningArtifactDetail> {
        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param id
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the provisioning artifact.
         * </p>
         * 
         * @param name
         *        The name of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the provisioning artifact.
         * </p>
         * 
         * @param description
         *        The description of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of provisioning artifact.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXTERNAL</code> - External configuration file
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of provisioning artifact.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXTERNAL</code> - External configuration file
         *        </p>
         *        </li>
         * @see ProvisioningArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of provisioning artifact.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXTERNAL</code> - External configuration file
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of provisioning artifact.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUD_FORMATION_TEMPLATE</code> - CloudFormation template
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERRAFORM_OPEN_SOURCE</code> - Terraform Open Source configuration file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TERRAFORM_CLOUD</code> - Terraform Cloud configuration file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXTERNAL</code> - External configuration file
         *        </p>
         *        </li>
         * @see ProvisioningArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactType
         */
        Builder type(ProvisioningArtifactType type);

        /**
         * <p>
         * The UTC time stamp of the creation time.
         * </p>
         * 
         * @param createdTime
         *        The UTC time stamp of the creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Indicates whether the product version is active.
         * </p>
         * 
         * @param active
         *        Indicates whether the product version is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to
         * use.
         * </p>
         * 
         * @param guidance
         *        Information set by the administrator to provide guidance to end users about which provisioning
         *        artifacts to use.
         * @see ProvisioningArtifactGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactGuidance
         */
        Builder guidance(String guidance);

        /**
         * <p>
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to
         * use.
         * </p>
         * 
         * @param guidance
         *        Information set by the administrator to provide guidance to end users about which provisioning
         *        artifacts to use.
         * @see ProvisioningArtifactGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactGuidance
         */
        Builder guidance(ProvisioningArtifactGuidance guidance);

        /**
         * <p>
         * Specifies the revision of the external artifact that was used to automatically sync the Service Catalog
         * product and create the provisioning artifact. Service Catalog includes this response parameter as a high
         * level field to the existing <code>ProvisioningArtifactDetail</code> type, which is returned as part of the
         * response for <code>CreateProduct</code>, <code>UpdateProduct</code>, <code>DescribeProductAsAdmin</code>,
         * <code>DescribeProvisioningArtifact</code>, <code>ListProvisioningArtifact</code>, and
         * <code>UpdateProvisioningArticat</code> APIs.
         * </p>
         * <p>
         * This field only exists for Repo-Synced products.
         * </p>
         * 
         * @param sourceRevision
         *        Specifies the revision of the external artifact that was used to automatically sync the Service
         *        Catalog product and create the provisioning artifact. Service Catalog includes this response parameter
         *        as a high level field to the existing <code>ProvisioningArtifactDetail</code> type, which is returned
         *        as part of the response for <code>CreateProduct</code>, <code>UpdateProduct</code>,
         *        <code>DescribeProductAsAdmin</code>, <code>DescribeProvisioningArtifact</code>,
         *        <code>ListProvisioningArtifact</code>, and <code>UpdateProvisioningArticat</code> APIs. </p>
         *        <p>
         *        This field only exists for Repo-Synced products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRevision(String sourceRevision);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String type;

        private Instant createdTime;

        private Boolean active;

        private String guidance;

        private String sourceRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactDetail model) {
            id(model.id);
            name(model.name);
            description(model.description);
            type(model.type);
            createdTime(model.createdTime);
            active(model.active);
            guidance(model.guidance);
            sourceRevision(model.sourceRevision);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProvisioningArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getGuidance() {
            return guidance;
        }

        public final void setGuidance(String guidance) {
            this.guidance = guidance;
        }

        @Override
        public final Builder guidance(String guidance) {
            this.guidance = guidance;
            return this;
        }

        @Override
        public final Builder guidance(ProvisioningArtifactGuidance guidance) {
            this.guidance(guidance == null ? null : guidance.toString());
            return this;
        }

        public final String getSourceRevision() {
            return sourceRevision;
        }

        public final void setSourceRevision(String sourceRevision) {
            this.sourceRevision = sourceRevision;
        }

        @Override
        public final Builder sourceRevision(String sourceRevision) {
            this.sourceRevision = sourceRevision;
            return this;
        }

        @Override
        public ProvisioningArtifactDetail build() {
            return new ProvisioningArtifactDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
