/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a parameter used to provision a product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningArtifactParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningArtifactParameter.Builder, ProvisioningArtifactParameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterKey").getter(getter(ProvisioningArtifactParameter::parameterKey))
            .setter(setter(Builder::parameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(ProvisioningArtifactParameter::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> PARAMETER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterType").getter(getter(ProvisioningArtifactParameter::parameterType))
            .setter(setter(Builder::parameterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterType").build()).build();

    private static final SdkField<Boolean> IS_NO_ECHO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNoEcho").getter(getter(ProvisioningArtifactParameter::isNoEcho)).setter(setter(Builder::isNoEcho))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNoEcho").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ProvisioningArtifactParameter::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ParameterConstraints> PARAMETER_CONSTRAINTS_FIELD = SdkField
            .<ParameterConstraints> builder(MarshallingType.SDK_POJO).memberName("ParameterConstraints")
            .getter(getter(ProvisioningArtifactParameter::parameterConstraints)).setter(setter(Builder::parameterConstraints))
            .constructor(ParameterConstraints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterConstraints").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD,
            DEFAULT_VALUE_FIELD, PARAMETER_TYPE_FIELD, IS_NO_ECHO_FIELD, DESCRIPTION_FIELD, PARAMETER_CONSTRAINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterKey;

    private final String defaultValue;

    private final String parameterType;

    private final Boolean isNoEcho;

    private final String description;

    private final ParameterConstraints parameterConstraints;

    private ProvisioningArtifactParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.parameterType = builder.parameterType;
        this.isNoEcho = builder.isNoEcho;
        this.description = builder.description;
        this.parameterConstraints = builder.parameterConstraints;
    }

    /**
     * <p>
     * The parameter key.
     * </p>
     * 
     * @return The parameter key.
     */
    public final String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The default value.
     * </p>
     * 
     * @return The default value.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The parameter type.
     * </p>
     * 
     * @return The parameter type.
     */
    public final String parameterType() {
        return parameterType;
    }

    /**
     * <p>
     * If this value is true, the value for this parameter is obfuscated from view when the parameter is retrieved. This
     * parameter is used to hide sensitive information.
     * </p>
     * 
     * @return If this value is true, the value for this parameter is obfuscated from view when the parameter is
     *         retrieved. This parameter is used to hide sensitive information.
     */
    public final Boolean isNoEcho() {
        return isNoEcho;
    }

    /**
     * <p>
     * The description of the parameter.
     * </p>
     * 
     * @return The description of the parameter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Constraints that the administrator has put on a parameter.
     * </p>
     * 
     * @return Constraints that the administrator has put on a parameter.
     */
    public final ParameterConstraints parameterConstraints() {
        return parameterConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(parameterType());
        hashCode = 31 * hashCode + Objects.hashCode(isNoEcho());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parameterConstraints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactParameter)) {
            return false;
        }
        ProvisioningArtifactParameter other = (ProvisioningArtifactParameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(parameterType(), other.parameterType()) && Objects.equals(isNoEcho(), other.isNoEcho())
                && Objects.equals(description(), other.description())
                && Objects.equals(parameterConstraints(), other.parameterConstraints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningArtifactParameter").add("ParameterKey", parameterKey())
                .add("DefaultValue", defaultValue()).add("ParameterType", parameterType()).add("IsNoEcho", isNoEcho())
                .add("Description", description()).add("ParameterConstraints", parameterConstraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "ParameterType":
            return Optional.ofNullable(clazz.cast(parameterType()));
        case "IsNoEcho":
            return Optional.ofNullable(clazz.cast(isNoEcho()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ParameterConstraints":
            return Optional.ofNullable(clazz.cast(parameterConstraints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterKey", PARAMETER_KEY_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("ParameterType", PARAMETER_TYPE_FIELD);
        map.put("IsNoEcho", IS_NO_ECHO_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ParameterConstraints", PARAMETER_CONSTRAINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactParameter, T> g) {
        return obj -> g.apply((ProvisioningArtifactParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningArtifactParameter> {
        /**
         * <p>
         * The parameter key.
         * </p>
         * 
         * @param parameterKey
         *        The parameter key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The default value.
         * </p>
         * 
         * @param defaultValue
         *        The default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The parameter type.
         * </p>
         * 
         * @param parameterType
         *        The parameter type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterType(String parameterType);

        /**
         * <p>
         * If this value is true, the value for this parameter is obfuscated from view when the parameter is retrieved.
         * This parameter is used to hide sensitive information.
         * </p>
         * 
         * @param isNoEcho
         *        If this value is true, the value for this parameter is obfuscated from view when the parameter is
         *        retrieved. This parameter is used to hide sensitive information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNoEcho(Boolean isNoEcho);

        /**
         * <p>
         * The description of the parameter.
         * </p>
         * 
         * @param description
         *        The description of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Constraints that the administrator has put on a parameter.
         * </p>
         * 
         * @param parameterConstraints
         *        Constraints that the administrator has put on a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterConstraints(ParameterConstraints parameterConstraints);

        /**
         * <p>
         * Constraints that the administrator has put on a parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterConstraints.Builder} avoiding
         * the need to create one manually via {@link ParameterConstraints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterConstraints.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterConstraints(ParameterConstraints)}.
         * 
         * @param parameterConstraints
         *        a consumer that will call methods on {@link ParameterConstraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterConstraints(ParameterConstraints)
         */
        default Builder parameterConstraints(Consumer<ParameterConstraints.Builder> parameterConstraints) {
            return parameterConstraints(ParameterConstraints.builder().applyMutation(parameterConstraints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String defaultValue;

        private String parameterType;

        private Boolean isNoEcho;

        private String description;

        private ParameterConstraints parameterConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactParameter model) {
            parameterKey(model.parameterKey);
            defaultValue(model.defaultValue);
            parameterType(model.parameterType);
            isNoEcho(model.isNoEcho);
            description(model.description);
            parameterConstraints(model.parameterConstraints);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getParameterType() {
            return parameterType;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public final Boolean getIsNoEcho() {
            return isNoEcho;
        }

        public final void setIsNoEcho(Boolean isNoEcho) {
            this.isNoEcho = isNoEcho;
        }

        @Override
        public final Builder isNoEcho(Boolean isNoEcho) {
            this.isNoEcho = isNoEcho;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ParameterConstraints.Builder getParameterConstraints() {
            return parameterConstraints != null ? parameterConstraints.toBuilder() : null;
        }

        public final void setParameterConstraints(ParameterConstraints.BuilderImpl parameterConstraints) {
            this.parameterConstraints = parameterConstraints != null ? parameterConstraints.build() : null;
        }

        @Override
        public final Builder parameterConstraints(ParameterConstraints parameterConstraints) {
            this.parameterConstraints = parameterConstraints;
            return this;
        }

        @Override
        public ProvisioningArtifactParameter build() {
            return new ProvisioningArtifactParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
