/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdateProductRequest.Builder, UpdateProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(UpdateProductRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateProductRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateProductRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(UpdateProductRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateProductRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Distributor").getter(getter(UpdateProductRequest::distributor)).setter(setter(Builder::distributor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()).build();

    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportDescription").getter(getter(UpdateProductRequest::supportDescription))
            .setter(setter(Builder::supportDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build())
            .build();

    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportEmail").getter(getter(UpdateProductRequest::supportEmail)).setter(setter(Builder::supportEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()).build();

    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportUrl").getter(getter(UpdateProductRequest::supportUrl)).setter(setter(Builder::supportUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()).build();

    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("AddTags")
            .getter(getter(UpdateProductRequest::addTags))
            .setter(setter(Builder::addTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveTags")
            .getter(getter(UpdateProductRequest::removeTags))
            .setter(setter(Builder::removeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SourceConnection> SOURCE_CONNECTION_FIELD = SdkField
            .<SourceConnection> builder(MarshallingType.SDK_POJO).memberName("SourceConnection")
            .getter(getter(UpdateProductRequest::sourceConnection)).setter(setter(Builder::sourceConnection))
            .constructor(SourceConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            ID_FIELD, NAME_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, DISTRIBUTOR_FIELD, SUPPORT_DESCRIPTION_FIELD,
            SUPPORT_EMAIL_FIELD, SUPPORT_URL_FIELD, ADD_TAGS_FIELD, REMOVE_TAGS_FIELD, SOURCE_CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String id;

    private final String name;

    private final String owner;

    private final String description;

    private final String distributor;

    private final String supportDescription;

    private final String supportEmail;

    private final String supportUrl;

    private final List<Tag> addTags;

    private final List<String> removeTags;

    private final SourceConnection sourceConnection;

    private UpdateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
        this.sourceConnection = builder.sourceConnection;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The updated product name.
     * </p>
     * 
     * @return The updated product name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated owner of the product.
     * </p>
     * 
     * @return The updated owner of the product.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The updated description of the product.
     * </p>
     * 
     * @return The updated description of the product.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated distributor of the product.
     * </p>
     * 
     * @return The updated distributor of the product.
     */
    public final String distributor() {
        return distributor;
    }

    /**
     * <p>
     * The updated support description for the product.
     * </p>
     * 
     * @return The updated support description for the product.
     */
    public final String supportDescription() {
        return supportDescription;
    }

    /**
     * <p>
     * The updated support email for the product.
     * </p>
     * 
     * @return The updated support email for the product.
     */
    public final String supportEmail() {
        return supportEmail;
    }

    /**
     * <p>
     * The updated support URL for the product.
     * </p>
     * 
     * @return The updated support URL for the product.
     */
    public final String supportUrl() {
        return supportUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddTags() {
        return addTags != null && !(addTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddTags} method.
     * </p>
     * 
     * @return The tags to add to the product.
     */
    public final List<Tag> addTags() {
        return addTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRemoveTags() {
        return removeTags != null && !(removeTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to remove from the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveTags} method.
     * </p>
     * 
     * @return The tags to remove from the product.
     */
    public final List<String> removeTags() {
        return removeTags;
    }

    /**
     * <p>
     * Specifies connection details for the updated product and syncs the product to the connection source artifact.
     * This automatically manages the product's artifacts based on changes to the source. The
     * <code>SourceConnection</code> parameter consists of the following sub-fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConnectionParamters</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies connection details for the updated product and syncs the product to the connection source
     *         artifact. This automatically manages the product's artifacts based on changes to the source. The
     *         <code>SourceConnection</code> parameter consists of the following sub-fields.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ConnectionParamters</code>
     *         </p>
     *         </li>
     */
    public final SourceConnection sourceConnection() {
        return sourceConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(distributor());
        hashCode = 31 * hashCode + Objects.hashCode(supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddTags() ? addTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveTags() ? removeTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRequest)) {
            return false;
        }
        UpdateProductRequest other = (UpdateProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(owner(), other.owner())
                && Objects.equals(description(), other.description()) && Objects.equals(distributor(), other.distributor())
                && Objects.equals(supportDescription(), other.supportDescription())
                && Objects.equals(supportEmail(), other.supportEmail()) && Objects.equals(supportUrl(), other.supportUrl())
                && hasAddTags() == other.hasAddTags() && Objects.equals(addTags(), other.addTags())
                && hasRemoveTags() == other.hasRemoveTags() && Objects.equals(removeTags(), other.removeTags())
                && Objects.equals(sourceConnection(), other.sourceConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProductRequest").add("AcceptLanguage", acceptLanguage()).add("Id", id())
                .add("Name", name()).add("Owner", owner()).add("Description", description()).add("Distributor", distributor())
                .add("SupportDescription", supportDescription()).add("SupportEmail", supportEmail())
                .add("SupportUrl", supportUrl()).add("AddTags", hasAddTags() ? addTags() : null)
                .add("RemoveTags", hasRemoveTags() ? removeTags() : null).add("SourceConnection", sourceConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Distributor":
            return Optional.ofNullable(clazz.cast(distributor()));
        case "SupportDescription":
            return Optional.ofNullable(clazz.cast(supportDescription()));
        case "SupportEmail":
            return Optional.ofNullable(clazz.cast(supportEmail()));
        case "SupportUrl":
            return Optional.ofNullable(clazz.cast(supportUrl()));
        case "AddTags":
            return Optional.ofNullable(clazz.cast(addTags()));
        case "RemoveTags":
            return Optional.ofNullable(clazz.cast(removeTags()));
        case "SourceConnection":
            return Optional.ofNullable(clazz.cast(sourceConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Distributor", DISTRIBUTOR_FIELD);
        map.put("SupportDescription", SUPPORT_DESCRIPTION_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportUrl", SUPPORT_URL_FIELD);
        map.put("AddTags", ADD_TAGS_FIELD);
        map.put("RemoveTags", REMOVE_TAGS_FIELD);
        map.put("SourceConnection", SOURCE_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProductRequest, T> g) {
        return obj -> g.apply((UpdateProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param id
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The updated product name.
         * </p>
         * 
         * @param name
         *        The updated product name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated owner of the product.
         * </p>
         * 
         * @param owner
         *        The updated owner of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The updated description of the product.
         * </p>
         * 
         * @param description
         *        The updated description of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated distributor of the product.
         * </p>
         * 
         * @param distributor
         *        The updated distributor of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributor(String distributor);

        /**
         * <p>
         * The updated support description for the product.
         * </p>
         * 
         * @param supportDescription
         *        The updated support description for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportDescription(String supportDescription);

        /**
         * <p>
         * The updated support email for the product.
         * </p>
         * 
         * @param supportEmail
         *        The updated support email for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportEmail(String supportEmail);

        /**
         * <p>
         * The updated support URL for the product.
         * </p>
         * 
         * @param supportUrl
         *        The updated support URL for the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportUrl(String supportUrl);

        /**
         * <p>
         * The tags to add to the product.
         * </p>
         * 
         * @param addTags
         *        The tags to add to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Collection<Tag> addTags);

        /**
         * <p>
         * The tags to add to the product.
         * </p>
         * 
         * @param addTags
         *        The tags to add to the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Tag... addTags);

        /**
         * <p>
         * The tags to add to the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.servicecatalog.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #addTags(List<Tag>)}.
         * 
         * @param addTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addTags(java.util.Collection<Tag>)
         */
        Builder addTags(Consumer<Tag.Builder>... addTags);

        /**
         * <p>
         * The tags to remove from the product.
         * </p>
         * 
         * @param removeTags
         *        The tags to remove from the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTags(Collection<String> removeTags);

        /**
         * <p>
         * The tags to remove from the product.
         * </p>
         * 
         * @param removeTags
         *        The tags to remove from the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTags(String... removeTags);

        /**
         * <p>
         * Specifies connection details for the updated product and syncs the product to the connection source artifact.
         * This automatically manages the product's artifacts based on changes to the source. The
         * <code>SourceConnection</code> parameter consists of the following sub-fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConnectionParamters</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceConnection
         *        Specifies connection details for the updated product and syncs the product to the connection source
         *        artifact. This automatically manages the product's artifacts based on changes to the source. The
         *        <code>SourceConnection</code> parameter consists of the following sub-fields.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ConnectionParamters</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConnection(SourceConnection sourceConnection);

        /**
         * <p>
         * Specifies connection details for the updated product and syncs the product to the connection source artifact.
         * This automatically manages the product's artifacts based on changes to the source. The
         * <code>SourceConnection</code> parameter consists of the following sub-fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ConnectionParamters</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SourceConnection.Builder} avoiding the
         * need to create one manually via {@link SourceConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceConnection(SourceConnection)}.
         * 
         * @param sourceConnection
         *        a consumer that will call methods on {@link SourceConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConnection(SourceConnection)
         */
        default Builder sourceConnection(Consumer<SourceConnection.Builder> sourceConnection) {
            return sourceConnection(SourceConnection.builder().applyMutation(sourceConnection).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String id;

        private String name;

        private String owner;

        private String description;

        private String distributor;

        private String supportDescription;

        private String supportEmail;

        private String supportUrl;

        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeTags = DefaultSdkAutoConstructList.getInstance();

        private SourceConnection sourceConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            id(model.id);
            name(model.name);
            owner(model.owner);
            description(model.description);
            distributor(model.distributor);
            supportDescription(model.supportDescription);
            supportEmail(model.supportEmail);
            supportUrl(model.supportUrl);
            addTags(model.addTags);
            removeTags(model.removeTags);
            sourceConnection(model.sourceConnection);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDistributor() {
            return distributor;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final String getSupportDescription() {
            return supportDescription;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final String getSupportEmail() {
            return supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportUrl() {
            return supportUrl;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final List<Tag.Builder> getAddTags() {
            List<Tag.Builder> result = AddTagsCopier.copyToBuilder(this.addTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder>... addTags) {
            addTags(Stream.of(addTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveTags() {
            if (removeTags instanceof SdkAutoConstructList) {
                return null;
            }
            return removeTags;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String... removeTags) {
            removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final SourceConnection.Builder getSourceConnection() {
            return sourceConnection != null ? sourceConnection.toBuilder() : null;
        }

        public final void setSourceConnection(SourceConnection.BuilderImpl sourceConnection) {
            this.sourceConnection = sourceConnection != null ? sourceConnection.build() : null;
        }

        @Override
        public final Builder sourceConnection(SourceConnection sourceConnection) {
            this.sourceConnection = sourceConnection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
