/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameter key-value pair used to update a provisioned product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisioningParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateProvisioningParameter.Builder, UpdateProvisioningParameter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(UpdateProvisioningParameter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(UpdateProvisioningParameter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Boolean> USE_PREVIOUS_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UsePreviousValue").getter(getter(UpdateProvisioningParameter::usePreviousValue))
            .setter(setter(Builder::usePreviousValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            USE_PREVIOUS_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final Boolean usePreviousValue;

    private UpdateProvisioningParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.usePreviousValue = builder.usePreviousValue;
    }

    /**
     * <p>
     * The parameter key.
     * </p>
     * 
     * @return The parameter key.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The parameter value.
     * </p>
     * 
     * @return The parameter value.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * If set to true, <code>Value</code> is ignored and the previous parameter value is kept.
     * </p>
     * 
     * @return If set to true, <code>Value</code> is ignored and the previous parameter value is kept.
     */
    public final Boolean usePreviousValue() {
        return usePreviousValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(usePreviousValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningParameter)) {
            return false;
        }
        UpdateProvisioningParameter other = (UpdateProvisioningParameter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(usePreviousValue(), other.usePreviousValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProvisioningParameter").add("Key", key()).add("Value", value())
                .add("UsePreviousValue", usePreviousValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "UsePreviousValue":
            return Optional.ofNullable(clazz.cast(usePreviousValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("UsePreviousValue", USE_PREVIOUS_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningParameter, T> g) {
        return obj -> g.apply((UpdateProvisioningParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateProvisioningParameter> {
        /**
         * <p>
         * The parameter key.
         * </p>
         * 
         * @param key
         *        The parameter key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The parameter value.
         * </p>
         * 
         * @param value
         *        The parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * If set to true, <code>Value</code> is ignored and the previous parameter value is kept.
         * </p>
         * 
         * @param usePreviousValue
         *        If set to true, <code>Value</code> is ignored and the previous parameter value is kept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePreviousValue(Boolean usePreviousValue);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private Boolean usePreviousValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningParameter model) {
            key(model.key);
            value(model.value);
            usePreviousValue(model.usePreviousValue);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getUsePreviousValue() {
            return usePreviousValue;
        }

        public final void setUsePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
        }

        @Override
        public final Builder usePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
            return this;
        }

        @Override
        public UpdateProvisioningParameter build() {
            return new UpdateProvisioningParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
