/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The access level to use to filter results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLevelFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessLevelFilter.Builder, AccessLevelFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(AccessLevelFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(AccessLevelFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private AccessLevelFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The access level.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Account</code> - Filter results based on the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Role</code> - Filter results based on the federated role of the specified user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>User</code> - Filter results based on the specified user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AccessLevelFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The access level.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Account</code> - Filter results based on the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Role</code> - Filter results based on the federated role of the specified user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>User</code> - Filter results based on the specified user.
     *         </p>
     *         </li>
     * @see AccessLevelFilterKey
     */
    public final AccessLevelFilterKey key() {
        return AccessLevelFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The access level.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Account</code> - Filter results based on the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Role</code> - Filter results based on the federated role of the specified user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>User</code> - Filter results based on the specified user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AccessLevelFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The access level.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Account</code> - Filter results based on the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Role</code> - Filter results based on the federated role of the specified user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>User</code> - Filter results based on the specified user.
     *         </p>
     *         </li>
     * @see AccessLevelFilterKey
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The user to which the access level applies. The only supported value is <code>self</code>.
     * </p>
     * 
     * @return The user to which the access level applies. The only supported value is <code>self</code>.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLevelFilter)) {
            return false;
        }
        AccessLevelFilter other = (AccessLevelFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessLevelFilter").add("Key", keyAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessLevelFilter, T> g) {
        return obj -> g.apply((AccessLevelFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessLevelFilter> {
        /**
         * <p>
         * The access level.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Account</code> - Filter results based on the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Role</code> - Filter results based on the federated role of the specified user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>User</code> - Filter results based on the specified user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The access level.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Account</code> - Filter results based on the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Role</code> - Filter results based on the federated role of the specified user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>User</code> - Filter results based on the specified user.
         *        </p>
         *        </li>
         * @see AccessLevelFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessLevelFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The access level.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Account</code> - Filter results based on the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Role</code> - Filter results based on the federated role of the specified user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>User</code> - Filter results based on the specified user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The access level.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Account</code> - Filter results based on the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Role</code> - Filter results based on the federated role of the specified user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>User</code> - Filter results based on the specified user.
         *        </p>
         *        </li>
         * @see AccessLevelFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessLevelFilterKey
         */
        Builder key(AccessLevelFilterKey key);

        /**
         * <p>
         * The user to which the access level applies. The only supported value is <code>self</code>.
         * </p>
         * 
         * @param value
         *        The user to which the access level applies. The only supported value is <code>self</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLevelFilter model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(AccessLevelFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public AccessLevelFilter build() {
            return new AccessLevelFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
