/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The subtype containing details about the Codestar connection <code>Type</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeStarParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeStarParameters.Builder, CodeStarParameters> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(CodeStarParameters::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Repository").getter(getter(CodeStarParameters::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()).build();

    private static final SdkField<String> BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Branch")
            .getter(getter(CodeStarParameters::branch)).setter(setter(Builder::branch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()).build();

    private static final SdkField<String> ARTIFACT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactPath").getter(getter(CodeStarParameters::artifactPath)).setter(setter(Builder::artifactPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            REPOSITORY_FIELD, BRANCH_FIELD, ARTIFACT_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionArn;

    private final String repository;

    private final String branch;

    private final String artifactPath;

    private CodeStarParameters(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.repository = builder.repository;
        this.branch = builder.branch;
        this.artifactPath = builder.artifactPath;
    }

    /**
     * <p>
     * The CodeStar ARN, which is the connection between Service Catalog and the external repository.
     * </p>
     * 
     * @return The CodeStar ARN, which is the connection between Service Catalog and the external repository.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The specific repository where the product’s artifact-to-be-synced resides, formatted as "Account/Repo."
     * </p>
     * 
     * @return The specific repository where the product’s artifact-to-be-synced resides, formatted as "Account/Repo."
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The specific branch where the artifact resides.
     * </p>
     * 
     * @return The specific branch where the artifact resides.
     */
    public final String branch() {
        return branch;
    }

    /**
     * <p>
     * The absolute path wehre the artifact resides within the repo and branch, formatted as "folder/file.json."
     * </p>
     * 
     * @return The absolute path wehre the artifact resides within the repo and branch, formatted as "folder/file.json."
     */
    public final String artifactPath() {
        return artifactPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(artifactPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeStarParameters)) {
            return false;
        }
        CodeStarParameters other = (CodeStarParameters) obj;
        return Objects.equals(connectionArn(), other.connectionArn()) && Objects.equals(repository(), other.repository())
                && Objects.equals(branch(), other.branch()) && Objects.equals(artifactPath(), other.artifactPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeStarParameters").add("ConnectionArn", connectionArn()).add("Repository", repository())
                .add("Branch", branch()).add("ArtifactPath", artifactPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "Repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "Branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "ArtifactPath":
            return Optional.ofNullable(clazz.cast(artifactPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("Repository", REPOSITORY_FIELD);
        map.put("Branch", BRANCH_FIELD);
        map.put("ArtifactPath", ARTIFACT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeStarParameters, T> g) {
        return obj -> g.apply((CodeStarParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeStarParameters> {
        /**
         * <p>
         * The CodeStar ARN, which is the connection between Service Catalog and the external repository.
         * </p>
         * 
         * @param connectionArn
         *        The CodeStar ARN, which is the connection between Service Catalog and the external repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The specific repository where the product’s artifact-to-be-synced resides, formatted as "Account/Repo."
         * </p>
         * 
         * @param repository
         *        The specific repository where the product’s artifact-to-be-synced resides, formatted as
         *        "Account/Repo."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The specific branch where the artifact resides.
         * </p>
         * 
         * @param branch
         *        The specific branch where the artifact resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(String branch);

        /**
         * <p>
         * The absolute path wehre the artifact resides within the repo and branch, formatted as "folder/file.json."
         * </p>
         * 
         * @param artifactPath
         *        The absolute path wehre the artifact resides within the repo and branch, formatted as
         *        "folder/file.json."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactPath(String artifactPath);
    }

    static final class BuilderImpl implements Builder {
        private String connectionArn;

        private String repository;

        private String branch;

        private String artifactPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeStarParameters model) {
            connectionArn(model.connectionArn);
            repository(model.repository);
            branch(model.branch);
            artifactPath(model.artifactPath);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getBranch() {
            return branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getArtifactPath() {
            return artifactPath;
        }

        public final void setArtifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
        }

        @Override
        public final Builder artifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
            return this;
        }

        @Override
        public CodeStarParameters build() {
            return new CodeStarParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
