/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecordResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeRecordResponse.Builder, DescribeRecordResponse> {
    private static final SdkField<RecordDetail> RECORD_DETAIL_FIELD = SdkField.<RecordDetail> builder(MarshallingType.SDK_POJO)
            .memberName("RecordDetail").getter(getter(DescribeRecordResponse::recordDetail))
            .setter(setter(Builder::recordDetail)).constructor(RecordDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordDetail").build()).build();

    private static final SdkField<List<RecordOutput>> RECORD_OUTPUTS_FIELD = SdkField
            .<List<RecordOutput>> builder(MarshallingType.LIST)
            .memberName("RecordOutputs")
            .getter(getter(DescribeRecordResponse::recordOutputs))
            .setter(setter(Builder::recordOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordOutputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(DescribeRecordResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_DETAIL_FIELD,
            RECORD_OUTPUTS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RecordDetail recordDetail;

    private final List<RecordOutput> recordOutputs;

    private final String nextPageToken;

    private DescribeRecordResponse(BuilderImpl builder) {
        super(builder);
        this.recordDetail = builder.recordDetail;
        this.recordOutputs = builder.recordOutputs;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * Information about the product.
     * </p>
     * 
     * @return Information about the product.
     */
    public final RecordDetail recordDetail() {
        return recordDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordOutputs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordOutputs() {
        return recordOutputs != null && !(recordOutputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the product created as the result of a request. For example, the output for a
     * CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordOutputs} method.
     * </p>
     * 
     * @return Information about the product created as the result of a request. For example, the output for a
     *         CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
     */
    public final List<RecordOutput> recordOutputs() {
        return recordOutputs;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recordDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordOutputs() ? recordOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecordResponse)) {
            return false;
        }
        DescribeRecordResponse other = (DescribeRecordResponse) obj;
        return Objects.equals(recordDetail(), other.recordDetail()) && hasRecordOutputs() == other.hasRecordOutputs()
                && Objects.equals(recordOutputs(), other.recordOutputs())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecordResponse").add("RecordDetail", recordDetail())
                .add("RecordOutputs", hasRecordOutputs() ? recordOutputs() : null).add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordDetail":
            return Optional.ofNullable(clazz.cast(recordDetail()));
        case "RecordOutputs":
            return Optional.ofNullable(clazz.cast(recordOutputs()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordDetail", RECORD_DETAIL_FIELD);
        map.put("RecordOutputs", RECORD_OUTPUTS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecordResponse, T> g) {
        return obj -> g.apply((DescribeRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecordResponse> {
        /**
         * <p>
         * Information about the product.
         * </p>
         * 
         * @param recordDetail
         *        Information about the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordDetail(RecordDetail recordDetail);

        /**
         * <p>
         * Information about the product.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordDetail.Builder} avoiding the need
         * to create one manually via {@link RecordDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #recordDetail(RecordDetail)}.
         * 
         * @param recordDetail
         *        a consumer that will call methods on {@link RecordDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordDetail(RecordDetail)
         */
        default Builder recordDetail(Consumer<RecordDetail.Builder> recordDetail) {
            return recordDetail(RecordDetail.builder().applyMutation(recordDetail).build());
        }

        /**
         * <p>
         * Information about the product created as the result of a request. For example, the output for a
         * CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
         * </p>
         * 
         * @param recordOutputs
         *        Information about the product created as the result of a request. For example, the output for a
         *        CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordOutputs(Collection<RecordOutput> recordOutputs);

        /**
         * <p>
         * Information about the product created as the result of a request. For example, the output for a
         * CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
         * </p>
         * 
         * @param recordOutputs
         *        Information about the product created as the result of a request. For example, the output for a
         *        CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordOutputs(RecordOutput... recordOutputs);

        /**
         * <p>
         * Information about the product created as the result of a request. For example, the output for a
         * CloudFormation-backed product that creates an S3 bucket would include the S3 bucket URL.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #recordOutputs(List<RecordOutput>)}.
         * 
         * @param recordOutputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.RecordOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordOutputs(java.util.Collection<RecordOutput>)
         */
        Builder recordOutputs(Consumer<RecordOutput.Builder>... recordOutputs);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private RecordDetail recordDetail;

        private List<RecordOutput> recordOutputs = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecordResponse model) {
            super(model);
            recordDetail(model.recordDetail);
            recordOutputs(model.recordOutputs);
            nextPageToken(model.nextPageToken);
        }

        public final RecordDetail.Builder getRecordDetail() {
            return recordDetail != null ? recordDetail.toBuilder() : null;
        }

        public final void setRecordDetail(RecordDetail.BuilderImpl recordDetail) {
            this.recordDetail = recordDetail != null ? recordDetail.build() : null;
        }

        @Override
        public final Builder recordDetail(RecordDetail recordDetail) {
            this.recordDetail = recordDetail;
            return this;
        }

        public final List<RecordOutput.Builder> getRecordOutputs() {
            List<RecordOutput.Builder> result = RecordOutputsCopier.copyToBuilder(this.recordOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordOutputs(Collection<RecordOutput.BuilderImpl> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copyFromBuilder(recordOutputs);
        }

        @Override
        public final Builder recordOutputs(Collection<RecordOutput> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copy(recordOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordOutputs(RecordOutput... recordOutputs) {
            recordOutputs(Arrays.asList(recordOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordOutputs(Consumer<RecordOutput.Builder>... recordOutputs) {
            recordOutputs(Stream.of(recordOutputs).map(c -> RecordOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public DescribeRecordResponse build() {
            return new DescribeRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
