/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a provisioned product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedProductDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedProductDetail.Builder, ProvisionedProductDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProvisionedProductDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ProvisionedProductDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ProvisionedProductDetail::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProvisionedProductDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProvisionedProductDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProvisionedProductDetail::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ProvisionedProductDetail::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(ProvisionedProductDetail::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<String> LAST_RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRecordId").getter(getter(ProvisionedProductDetail::lastRecordId))
            .setter(setter(Builder::lastRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecordId").build()).build();

    private static final SdkField<String> LAST_PROVISIONING_RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastProvisioningRecordId").getter(getter(ProvisionedProductDetail::lastProvisioningRecordId))
            .setter(setter(Builder::lastProvisioningRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProvisioningRecordId").build())
            .build();

    private static final SdkField<String> LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastSuccessfulProvisioningRecordId")
            .getter(getter(ProvisionedProductDetail::lastSuccessfulProvisioningRecordId))
            .setter(setter(Builder::lastSuccessfulProvisioningRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulProvisioningRecordId")
                    .build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ProvisionedProductDetail::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(ProvisionedProductDetail::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> LAUNCH_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchRoleArn").getter(getter(ProvisionedProductDetail::launchRoleArn))
            .setter(setter(Builder::launchRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            TYPE_FIELD, ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_TIME_FIELD, IDEMPOTENCY_TOKEN_FIELD,
            LAST_RECORD_ID_FIELD, LAST_PROVISIONING_RECORD_ID_FIELD, LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD,
            PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, LAUNCH_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String type;

    private final String id;

    private final String status;

    private final String statusMessage;

    private final Instant createdTime;

    private final String idempotencyToken;

    private final String lastRecordId;

    private final String lastProvisioningRecordId;

    private final String lastSuccessfulProvisioningRecordId;

    private final String productId;

    private final String provisioningArtifactId;

    private final String launchRoleArn;

    private ProvisionedProductDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.type = builder.type;
        this.id = builder.id;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.idempotencyToken = builder.idempotencyToken;
        this.lastRecordId = builder.lastRecordId;
        this.lastProvisioningRecordId = builder.lastProvisioningRecordId;
        this.lastSuccessfulProvisioningRecordId = builder.lastSuccessfulProvisioningRecordId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.launchRoleArn = builder.launchRoleArn;
    }

    /**
     * <p>
     * The user-friendly name of the provisioned product.
     * </p>
     * 
     * @return The user-friendly name of the provisioned product.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the provisioned product.
     * </p>
     * 
     * @return The ARN of the provisioned product.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of provisioned product. The supported values are <code>CFN_STACK</code>, <code>CFN_STACKSET</code>,
     * <code>TERRAFORM_OPEN_SOURCE</code>, <code>TERRAFORM_CLOUD</code>, and <code>EXTERNAL</code>.
     * </p>
     * 
     * @return The type of provisioned product. The supported values are <code>CFN_STACK</code>,
     *         <code>CFN_STACKSET</code>, <code>TERRAFORM_OPEN_SOURCE</code>, <code>TERRAFORM_CLOUD</code>, and
     *         <code>EXTERNAL</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The identifier of the provisioned product.
     * </p>
     * 
     * @return The identifier of the provisioned product.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current status of the provisioned product.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and
     * completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an
     * <code>AVAILABLE</code> status before performing operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested
     * operation but is not exactly what was requested. For example, a request to update to a new version failed and the
     * stack rolled back to the current version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
     * For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
     * but resources have not yet been created. After reviewing the list of resources to be created, execute the plan.
     * Wait for an <code>AVAILABLE</code> status before performing operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedProductStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the provisioned product.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation
     *         succeeded and completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for
     *         an <code>AVAILABLE</code> status before performing operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the
     *         requested operation but is not exactly what was requested. For example, a request to update to a new
     *         version failed and the stack rolled back to the current version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
     *         running. For example, CloudFormation received a parameter value that was not valid and could not launch
     *         the stack.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new
     *         product, but resources have not yet been created. After reviewing the list of resources to be created,
     *         execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.
     *         </p>
     *         </li>
     * @see ProvisionedProductStatus
     */
    public final ProvisionedProductStatus status() {
        return ProvisionedProductStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the provisioned product.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and
     * completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an
     * <code>AVAILABLE</code> status before performing operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested
     * operation but is not exactly what was requested. For example, a request to update to a new version failed and the
     * stack rolled back to the current version.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running.
     * For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product,
     * but resources have not yet been created. After reviewing the list of resources to be created, execute the plan.
     * Wait for an <code>AVAILABLE</code> status before performing operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedProductStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the provisioned product.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation
     *         succeeded and completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for
     *         an <code>AVAILABLE</code> status before performing operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the
     *         requested operation but is not exactly what was requested. For example, a request to update to a new
     *         version failed and the stack rolled back to the current version.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
     *         running. For example, CloudFormation received a parameter value that was not valid and could not launch
     *         the stack.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new
     *         product, but resources have not yet been created. After reviewing the list of resources to be created,
     *         execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.
     *         </p>
     *         </li>
     * @see ProvisionedProductStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The current status message of the provisioned product.
     * </p>
     * 
     * @return The current status message of the provisioned product.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The UTC time stamp of the creation time.
     * </p>
     * 
     * @return The UTC time stamp of the creation time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency
     * token, the same response is returned for each repeated request.
     * </p>
     * 
     * @return A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
     *         idempotency token, the same response is returned for each repeated request.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * The record identifier of the last request performed on this provisioned product.
     * </p>
     * 
     * @return The record identifier of the last request performed on this provisioned product.
     */
    public final String lastRecordId() {
        return lastRecordId;
    }

    /**
     * <p>
     * The record identifier of the last request performed on this provisioned product of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ProvisionProduct
     * </p>
     * </li>
     * <li>
     * <p>
     * UpdateProvisionedProduct
     * </p>
     * </li>
     * <li>
     * <p>
     * ExecuteProvisionedProductPlan
     * </p>
     * </li>
     * <li>
     * <p>
     * TerminateProvisionedProduct
     * </p>
     * </li>
     * </ul>
     * 
     * @return The record identifier of the last request performed on this provisioned product of the following
     *         types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ProvisionProduct
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UpdateProvisionedProduct
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ExecuteProvisionedProductPlan
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TerminateProvisionedProduct
     *         </p>
     *         </li>
     */
    public final String lastProvisioningRecordId() {
        return lastProvisioningRecordId;
    }

    /**
     * <p>
     * The record identifier of the last successful request performed on this provisioned product of the following
     * types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ProvisionProduct
     * </p>
     * </li>
     * <li>
     * <p>
     * UpdateProvisionedProduct
     * </p>
     * </li>
     * <li>
     * <p>
     * ExecuteProvisionedProductPlan
     * </p>
     * </li>
     * <li>
     * <p>
     * TerminateProvisionedProduct
     * </p>
     * </li>
     * </ul>
     * 
     * @return The record identifier of the last successful request performed on this provisioned product of the
     *         following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ProvisionProduct
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UpdateProvisionedProduct
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ExecuteProvisionedProductPlan
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TerminateProvisionedProduct
     *         </p>
     *         </li>
     */
    public final String lastSuccessfulProvisioningRecordId() {
        return lastSuccessfulProvisioningRecordId;
    }

    /**
     * <p>
     * The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
     * </p>
     * 
     * @return The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
     * </p>
     * 
     * @return The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The ARN of the launch role associated with the provisioned product.
     * </p>
     * 
     * @return The ARN of the launch role associated with the provisioned product.
     */
    public final String launchRoleArn() {
        return launchRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(lastRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(lastProvisioningRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulProvisioningRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(launchRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductDetail)) {
            return false;
        }
        ProvisionedProductDetail other = (ProvisionedProductDetail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn()) && Objects.equals(type(), other.type())
                && Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(lastRecordId(), other.lastRecordId())
                && Objects.equals(lastProvisioningRecordId(), other.lastProvisioningRecordId())
                && Objects.equals(lastSuccessfulProvisioningRecordId(), other.lastSuccessfulProvisioningRecordId())
                && Objects.equals(productId(), other.productId())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(launchRoleArn(), other.launchRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedProductDetail").add("Name", name()).add("Arn", arn()).add("Type", type())
                .add("Id", id()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("CreatedTime", createdTime()).add("IdempotencyToken", idempotencyToken())
                .add("LastRecordId", lastRecordId()).add("LastProvisioningRecordId", lastProvisioningRecordId())
                .add("LastSuccessfulProvisioningRecordId", lastSuccessfulProvisioningRecordId()).add("ProductId", productId())
                .add("ProvisioningArtifactId", provisioningArtifactId()).add("LaunchRoleArn", launchRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "LastRecordId":
            return Optional.ofNullable(clazz.cast(lastRecordId()));
        case "LastProvisioningRecordId":
            return Optional.ofNullable(clazz.cast(lastProvisioningRecordId()));
        case "LastSuccessfulProvisioningRecordId":
            return Optional.ofNullable(clazz.cast(lastSuccessfulProvisioningRecordId()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "LaunchRoleArn":
            return Optional.ofNullable(clazz.cast(launchRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("LastRecordId", LAST_RECORD_ID_FIELD);
        map.put("LastProvisioningRecordId", LAST_PROVISIONING_RECORD_ID_FIELD);
        map.put("LastSuccessfulProvisioningRecordId", LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("ProvisioningArtifactId", PROVISIONING_ARTIFACT_ID_FIELD);
        map.put("LaunchRoleArn", LAUNCH_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductDetail, T> g) {
        return obj -> g.apply((ProvisionedProductDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedProductDetail> {
        /**
         * <p>
         * The user-friendly name of the provisioned product.
         * </p>
         * 
         * @param name
         *        The user-friendly name of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the provisioned product.
         * </p>
         * 
         * @param arn
         *        The ARN of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of provisioned product. The supported values are <code>CFN_STACK</code>, <code>CFN_STACKSET</code>,
         * <code>TERRAFORM_OPEN_SOURCE</code>, <code>TERRAFORM_CLOUD</code>, and <code>EXTERNAL</code>.
         * </p>
         * 
         * @param type
         *        The type of provisioned product. The supported values are <code>CFN_STACK</code>,
         *        <code>CFN_STACKSET</code>, <code>TERRAFORM_OPEN_SOURCE</code>, <code>TERRAFORM_CLOUD</code>, and
         *        <code>EXTERNAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The identifier of the provisioned product.
         * </p>
         * 
         * @param id
         *        The identifier of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current status of the provisioned product.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded
         * and completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an
         * <code>AVAILABLE</code> status before performing operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested
         * operation but is not exactly what was requested. For example, a request to update to a new version failed and
         * the stack rolled back to the current version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
         * running. For example, CloudFormation received a parameter value that was not valid and could not launch the
         * stack.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new
         * product, but resources have not yet been created. After reviewing the list of resources to be created,
         * execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the provisioned product.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation
         *        succeeded and completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait
         *        for an <code>AVAILABLE</code> status before performing operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the
         *        requested operation but is not exactly what was requested. For example, a request to update to a new
         *        version failed and the stack rolled back to the current version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
         *        running. For example, CloudFormation received a parameter value that was not valid and could not
         *        launch the stack.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a
         *        new product, but resources have not yet been created. After reviewing the list of resources to be
         *        created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.
         *        </p>
         *        </li>
         * @see ProvisionedProductStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the provisioned product.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded
         * and completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an
         * <code>AVAILABLE</code> status before performing operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested
         * operation but is not exactly what was requested. For example, a request to update to a new version failed and
         * the stack rolled back to the current version.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
         * running. For example, CloudFormation received a parameter value that was not valid and could not launch the
         * stack.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new
         * product, but resources have not yet been created. After reviewing the list of resources to be created,
         * execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the provisioned product.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation
         *        succeeded and completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait
         *        for an <code>AVAILABLE</code> status before performing operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the
         *        requested operation but is not exactly what was requested. For example, a request to update to a new
         *        version failed and the stack rolled back to the current version.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not
         *        running. For example, CloudFormation received a parameter value that was not valid and could not
         *        launch the stack.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a
         *        new product, but resources have not yet been created. After reviewing the list of resources to be
         *        created, execute the plan. Wait for an <code>AVAILABLE</code> status before performing operations.
         *        </p>
         *        </li>
         * @see ProvisionedProductStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductStatus
         */
        Builder status(ProvisionedProductStatus status);

        /**
         * <p>
         * The current status message of the provisioned product.
         * </p>
         * 
         * @param statusMessage
         *        The current status message of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The UTC time stamp of the creation time.
         * </p>
         * 
         * @param createdTime
         *        The UTC time stamp of the creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         * idempotency token, the same response is returned for each repeated request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         *        idempotency token, the same response is returned for each repeated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * The record identifier of the last request performed on this provisioned product.
         * </p>
         * 
         * @param lastRecordId
         *        The record identifier of the last request performed on this provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRecordId(String lastRecordId);

        /**
         * <p>
         * The record identifier of the last request performed on this provisioned product of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ProvisionProduct
         * </p>
         * </li>
         * <li>
         * <p>
         * UpdateProvisionedProduct
         * </p>
         * </li>
         * <li>
         * <p>
         * ExecuteProvisionedProductPlan
         * </p>
         * </li>
         * <li>
         * <p>
         * TerminateProvisionedProduct
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastProvisioningRecordId
         *        The record identifier of the last request performed on this provisioned product of the following
         *        types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ProvisionProduct
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UpdateProvisionedProduct
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ExecuteProvisionedProductPlan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TerminateProvisionedProduct
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastProvisioningRecordId(String lastProvisioningRecordId);

        /**
         * <p>
         * The record identifier of the last successful request performed on this provisioned product of the following
         * types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ProvisionProduct
         * </p>
         * </li>
         * <li>
         * <p>
         * UpdateProvisionedProduct
         * </p>
         * </li>
         * <li>
         * <p>
         * ExecuteProvisionedProductPlan
         * </p>
         * </li>
         * <li>
         * <p>
         * TerminateProvisionedProduct
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastSuccessfulProvisioningRecordId
         *        The record identifier of the last successful request performed on this provisioned product of the
         *        following types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ProvisionProduct
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UpdateProvisionedProduct
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ExecuteProvisionedProductPlan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TerminateProvisionedProduct
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId);

        /**
         * <p>
         * The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
         * </p>
         * 
         * @param productId
         *        The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The ARN of the launch role associated with the provisioned product.
         * </p>
         * 
         * @param launchRoleArn
         *        The ARN of the launch role associated with the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchRoleArn(String launchRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String type;

        private String id;

        private String status;

        private String statusMessage;

        private Instant createdTime;

        private String idempotencyToken;

        private String lastRecordId;

        private String lastProvisioningRecordId;

        private String lastSuccessfulProvisioningRecordId;

        private String productId;

        private String provisioningArtifactId;

        private String launchRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductDetail model) {
            name(model.name);
            arn(model.arn);
            type(model.type);
            id(model.id);
            status(model.status);
            statusMessage(model.statusMessage);
            createdTime(model.createdTime);
            idempotencyToken(model.idempotencyToken);
            lastRecordId(model.lastRecordId);
            lastProvisioningRecordId(model.lastProvisioningRecordId);
            lastSuccessfulProvisioningRecordId(model.lastSuccessfulProvisioningRecordId);
            productId(model.productId);
            provisioningArtifactId(model.provisioningArtifactId);
            launchRoleArn(model.launchRoleArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedProductStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getLastRecordId() {
            return lastRecordId;
        }

        public final void setLastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
        }

        @Override
        public final Builder lastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
            return this;
        }

        public final String getLastProvisioningRecordId() {
            return lastProvisioningRecordId;
        }

        public final void setLastProvisioningRecordId(String lastProvisioningRecordId) {
            this.lastProvisioningRecordId = lastProvisioningRecordId;
        }

        @Override
        public final Builder lastProvisioningRecordId(String lastProvisioningRecordId) {
            this.lastProvisioningRecordId = lastProvisioningRecordId;
            return this;
        }

        public final String getLastSuccessfulProvisioningRecordId() {
            return lastSuccessfulProvisioningRecordId;
        }

        public final void setLastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId) {
            this.lastSuccessfulProvisioningRecordId = lastSuccessfulProvisioningRecordId;
        }

        @Override
        public final Builder lastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId) {
            this.lastSuccessfulProvisioningRecordId = lastSuccessfulProvisioningRecordId;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getLaunchRoleArn() {
            return launchRoleArn;
        }

        public final void setLaunchRoleArn(String launchRoleArn) {
            this.launchRoleArn = launchRoleArn;
        }

        @Override
        public final Builder launchRoleArn(String launchRoleArn) {
            this.launchRoleArn = launchRoleArn;
            return this;
        }

        @Override
        public ProvisionedProductDetail build() {
            return new ProvisionedProductDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
