/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the portfolio share operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareDetails implements SdkPojo, Serializable, ToCopyableBuilder<ShareDetails.Builder, ShareDetails> {
    private static final SdkField<List<String>> SUCCESSFUL_SHARES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuccessfulShares")
            .getter(getter(ShareDetails::successfulShares))
            .setter(setter(Builder::successfulShares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulShares").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ShareError>> SHARE_ERRORS_FIELD = SdkField
            .<List<ShareError>> builder(MarshallingType.LIST)
            .memberName("ShareErrors")
            .getter(getter(ShareDetails::shareErrors))
            .setter(setter(Builder::shareErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShareError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShareError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SHARES_FIELD,
            SHARE_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> successfulShares;

    private final List<ShareError> shareErrors;

    private ShareDetails(BuilderImpl builder) {
        this.successfulShares = builder.successfulShares;
        this.shareErrors = builder.shareErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulShares property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessfulShares() {
        return successfulShares != null && !(successfulShares instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of accounts for whom the operation succeeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulShares} method.
     * </p>
     * 
     * @return List of accounts for whom the operation succeeded.
     */
    public final List<String> successfulShares() {
        return successfulShares;
    }

    /**
     * For responses, this returns true if the service returned a value for the ShareErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasShareErrors() {
        return shareErrors != null && !(shareErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShareErrors} method.
     * </p>
     * 
     * @return List of errors.
     */
    public final List<ShareError> shareErrors() {
        return shareErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulShares() ? successfulShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasShareErrors() ? shareErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareDetails)) {
            return false;
        }
        ShareDetails other = (ShareDetails) obj;
        return hasSuccessfulShares() == other.hasSuccessfulShares()
                && Objects.equals(successfulShares(), other.successfulShares()) && hasShareErrors() == other.hasShareErrors()
                && Objects.equals(shareErrors(), other.shareErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareDetails").add("SuccessfulShares", hasSuccessfulShares() ? successfulShares() : null)
                .add("ShareErrors", hasShareErrors() ? shareErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulShares":
            return Optional.ofNullable(clazz.cast(successfulShares()));
        case "ShareErrors":
            return Optional.ofNullable(clazz.cast(shareErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessfulShares", SUCCESSFUL_SHARES_FIELD);
        map.put("ShareErrors", SHARE_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShareDetails, T> g) {
        return obj -> g.apply((ShareDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareDetails> {
        /**
         * <p>
         * List of accounts for whom the operation succeeded.
         * </p>
         * 
         * @param successfulShares
         *        List of accounts for whom the operation succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulShares(Collection<String> successfulShares);

        /**
         * <p>
         * List of accounts for whom the operation succeeded.
         * </p>
         * 
         * @param successfulShares
         *        List of accounts for whom the operation succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulShares(String... successfulShares);

        /**
         * <p>
         * List of errors.
         * </p>
         * 
         * @param shareErrors
         *        List of errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareErrors(Collection<ShareError> shareErrors);

        /**
         * <p>
         * List of errors.
         * </p>
         * 
         * @param shareErrors
         *        List of errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareErrors(ShareError... shareErrors);

        /**
         * <p>
         * List of errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ShareError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.servicecatalog.model.ShareError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ShareError.Builder#build()} is called immediately
         * and its result is passed to {@link #shareErrors(List<ShareError>)}.
         * 
         * @param shareErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ShareError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareErrors(java.util.Collection<ShareError>)
         */
        Builder shareErrors(Consumer<ShareError.Builder>... shareErrors);
    }

    static final class BuilderImpl implements Builder {
        private List<String> successfulShares = DefaultSdkAutoConstructList.getInstance();

        private List<ShareError> shareErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ShareDetails model) {
            successfulShares(model.successfulShares);
            shareErrors(model.shareErrors);
        }

        public final Collection<String> getSuccessfulShares() {
            if (successfulShares instanceof SdkAutoConstructList) {
                return null;
            }
            return successfulShares;
        }

        public final void setSuccessfulShares(Collection<String> successfulShares) {
            this.successfulShares = SuccessfulSharesCopier.copy(successfulShares);
        }

        @Override
        public final Builder successfulShares(Collection<String> successfulShares) {
            this.successfulShares = SuccessfulSharesCopier.copy(successfulShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulShares(String... successfulShares) {
            successfulShares(Arrays.asList(successfulShares));
            return this;
        }

        public final List<ShareError.Builder> getShareErrors() {
            List<ShareError.Builder> result = ShareErrorsCopier.copyToBuilder(this.shareErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareErrors(Collection<ShareError.BuilderImpl> shareErrors) {
            this.shareErrors = ShareErrorsCopier.copyFromBuilder(shareErrors);
        }

        @Override
        public final Builder shareErrors(Collection<ShareError> shareErrors) {
            this.shareErrors = ShareErrorsCopier.copy(shareErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareErrors(ShareError... shareErrors) {
            shareErrors(Arrays.asList(shareErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareErrors(Consumer<ShareError.Builder>... shareErrors) {
            shareErrors(Stream.of(shareErrors).map(c -> ShareError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ShareDetails build() {
            return new ShareDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
