/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConstraintResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<UpdateConstraintResponse.Builder, UpdateConstraintResponse> {
    private static final SdkField<ConstraintDetail> CONSTRAINT_DETAIL_FIELD = SdkField
            .<ConstraintDetail> builder(MarshallingType.SDK_POJO).memberName("ConstraintDetail")
            .getter(getter(UpdateConstraintResponse::constraintDetail)).setter(setter(Builder::constraintDetail))
            .constructor(ConstraintDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintDetail").build()).build();

    private static final SdkField<String> CONSTRAINT_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstraintParameters").getter(getter(UpdateConstraintResponse::constraintParameters))
            .setter(setter(Builder::constraintParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintParameters").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateConstraintResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINT_DETAIL_FIELD,
            CONSTRAINT_PARAMETERS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConstraintDetail constraintDetail;

    private final String constraintParameters;

    private final String status;

    private UpdateConstraintResponse(BuilderImpl builder) {
        super(builder);
        this.constraintDetail = builder.constraintDetail;
        this.constraintParameters = builder.constraintParameters;
        this.status = builder.status;
    }

    /**
     * <p>
     * Information about the constraint.
     * </p>
     * 
     * @return Information about the constraint.
     */
    public final ConstraintDetail constraintDetail() {
        return constraintDetail;
    }

    /**
     * <p>
     * The constraint parameters.
     * </p>
     * 
     * @return The constraint parameters.
     */
    public final String constraintParameters() {
        return constraintParameters;
    }

    /**
     * <p>
     * The status of the current request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current request.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the current request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current request.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(constraintDetail());
        hashCode = 31 * hashCode + Objects.hashCode(constraintParameters());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConstraintResponse)) {
            return false;
        }
        UpdateConstraintResponse other = (UpdateConstraintResponse) obj;
        return Objects.equals(constraintDetail(), other.constraintDetail())
                && Objects.equals(constraintParameters(), other.constraintParameters())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConstraintResponse").add("ConstraintDetail", constraintDetail())
                .add("ConstraintParameters", constraintParameters()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConstraintDetail":
            return Optional.ofNullable(clazz.cast(constraintDetail()));
        case "ConstraintParameters":
            return Optional.ofNullable(clazz.cast(constraintParameters()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConstraintDetail", CONSTRAINT_DETAIL_FIELD);
        map.put("ConstraintParameters", CONSTRAINT_PARAMETERS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConstraintResponse, T> g) {
        return obj -> g.apply((UpdateConstraintResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConstraintResponse> {
        /**
         * <p>
         * Information about the constraint.
         * </p>
         * 
         * @param constraintDetail
         *        Information about the constraint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintDetail(ConstraintDetail constraintDetail);

        /**
         * <p>
         * Information about the constraint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConstraintDetail.Builder} avoiding the
         * need to create one manually via {@link ConstraintDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConstraintDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #constraintDetail(ConstraintDetail)}.
         * 
         * @param constraintDetail
         *        a consumer that will call methods on {@link ConstraintDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintDetail(ConstraintDetail)
         */
        default Builder constraintDetail(Consumer<ConstraintDetail.Builder> constraintDetail) {
            return constraintDetail(ConstraintDetail.builder().applyMutation(constraintDetail).build());
        }

        /**
         * <p>
         * The constraint parameters.
         * </p>
         * 
         * @param constraintParameters
         *        The constraint parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintParameters(String constraintParameters);

        /**
         * <p>
         * The status of the current request.
         * </p>
         * 
         * @param status
         *        The status of the current request.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the current request.
         * </p>
         * 
         * @param status
         *        The status of the current request.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ConstraintDetail constraintDetail;

        private String constraintParameters;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConstraintResponse model) {
            super(model);
            constraintDetail(model.constraintDetail);
            constraintParameters(model.constraintParameters);
            status(model.status);
        }

        public final ConstraintDetail.Builder getConstraintDetail() {
            return constraintDetail != null ? constraintDetail.toBuilder() : null;
        }

        public final void setConstraintDetail(ConstraintDetail.BuilderImpl constraintDetail) {
            this.constraintDetail = constraintDetail != null ? constraintDetail.build() : null;
        }

        @Override
        public final Builder constraintDetail(ConstraintDetail constraintDetail) {
            this.constraintDetail = constraintDetail;
            return this;
        }

        public final String getConstraintParameters() {
            return constraintParameters;
        }

        public final void setConstraintParameters(String constraintParameters) {
            this.constraintParameters = constraintParameters;
        }

        @Override
        public final Builder constraintParameters(String constraintParameters) {
            this.constraintParameters = constraintParameters;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateConstraintResponse build() {
            return new UpdateConstraintResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
