/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePortfolioShareRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdatePortfolioShareRequest.Builder, UpdatePortfolioShareRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(UpdatePortfolioShareRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioId").getter(getter(UpdatePortfolioShareRequest::portfolioId))
            .setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UpdatePortfolioShareRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<OrganizationNode> ORGANIZATION_NODE_FIELD = SdkField
            .<OrganizationNode> builder(MarshallingType.SDK_POJO).memberName("OrganizationNode")
            .getter(getter(UpdatePortfolioShareRequest::organizationNode)).setter(setter(Builder::organizationNode))
            .constructor(OrganizationNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNode").build()).build();

    private static final SdkField<Boolean> SHARE_TAG_OPTIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShareTagOptions").getter(getter(UpdatePortfolioShareRequest::shareTagOptions))
            .setter(setter(Builder::shareTagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareTagOptions").build()).build();

    private static final SdkField<Boolean> SHARE_PRINCIPALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SharePrincipals").getter(getter(UpdatePortfolioShareRequest::sharePrincipals))
            .setter(setter(Builder::sharePrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePrincipals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PORTFOLIO_ID_FIELD, ACCOUNT_ID_FIELD, ORGANIZATION_NODE_FIELD, SHARE_TAG_OPTIONS_FIELD, SHARE_PRINCIPALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String portfolioId;

    private final String accountId;

    private final OrganizationNode organizationNode;

    private final Boolean shareTagOptions;

    private final Boolean sharePrincipals;

    private UpdatePortfolioShareRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.accountId = builder.accountId;
        this.organizationNode = builder.organizationNode;
        this.shareTagOptions = builder.shareTagOptions;
        this.sharePrincipals = builder.sharePrincipals;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The unique identifier of the portfolio for which the share will be updated.
     * </p>
     * 
     * @return The unique identifier of the portfolio for which the share will be updated.
     */
    public final String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The Amazon Web Services account Id of the recipient account. This field is required when updating an external
     * account to account type share.
     * </p>
     * 
     * @return The Amazon Web Services account Id of the recipient account. This field is required when updating an
     *         external account to account type share.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the OrganizationNode property for this object.
     * 
     * @return The value of the OrganizationNode property for this object.
     */
    public final OrganizationNode organizationNode() {
        return organizationNode;
    }

    /**
     * <p>
     * Enables or disables <code>TagOptions</code> sharing for the portfolio share. If this field is not provided, the
     * current state of TagOptions sharing on the portfolio share will not be modified.
     * </p>
     * 
     * @return Enables or disables <code>TagOptions</code> sharing for the portfolio share. If this field is not
     *         provided, the current state of TagOptions sharing on the portfolio share will not be modified.
     */
    public final Boolean shareTagOptions() {
        return shareTagOptions;
    }

    /**
     * <p>
     * A flag to enables or disables <code>Principals</code> sharing in the portfolio. If this field is not provided,
     * the current state of the <code>Principals</code> sharing on the portfolio share will not be modified.
     * </p>
     * 
     * @return A flag to enables or disables <code>Principals</code> sharing in the portfolio. If this field is not
     *         provided, the current state of the <code>Principals</code> sharing on the portfolio share will not be
     *         modified.
     */
    public final Boolean sharePrincipals() {
        return sharePrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationNode());
        hashCode = 31 * hashCode + Objects.hashCode(shareTagOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sharePrincipals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioShareRequest)) {
            return false;
        }
        UpdatePortfolioShareRequest other = (UpdatePortfolioShareRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(organizationNode(), other.organizationNode())
                && Objects.equals(shareTagOptions(), other.shareTagOptions())
                && Objects.equals(sharePrincipals(), other.sharePrincipals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePortfolioShareRequest").add("AcceptLanguage", acceptLanguage())
                .add("PortfolioId", portfolioId()).add("AccountId", accountId()).add("OrganizationNode", organizationNode())
                .add("ShareTagOptions", shareTagOptions()).add("SharePrincipals", sharePrincipals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "OrganizationNode":
            return Optional.ofNullable(clazz.cast(organizationNode()));
        case "ShareTagOptions":
            return Optional.ofNullable(clazz.cast(shareTagOptions()));
        case "SharePrincipals":
            return Optional.ofNullable(clazz.cast(sharePrincipals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("PortfolioId", PORTFOLIO_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("OrganizationNode", ORGANIZATION_NODE_FIELD);
        map.put("ShareTagOptions", SHARE_TAG_OPTIONS_FIELD);
        map.put("SharePrincipals", SHARE_PRINCIPALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortfolioShareRequest, T> g) {
        return obj -> g.apply((UpdatePortfolioShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePortfolioShareRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The unique identifier of the portfolio for which the share will be updated.
         * </p>
         * 
         * @param portfolioId
         *        The unique identifier of the portfolio for which the share will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The Amazon Web Services account Id of the recipient account. This field is required when updating an external
         * account to account type share.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account Id of the recipient account. This field is required when updating an
         *        external account to account type share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the OrganizationNode property for this object.
         *
         * @param organizationNode
         *        The new value for the OrganizationNode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationNode(OrganizationNode organizationNode);

        /**
         * Sets the value of the OrganizationNode property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OrganizationNode.Builder} avoiding the
         * need to create one manually via {@link OrganizationNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationNode.Builder#build()} is called immediately and its
         * result is passed to {@link #organizationNode(OrganizationNode)}.
         * 
         * @param organizationNode
         *        a consumer that will call methods on {@link OrganizationNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationNode(OrganizationNode)
         */
        default Builder organizationNode(Consumer<OrganizationNode.Builder> organizationNode) {
            return organizationNode(OrganizationNode.builder().applyMutation(organizationNode).build());
        }

        /**
         * <p>
         * Enables or disables <code>TagOptions</code> sharing for the portfolio share. If this field is not provided,
         * the current state of TagOptions sharing on the portfolio share will not be modified.
         * </p>
         * 
         * @param shareTagOptions
         *        Enables or disables <code>TagOptions</code> sharing for the portfolio share. If this field is not
         *        provided, the current state of TagOptions sharing on the portfolio share will not be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareTagOptions(Boolean shareTagOptions);

        /**
         * <p>
         * A flag to enables or disables <code>Principals</code> sharing in the portfolio. If this field is not
         * provided, the current state of the <code>Principals</code> sharing on the portfolio share will not be
         * modified.
         * </p>
         * 
         * @param sharePrincipals
         *        A flag to enables or disables <code>Principals</code> sharing in the portfolio. If this field is not
         *        provided, the current state of the <code>Principals</code> sharing on the portfolio share will not be
         *        modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePrincipals(Boolean sharePrincipals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String portfolioId;

        private String accountId;

        private OrganizationNode organizationNode;

        private Boolean shareTagOptions;

        private Boolean sharePrincipals;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioShareRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            portfolioId(model.portfolioId);
            accountId(model.accountId);
            organizationNode(model.organizationNode);
            shareTagOptions(model.shareTagOptions);
            sharePrincipals(model.sharePrincipals);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final OrganizationNode.Builder getOrganizationNode() {
            return organizationNode != null ? organizationNode.toBuilder() : null;
        }

        public final void setOrganizationNode(OrganizationNode.BuilderImpl organizationNode) {
            this.organizationNode = organizationNode != null ? organizationNode.build() : null;
        }

        @Override
        public final Builder organizationNode(OrganizationNode organizationNode) {
            this.organizationNode = organizationNode;
            return this;
        }

        public final Boolean getShareTagOptions() {
            return shareTagOptions;
        }

        public final void setShareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
        }

        @Override
        public final Builder shareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
            return this;
        }

        public final Boolean getSharePrincipals() {
            return sharePrincipals;
        }

        public final void setSharePrincipals(Boolean sharePrincipals) {
            this.sharePrincipals = sharePrincipals;
        }

        @Override
        public final Builder sharePrincipals(Boolean sharePrincipals) {
            this.sharePrincipals = sharePrincipals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortfolioShareRequest build() {
            return new UpdatePortfolioShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
