/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePortfolioShareResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<UpdatePortfolioShareResponse.Builder, UpdatePortfolioShareResponse> {
    private static final SdkField<String> PORTFOLIO_SHARE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioShareToken").getter(getter(UpdatePortfolioShareResponse::portfolioShareToken))
            .setter(setter(Builder::portfolioShareToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareToken").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdatePortfolioShareResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_SHARE_TOKEN_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String portfolioShareToken;

    private final String status;

    private UpdatePortfolioShareResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioShareToken = builder.portfolioShareToken;
        this.status = builder.status;
    }

    /**
     * <p>
     * The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account to
     * account or organizational type sharing.
     * </p>
     * 
     * @return The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account
     *         to account or organizational type sharing.
     */
    public final String portfolioShareToken() {
        return portfolioShareToken;
    }

    /**
     * <p>
     * The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using
     * <code>DescribePortfolioShareStatus</code> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using
     *         <code>DescribePortfolioShareStatus</code> API.
     * @see ShareStatus
     */
    public final ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using
     * <code>DescribePortfolioShareStatus</code> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using
     *         <code>DescribePortfolioShareStatus</code> API.
     * @see ShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portfolioShareToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioShareResponse)) {
            return false;
        }
        UpdatePortfolioShareResponse other = (UpdatePortfolioShareResponse) obj;
        return Objects.equals(portfolioShareToken(), other.portfolioShareToken())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePortfolioShareResponse").add("PortfolioShareToken", portfolioShareToken())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioShareToken":
            return Optional.ofNullable(clazz.cast(portfolioShareToken()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PortfolioShareToken", PORTFOLIO_SHARE_TOKEN_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortfolioShareResponse, T> g) {
        return obj -> g.apply((UpdatePortfolioShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePortfolioShareResponse> {
        /**
         * <p>
         * The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external account to
         * account or organizational type sharing.
         * </p>
         * 
         * @param portfolioShareToken
         *        The token that tracks the status of the <code>UpdatePortfolioShare</code> operation for external
         *        account to account or organizational type sharing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioShareToken(String portfolioShareToken);

        /**
         * <p>
         * The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using
         * <code>DescribePortfolioShareStatus</code> API.
         * </p>
         * 
         * @param status
         *        The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status
         *        using <code>DescribePortfolioShareStatus</code> API.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status using
         * <code>DescribePortfolioShareStatus</code> API.
         * </p>
         * 
         * @param status
         *        The status of <code>UpdatePortfolioShare</code> operation. You can also obtain the operation status
         *        using <code>DescribePortfolioShareStatus</code> API.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String portfolioShareToken;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioShareResponse model) {
            super(model);
            portfolioShareToken(model.portfolioShareToken);
            status(model.status);
        }

        public final String getPortfolioShareToken() {
            return portfolioShareToken;
        }

        public final void setPortfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
        }

        @Override
        public final Builder portfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdatePortfolioShareResponse build() {
            return new UpdatePortfolioShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
