/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StackSetOperationType {
    CREATE("CREATE"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StackSetOperationType> VALUE_MAP;
    private final String value;

    private StackSetOperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackSetOperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackSetOperationType> knownValues() {
        EnumSet<StackSetOperationType> knownValues = EnumSet.allOf(StackSetOperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StackSetOperationType.class, StackSetOperationType::toString);
    }
}

