/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.SourceConnectionDetail;
import software.amazon.awssdk.services.servicecatalog.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductViewDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductViewDetail> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductViewSummary").getter(ProductViewDetail.getter(ProductViewDetail::productViewSummary)).setter(ProductViewDetail.setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProductViewDetail.getter(ProductViewDetail::statusAsString)).setter(ProductViewDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductARN").getter(ProductViewDetail.getter(ProductViewDetail::productARN)).setter(ProductViewDetail.setter(Builder::productARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductARN").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ProductViewDetail.getter(ProductViewDetail::createdTime)).setter(ProductViewDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<SourceConnectionDetail> SOURCE_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConnection").getter(ProductViewDetail.getter(ProductViewDetail::sourceConnection)).setter(ProductViewDetail.setter(Builder::sourceConnection)).constructor(SourceConnectionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD, STATUS_FIELD, PRODUCT_ARN_FIELD, CREATED_TIME_FIELD, SOURCE_CONNECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductViewDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProductViewSummary productViewSummary;
    private final String status;
    private final String productARN;
    private final Instant createdTime;
    private final SourceConnectionDetail sourceConnection;

    private ProductViewDetail(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.status = builder.status;
        this.productARN = builder.productARN;
        this.createdTime = builder.createdTime;
        this.sourceConnection = builder.sourceConnection;
    }

    public final ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String productARN() {
        return this.productARN;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final SourceConnectionDetail sourceConnection() {
        return this.sourceConnection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewDetail)) {
            return false;
        }
        ProductViewDetail other = (ProductViewDetail)obj;
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.productARN(), other.productARN()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.sourceConnection(), other.sourceConnection());
    }

    public final String toString() {
        return ToString.builder((String)"ProductViewDetail").add("ProductViewSummary", (Object)this.productViewSummary()).add("Status", (Object)this.statusAsString()).add("ProductARN", (Object)this.productARN()).add("CreatedTime", (Object)this.createdTime()).add("SourceConnection", (Object)this.sourceConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.ofNullable(clazz.cast(this.productViewSummary()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ProductARN": {
                return Optional.ofNullable(clazz.cast(this.productARN()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "SourceConnection": {
                return Optional.ofNullable(clazz.cast(this.sourceConnection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductViewSummary", PRODUCT_VIEW_SUMMARY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ProductARN", PRODUCT_ARN_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("SourceConnection", SOURCE_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductViewDetail, T> g) {
        return obj -> g.apply((ProductViewDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private String status;
        private String productARN;
        private Instant createdTime;
        private SourceConnectionDetail sourceConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewDetail model) {
            this.productViewSummary(model.productViewSummary);
            this.status(model.status);
            this.productARN(model.productARN);
            this.createdTime(model.createdTime);
            this.sourceConnection(model.sourceConnection);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProductARN() {
            return this.productARN;
        }

        public final void setProductARN(String productARN) {
            this.productARN = productARN;
        }

        @Override
        public final Builder productARN(String productARN) {
            this.productARN = productARN;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final SourceConnectionDetail.Builder getSourceConnection() {
            return this.sourceConnection != null ? this.sourceConnection.toBuilder() : null;
        }

        public final void setSourceConnection(SourceConnectionDetail.BuilderImpl sourceConnection) {
            this.sourceConnection = sourceConnection != null ? sourceConnection.build() : null;
        }

        @Override
        public final Builder sourceConnection(SourceConnectionDetail sourceConnection) {
            this.sourceConnection = sourceConnection;
            return this;
        }

        public ProductViewDetail build() {
            return new ProductViewDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductViewDetail> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation(productViewSummary)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder productARN(String var1);

        public Builder createdTime(Instant var1);

        public Builder sourceConnection(SourceConnectionDetail var1);

        default public Builder sourceConnection(Consumer<SourceConnectionDetail.Builder> sourceConnection) {
            return this.sourceConnection((SourceConnectionDetail)((SourceConnectionDetail.Builder)SourceConnectionDetail.builder().applyMutation(sourceConnection)).build());
        }
    }
}

