/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortfolioShareRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<CreatePortfolioShareRequest.Builder, CreatePortfolioShareRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(CreatePortfolioShareRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioId").getter(getter(CreatePortfolioShareRequest::portfolioId))
            .setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(CreatePortfolioShareRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<OrganizationNode> ORGANIZATION_NODE_FIELD = SdkField
            .<OrganizationNode> builder(MarshallingType.SDK_POJO).memberName("OrganizationNode")
            .getter(getter(CreatePortfolioShareRequest::organizationNode)).setter(setter(Builder::organizationNode))
            .constructor(OrganizationNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNode").build()).build();

    private static final SdkField<Boolean> SHARE_TAG_OPTIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShareTagOptions").getter(getter(CreatePortfolioShareRequest::shareTagOptions))
            .setter(setter(Builder::shareTagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareTagOptions").build()).build();

    private static final SdkField<Boolean> SHARE_PRINCIPALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SharePrincipals").getter(getter(CreatePortfolioShareRequest::sharePrincipals))
            .setter(setter(Builder::sharePrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePrincipals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PORTFOLIO_ID_FIELD, ACCOUNT_ID_FIELD, ORGANIZATION_NODE_FIELD, SHARE_TAG_OPTIONS_FIELD, SHARE_PRINCIPALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String portfolioId;

    private final String accountId;

    private final OrganizationNode organizationNode;

    private final Boolean shareTagOptions;

    private final Boolean sharePrincipals;

    private CreatePortfolioShareRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.accountId = builder.accountId;
        this.organizationNode = builder.organizationNode;
        this.shareTagOptions = builder.shareTagOptions;
        this.sharePrincipals = builder.sharePrincipals;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The portfolio identifier.
     * </p>
     * 
     * @return The portfolio identifier.
     */
    public final String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID. For example, <code>123456789012</code>.
     * </p>
     * 
     * @return The Amazon Web Services account ID. For example, <code>123456789012</code>.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The organization node to whom you are going to share. When you pass <code>OrganizationNode</code>, it creates
     * <code>PortfolioShare</code> for all of the Amazon Web Services accounts that are associated to the
     * <code>OrganizationNode</code>. The output returns a <code>PortfolioShareToken</code>, which enables the
     * administrator to monitor the status of the <code>PortfolioShare</code> creation process.
     * </p>
     * 
     * @return The organization node to whom you are going to share. When you pass <code>OrganizationNode</code>, it
     *         creates <code>PortfolioShare</code> for all of the Amazon Web Services accounts that are associated to
     *         the <code>OrganizationNode</code>. The output returns a <code>PortfolioShareToken</code>, which enables
     *         the administrator to monitor the status of the <code>PortfolioShare</code> creation process.
     */
    public final OrganizationNode organizationNode() {
        return organizationNode;
    }

    /**
     * <p>
     * Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not
     * provided, TagOptions sharing is disabled.
     * </p>
     * 
     * @return Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is
     *         not provided, TagOptions sharing is disabled.
     */
    public final Boolean shareTagOptions() {
        return shareTagOptions;
    }

    /**
     * <p>
     * This parameter is only supported for portfolios with an <b>OrganizationalNode</b> Type of
     * <code>ORGANIZATION</code> or <code>ORGANIZATIONAL_UNIT</code>.
     * </p>
     * <p>
     * Enables or disables <code>Principal</code> sharing when creating the portfolio share. If you do <b>not</b>
     * provide this flag, principal sharing is disabled.
     * </p>
     * <p>
     * When you enable Principal Name Sharing for a portfolio share, the share recipient account end users with a
     * principal that matches any of the associated IAM patterns can provision products from the portfolio. Once shared,
     * the share recipient can view associations of <code>PrincipalType</code>: <code>IAM_PATTERN</code> on their
     * portfolio. You can create the principals in the recipient account before or after creating the share.
     * </p>
     * 
     * @return This parameter is only supported for portfolios with an <b>OrganizationalNode</b> Type of
     *         <code>ORGANIZATION</code> or <code>ORGANIZATIONAL_UNIT</code>. </p>
     *         <p>
     *         Enables or disables <code>Principal</code> sharing when creating the portfolio share. If you do
     *         <b>not</b> provide this flag, principal sharing is disabled.
     *         </p>
     *         <p>
     *         When you enable Principal Name Sharing for a portfolio share, the share recipient account end users with
     *         a principal that matches any of the associated IAM patterns can provision products from the portfolio.
     *         Once shared, the share recipient can view associations of <code>PrincipalType</code>:
     *         <code>IAM_PATTERN</code> on their portfolio. You can create the principals in the recipient account
     *         before or after creating the share.
     */
    public final Boolean sharePrincipals() {
        return sharePrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationNode());
        hashCode = 31 * hashCode + Objects.hashCode(shareTagOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sharePrincipals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioShareRequest)) {
            return false;
        }
        CreatePortfolioShareRequest other = (CreatePortfolioShareRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(organizationNode(), other.organizationNode())
                && Objects.equals(shareTagOptions(), other.shareTagOptions())
                && Objects.equals(sharePrincipals(), other.sharePrincipals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePortfolioShareRequest").add("AcceptLanguage", acceptLanguage())
                .add("PortfolioId", portfolioId()).add("AccountId", accountId()).add("OrganizationNode", organizationNode())
                .add("ShareTagOptions", shareTagOptions()).add("SharePrincipals", sharePrincipals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "OrganizationNode":
            return Optional.ofNullable(clazz.cast(organizationNode()));
        case "ShareTagOptions":
            return Optional.ofNullable(clazz.cast(shareTagOptions()));
        case "SharePrincipals":
            return Optional.ofNullable(clazz.cast(sharePrincipals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("PortfolioId", PORTFOLIO_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("OrganizationNode", ORGANIZATION_NODE_FIELD);
        map.put("ShareTagOptions", SHARE_TAG_OPTIONS_FIELD);
        map.put("SharePrincipals", SHARE_PRINCIPALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePortfolioShareRequest, T> g) {
        return obj -> g.apply((CreatePortfolioShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePortfolioShareRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The portfolio identifier.
         * </p>
         * 
         * @param portfolioId
         *        The portfolio identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The Amazon Web Services account ID. For example, <code>123456789012</code>.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID. For example, <code>123456789012</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The organization node to whom you are going to share. When you pass <code>OrganizationNode</code>, it creates
         * <code>PortfolioShare</code> for all of the Amazon Web Services accounts that are associated to the
         * <code>OrganizationNode</code>. The output returns a <code>PortfolioShareToken</code>, which enables the
         * administrator to monitor the status of the <code>PortfolioShare</code> creation process.
         * </p>
         * 
         * @param organizationNode
         *        The organization node to whom you are going to share. When you pass <code>OrganizationNode</code>, it
         *        creates <code>PortfolioShare</code> for all of the Amazon Web Services accounts that are associated to
         *        the <code>OrganizationNode</code>. The output returns a <code>PortfolioShareToken</code>, which
         *        enables the administrator to monitor the status of the <code>PortfolioShare</code> creation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationNode(OrganizationNode organizationNode);

        /**
         * <p>
         * The organization node to whom you are going to share. When you pass <code>OrganizationNode</code>, it creates
         * <code>PortfolioShare</code> for all of the Amazon Web Services accounts that are associated to the
         * <code>OrganizationNode</code>. The output returns a <code>PortfolioShareToken</code>, which enables the
         * administrator to monitor the status of the <code>PortfolioShare</code> creation process.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationNode.Builder} avoiding the
         * need to create one manually via {@link OrganizationNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationNode.Builder#build()} is called immediately and its
         * result is passed to {@link #organizationNode(OrganizationNode)}.
         * 
         * @param organizationNode
         *        a consumer that will call methods on {@link OrganizationNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationNode(OrganizationNode)
         */
        default Builder organizationNode(Consumer<OrganizationNode.Builder> organizationNode) {
            return organizationNode(OrganizationNode.builder().applyMutation(organizationNode).build());
        }

        /**
         * <p>
         * Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag is not
         * provided, TagOptions sharing is disabled.
         * </p>
         * 
         * @param shareTagOptions
         *        Enables or disables <code>TagOptions </code> sharing when creating the portfolio share. If this flag
         *        is not provided, TagOptions sharing is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareTagOptions(Boolean shareTagOptions);

        /**
         * <p>
         * This parameter is only supported for portfolios with an <b>OrganizationalNode</b> Type of
         * <code>ORGANIZATION</code> or <code>ORGANIZATIONAL_UNIT</code>.
         * </p>
         * <p>
         * Enables or disables <code>Principal</code> sharing when creating the portfolio share. If you do <b>not</b>
         * provide this flag, principal sharing is disabled.
         * </p>
         * <p>
         * When you enable Principal Name Sharing for a portfolio share, the share recipient account end users with a
         * principal that matches any of the associated IAM patterns can provision products from the portfolio. Once
         * shared, the share recipient can view associations of <code>PrincipalType</code>: <code>IAM_PATTERN</code> on
         * their portfolio. You can create the principals in the recipient account before or after creating the share.
         * </p>
         * 
         * @param sharePrincipals
         *        This parameter is only supported for portfolios with an <b>OrganizationalNode</b> Type of
         *        <code>ORGANIZATION</code> or <code>ORGANIZATIONAL_UNIT</code>. </p>
         *        <p>
         *        Enables or disables <code>Principal</code> sharing when creating the portfolio share. If you do
         *        <b>not</b> provide this flag, principal sharing is disabled.
         *        </p>
         *        <p>
         *        When you enable Principal Name Sharing for a portfolio share, the share recipient account end users
         *        with a principal that matches any of the associated IAM patterns can provision products from the
         *        portfolio. Once shared, the share recipient can view associations of <code>PrincipalType</code>:
         *        <code>IAM_PATTERN</code> on their portfolio. You can create the principals in the recipient account
         *        before or after creating the share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePrincipals(Boolean sharePrincipals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String portfolioId;

        private String accountId;

        private OrganizationNode organizationNode;

        private Boolean shareTagOptions;

        private Boolean sharePrincipals;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortfolioShareRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            portfolioId(model.portfolioId);
            accountId(model.accountId);
            organizationNode(model.organizationNode);
            shareTagOptions(model.shareTagOptions);
            sharePrincipals(model.sharePrincipals);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final OrganizationNode.Builder getOrganizationNode() {
            return organizationNode != null ? organizationNode.toBuilder() : null;
        }

        public final void setOrganizationNode(OrganizationNode.BuilderImpl organizationNode) {
            this.organizationNode = organizationNode != null ? organizationNode.build() : null;
        }

        @Override
        public final Builder organizationNode(OrganizationNode organizationNode) {
            this.organizationNode = organizationNode;
            return this;
        }

        public final Boolean getShareTagOptions() {
            return shareTagOptions;
        }

        public final void setShareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
        }

        @Override
        public final Builder shareTagOptions(Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
            return this;
        }

        public final Boolean getSharePrincipals() {
            return sharePrincipals;
        }

        public final void setSharePrincipals(Boolean sharePrincipals) {
            this.sharePrincipals = sharePrincipals;
        }

        @Override
        public final Builder sharePrincipals(Boolean sharePrincipals) {
            this.sharePrincipals = sharePrincipals;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortfolioShareRequest build() {
            return new CreatePortfolioShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
