/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProvisionedProductPlanResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<CreateProvisionedProductPlanResponse.Builder, CreateProvisionedProductPlanResponse> {
    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlanName").getter(getter(CreateProvisionedProductPlanResponse::planName))
            .setter(setter(Builder::planName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()).build();

    private static final SdkField<String> PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PlanId")
            .getter(getter(CreateProvisionedProductPlanResponse::planId)).setter(setter(Builder::planId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()).build();

    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionProductId").getter(getter(CreateProvisionedProductPlanResponse::provisionProductId))
            .setter(setter(Builder::provisionProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build())
            .build();

    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductName").getter(getter(CreateProvisionedProductPlanResponse::provisionedProductName))
            .setter(setter(Builder::provisionedProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build())
            .build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(CreateProvisionedProductPlanResponse::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_NAME_FIELD,
            PLAN_ID_FIELD, PROVISION_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String planName;

    private final String planId;

    private final String provisionProductId;

    private final String provisionedProductName;

    private final String provisioningArtifactId;

    private CreateProvisionedProductPlanResponse(BuilderImpl builder) {
        super(builder);
        this.planName = builder.planName;
        this.planId = builder.planId;
        this.provisionProductId = builder.provisionProductId;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
    }

    /**
     * <p>
     * The name of the plan.
     * </p>
     * 
     * @return The name of the plan.
     */
    public final String planName() {
        return planName;
    }

    /**
     * <p>
     * The plan identifier.
     * </p>
     * 
     * @return The plan identifier.
     */
    public final String planId() {
        return planId;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String provisionProductId() {
        return provisionProductId;
    }

    /**
     * <p>
     * The user-friendly name of the provisioned product.
     * </p>
     * 
     * @return The user-friendly name of the provisioned product.
     */
    public final String provisionedProductName() {
        return provisionedProductName;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(planName());
        hashCode = 31 * hashCode + Objects.hashCode(planId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisionedProductPlanResponse)) {
            return false;
        }
        CreateProvisionedProductPlanResponse other = (CreateProvisionedProductPlanResponse) obj;
        return Objects.equals(planName(), other.planName()) && Objects.equals(planId(), other.planId())
                && Objects.equals(provisionProductId(), other.provisionProductId())
                && Objects.equals(provisionedProductName(), other.provisionedProductName())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProvisionedProductPlanResponse").add("PlanName", planName()).add("PlanId", planId())
                .add("ProvisionProductId", provisionProductId()).add("ProvisionedProductName", provisionedProductName())
                .add("ProvisioningArtifactId", provisioningArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlanName":
            return Optional.ofNullable(clazz.cast(planName()));
        case "PlanId":
            return Optional.ofNullable(clazz.cast(planId()));
        case "ProvisionProductId":
            return Optional.ofNullable(clazz.cast(provisionProductId()));
        case "ProvisionedProductName":
            return Optional.ofNullable(clazz.cast(provisionedProductName()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlanName", PLAN_NAME_FIELD);
        map.put("PlanId", PLAN_ID_FIELD);
        map.put("ProvisionProductId", PROVISION_PRODUCT_ID_FIELD);
        map.put("ProvisionedProductName", PROVISIONED_PRODUCT_NAME_FIELD);
        map.put("ProvisioningArtifactId", PROVISIONING_ARTIFACT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisionedProductPlanResponse, T> g) {
        return obj -> g.apply((CreateProvisionedProductPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProvisionedProductPlanResponse> {
        /**
         * <p>
         * The name of the plan.
         * </p>
         * 
         * @param planName
         *        The name of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planName(String planName);

        /**
         * <p>
         * The plan identifier.
         * </p>
         * 
         * @param planId
         *        The plan identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planId(String planId);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param provisionProductId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionProductId(String provisionProductId);

        /**
         * <p>
         * The user-friendly name of the provisioned product.
         * </p>
         * 
         * @param provisionedProductName
         *        The user-friendly name of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductName(String provisionedProductName);

        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String planName;

        private String planId;

        private String provisionProductId;

        private String provisionedProductName;

        private String provisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisionedProductPlanResponse model) {
            super(model);
            planName(model.planName);
            planId(model.planId);
            provisionProductId(model.provisionProductId);
            provisionedProductName(model.provisionedProductName);
            provisioningArtifactId(model.provisioningArtifactId);
        }

        public final String getPlanName() {
            return planName;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final String getPlanId() {
            return planId;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final String getProvisionProductId() {
            return provisionProductId;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final String getProvisionedProductName() {
            return provisionedProductName;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        @Override
        public CreateProvisionedProductPlanResponse build() {
            return new CreateProvisionedProductPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
