/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCopyProductStatusResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeCopyProductStatusResponse.Builder, DescribeCopyProductStatusResponse> {
    private static final SdkField<String> COPY_PRODUCT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyProductStatus").getter(getter(DescribeCopyProductStatusResponse::copyProductStatusAsString))
            .setter(setter(Builder::copyProductStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyProductStatus").build()).build();

    private static final SdkField<String> TARGET_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetProductId").getter(getter(DescribeCopyProductStatusResponse::targetProductId))
            .setter(setter(Builder::targetProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetProductId").build()).build();

    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetail").getter(getter(DescribeCopyProductStatusResponse::statusDetail))
            .setter(setter(Builder::statusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_PRODUCT_STATUS_FIELD,
            TARGET_PRODUCT_ID_FIELD, STATUS_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String copyProductStatus;

    private final String targetProductId;

    private final String statusDetail;

    private DescribeCopyProductStatusResponse(BuilderImpl builder) {
        super(builder);
        this.copyProductStatus = builder.copyProductStatus;
        this.targetProductId = builder.targetProductId;
        this.statusDetail = builder.statusDetail;
    }

    /**
     * <p>
     * The status of the copy product operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyProductStatus}
     * will return {@link CopyProductStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #copyProductStatusAsString}.
     * </p>
     * 
     * @return The status of the copy product operation.
     * @see CopyProductStatus
     */
    public final CopyProductStatus copyProductStatus() {
        return CopyProductStatus.fromValue(copyProductStatus);
    }

    /**
     * <p>
     * The status of the copy product operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyProductStatus}
     * will return {@link CopyProductStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #copyProductStatusAsString}.
     * </p>
     * 
     * @return The status of the copy product operation.
     * @see CopyProductStatus
     */
    public final String copyProductStatusAsString() {
        return copyProductStatus;
    }

    /**
     * <p>
     * The identifier of the copied product.
     * </p>
     * 
     * @return The identifier of the copied product.
     */
    public final String targetProductId() {
        return targetProductId;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusDetail() {
        return statusDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(copyProductStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetProductId());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCopyProductStatusResponse)) {
            return false;
        }
        DescribeCopyProductStatusResponse other = (DescribeCopyProductStatusResponse) obj;
        return Objects.equals(copyProductStatusAsString(), other.copyProductStatusAsString())
                && Objects.equals(targetProductId(), other.targetProductId())
                && Objects.equals(statusDetail(), other.statusDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCopyProductStatusResponse").add("CopyProductStatus", copyProductStatusAsString())
                .add("TargetProductId", targetProductId()).add("StatusDetail", statusDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyProductStatus":
            return Optional.ofNullable(clazz.cast(copyProductStatusAsString()));
        case "TargetProductId":
            return Optional.ofNullable(clazz.cast(targetProductId()));
        case "StatusDetail":
            return Optional.ofNullable(clazz.cast(statusDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CopyProductStatus", COPY_PRODUCT_STATUS_FIELD);
        map.put("TargetProductId", TARGET_PRODUCT_ID_FIELD);
        map.put("StatusDetail", STATUS_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCopyProductStatusResponse, T> g) {
        return obj -> g.apply((DescribeCopyProductStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCopyProductStatusResponse> {
        /**
         * <p>
         * The status of the copy product operation.
         * </p>
         * 
         * @param copyProductStatus
         *        The status of the copy product operation.
         * @see CopyProductStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyProductStatus
         */
        Builder copyProductStatus(String copyProductStatus);

        /**
         * <p>
         * The status of the copy product operation.
         * </p>
         * 
         * @param copyProductStatus
         *        The status of the copy product operation.
         * @see CopyProductStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyProductStatus
         */
        Builder copyProductStatus(CopyProductStatus copyProductStatus);

        /**
         * <p>
         * The identifier of the copied product.
         * </p>
         * 
         * @param targetProductId
         *        The identifier of the copied product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetProductId(String targetProductId);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusDetail
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetail(String statusDetail);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String copyProductStatus;

        private String targetProductId;

        private String statusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCopyProductStatusResponse model) {
            super(model);
            copyProductStatus(model.copyProductStatus);
            targetProductId(model.targetProductId);
            statusDetail(model.statusDetail);
        }

        public final String getCopyProductStatus() {
            return copyProductStatus;
        }

        public final void setCopyProductStatus(String copyProductStatus) {
            this.copyProductStatus = copyProductStatus;
        }

        @Override
        public final Builder copyProductStatus(String copyProductStatus) {
            this.copyProductStatus = copyProductStatus;
            return this;
        }

        @Override
        public final Builder copyProductStatus(CopyProductStatus copyProductStatus) {
            this.copyProductStatus(copyProductStatus == null ? null : copyProductStatus.toString());
            return this;
        }

        public final String getTargetProductId() {
            return targetProductId;
        }

        public final void setTargetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
        }

        @Override
        public final Builder targetProductId(String targetProductId) {
            this.targetProductId = targetProductId;
            return this;
        }

        public final String getStatusDetail() {
            return statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        @Override
        public DescribeCopyProductStatusResponse build() {
            return new DescribeCopyProductStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
