/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePortfolioSharesResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribePortfolioSharesResponse.Builder, DescribePortfolioSharesResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(DescribePortfolioSharesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<List<PortfolioShareDetail>> PORTFOLIO_SHARE_DETAILS_FIELD = SdkField
            .<List<PortfolioShareDetail>> builder(MarshallingType.LIST)
            .memberName("PortfolioShareDetails")
            .getter(getter(DescribePortfolioSharesResponse::portfolioShareDetails))
            .setter(setter(Builder::portfolioShareDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortfolioShareDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortfolioShareDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD,
            PORTFOLIO_SHARE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextPageToken;

    private final List<PortfolioShareDetail> portfolioShareDetails;

    private DescribePortfolioSharesResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.portfolioShareDetails = builder.portfolioShareDetails;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortfolioShareDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPortfolioShareDetails() {
        return portfolioShareDetails != null && !(portfolioShareDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries about each of the portfolio shares.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortfolioShareDetails} method.
     * </p>
     * 
     * @return Summaries about each of the portfolio shares.
     */
    public final List<PortfolioShareDetail> portfolioShareDetails() {
        return portfolioShareDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortfolioShareDetails() ? portfolioShareDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortfolioSharesResponse)) {
            return false;
        }
        DescribePortfolioSharesResponse other = (DescribePortfolioSharesResponse) obj;
        return Objects.equals(nextPageToken(), other.nextPageToken())
                && hasPortfolioShareDetails() == other.hasPortfolioShareDetails()
                && Objects.equals(portfolioShareDetails(), other.portfolioShareDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePortfolioSharesResponse").add("NextPageToken", nextPageToken())
                .add("PortfolioShareDetails", hasPortfolioShareDetails() ? portfolioShareDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "PortfolioShareDetails":
            return Optional.ofNullable(clazz.cast(portfolioShareDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("PortfolioShareDetails", PORTFOLIO_SHARE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePortfolioSharesResponse, T> g) {
        return obj -> g.apply((DescribePortfolioSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePortfolioSharesResponse> {
        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * Summaries about each of the portfolio shares.
         * </p>
         * 
         * @param portfolioShareDetails
         *        Summaries about each of the portfolio shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioShareDetails(Collection<PortfolioShareDetail> portfolioShareDetails);

        /**
         * <p>
         * Summaries about each of the portfolio shares.
         * </p>
         * 
         * @param portfolioShareDetails
         *        Summaries about each of the portfolio shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioShareDetails(PortfolioShareDetail... portfolioShareDetails);

        /**
         * <p>
         * Summaries about each of the portfolio shares.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #portfolioShareDetails(List<PortfolioShareDetail>)}.
         * 
         * @param portfolioShareDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portfolioShareDetails(java.util.Collection<PortfolioShareDetail>)
         */
        Builder portfolioShareDetails(Consumer<PortfolioShareDetail.Builder>... portfolioShareDetails);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String nextPageToken;

        private List<PortfolioShareDetail> portfolioShareDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortfolioSharesResponse model) {
            super(model);
            nextPageToken(model.nextPageToken);
            portfolioShareDetails(model.portfolioShareDetails);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final List<PortfolioShareDetail.Builder> getPortfolioShareDetails() {
            List<PortfolioShareDetail.Builder> result = PortfolioShareDetailsCopier.copyToBuilder(this.portfolioShareDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortfolioShareDetails(Collection<PortfolioShareDetail.BuilderImpl> portfolioShareDetails) {
            this.portfolioShareDetails = PortfolioShareDetailsCopier.copyFromBuilder(portfolioShareDetails);
        }

        @Override
        public final Builder portfolioShareDetails(Collection<PortfolioShareDetail> portfolioShareDetails) {
            this.portfolioShareDetails = PortfolioShareDetailsCopier.copy(portfolioShareDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioShareDetails(PortfolioShareDetail... portfolioShareDetails) {
            portfolioShareDetails(Arrays.asList(portfolioShareDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioShareDetails(Consumer<PortfolioShareDetail.Builder>... portfolioShareDetails) {
            portfolioShareDetails(Stream.of(portfolioShareDetails)
                    .map(c -> PortfolioShareDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePortfolioSharesResponse build() {
            return new DescribePortfolioSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
