/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProductAsAdminResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProductAsAdminResponse.Builder, DescribeProductAsAdminResponse> {
    private static final SdkField<ProductViewDetail> PRODUCT_VIEW_DETAIL_FIELD = SdkField
            .<ProductViewDetail> builder(MarshallingType.SDK_POJO).memberName("ProductViewDetail")
            .getter(getter(DescribeProductAsAdminResponse::productViewDetail)).setter(setter(Builder::productViewDetail))
            .constructor(ProductViewDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewDetail").build()).build();

    private static final SdkField<List<ProvisioningArtifactSummary>> PROVISIONING_ARTIFACT_SUMMARIES_FIELD = SdkField
            .<List<ProvisioningArtifactSummary>> builder(MarshallingType.LIST)
            .memberName("ProvisioningArtifactSummaries")
            .getter(getter(DescribeProductAsAdminResponse::provisioningArtifactSummaries))
            .setter(setter(Builder::provisioningArtifactSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribeProductAsAdminResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagOptionDetail>> TAG_OPTIONS_FIELD = SdkField
            .<List<TagOptionDetail>> builder(MarshallingType.LIST)
            .memberName("TagOptions")
            .getter(getter(DescribeProductAsAdminResponse::tagOptions))
            .setter(setter(Builder::tagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagOptionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagOptionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BudgetDetail>> BUDGETS_FIELD = SdkField
            .<List<BudgetDetail>> builder(MarshallingType.LIST)
            .memberName("Budgets")
            .getter(getter(DescribeProductAsAdminResponse::budgets))
            .setter(setter(Builder::budgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_DETAIL_FIELD,
            PROVISIONING_ARTIFACT_SUMMARIES_FIELD, TAGS_FIELD, TAG_OPTIONS_FIELD, BUDGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProductViewDetail productViewDetail;

    private final List<ProvisioningArtifactSummary> provisioningArtifactSummaries;

    private final List<Tag> tags;

    private final List<TagOptionDetail> tagOptions;

    private final List<BudgetDetail> budgets;

    private DescribeProductAsAdminResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetail = builder.productViewDetail;
        this.provisioningArtifactSummaries = builder.provisioningArtifactSummaries;
        this.tags = builder.tags;
        this.tagOptions = builder.tagOptions;
        this.budgets = builder.budgets;
    }

    /**
     * <p>
     * Information about the product view.
     * </p>
     * 
     * @return Information about the product view.
     */
    public final ProductViewDetail productViewDetail() {
        return productViewDetail;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningArtifactSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningArtifactSummaries() {
        return provisioningArtifactSummaries != null && !(provisioningArtifactSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the provisioning artifacts (also known as versions) for the specified product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningArtifactSummaries} method.
     * </p>
     * 
     * @return Information about the provisioning artifacts (also known as versions) for the specified product.
     */
    public final List<ProvisioningArtifactSummary> provisioningArtifactSummaries() {
        return provisioningArtifactSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the tags associated with the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Information about the tags associated with the product.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagOptions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagOptions() {
        return tagOptions != null && !(tagOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the TagOptions associated with the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagOptions} method.
     * </p>
     * 
     * @return Information about the TagOptions associated with the product.
     */
    public final List<TagOptionDetail> tagOptions() {
        return tagOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Budgets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBudgets() {
        return budgets != null && !(budgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associated budgets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBudgets} method.
     * </p>
     * 
     * @return Information about the associated budgets.
     */
    public final List<BudgetDetail> budgets() {
        return budgets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productViewDetail());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningArtifactSummaries() ? provisioningArtifactSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagOptions() ? tagOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBudgets() ? budgets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductAsAdminResponse)) {
            return false;
        }
        DescribeProductAsAdminResponse other = (DescribeProductAsAdminResponse) obj;
        return Objects.equals(productViewDetail(), other.productViewDetail())
                && hasProvisioningArtifactSummaries() == other.hasProvisioningArtifactSummaries()
                && Objects.equals(provisioningArtifactSummaries(), other.provisioningArtifactSummaries())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasTagOptions() == other.hasTagOptions() && Objects.equals(tagOptions(), other.tagOptions())
                && hasBudgets() == other.hasBudgets() && Objects.equals(budgets(), other.budgets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeProductAsAdminResponse")
                .add("ProductViewDetail", productViewDetail())
                .add("ProvisioningArtifactSummaries", hasProvisioningArtifactSummaries() ? provisioningArtifactSummaries() : null)
                .add("Tags", hasTags() ? tags() : null).add("TagOptions", hasTagOptions() ? tagOptions() : null)
                .add("Budgets", hasBudgets() ? budgets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewDetail":
            return Optional.ofNullable(clazz.cast(productViewDetail()));
        case "ProvisioningArtifactSummaries":
            return Optional.ofNullable(clazz.cast(provisioningArtifactSummaries()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TagOptions":
            return Optional.ofNullable(clazz.cast(tagOptions()));
        case "Budgets":
            return Optional.ofNullable(clazz.cast(budgets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductViewDetail", PRODUCT_VIEW_DETAIL_FIELD);
        map.put("ProvisioningArtifactSummaries", PROVISIONING_ARTIFACT_SUMMARIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TagOptions", TAG_OPTIONS_FIELD);
        map.put("Budgets", BUDGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductAsAdminResponse, T> g) {
        return obj -> g.apply((DescribeProductAsAdminResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProductAsAdminResponse> {
        /**
         * <p>
         * Information about the product view.
         * </p>
         * 
         * @param productViewDetail
         *        Information about the product view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewDetail(ProductViewDetail productViewDetail);

        /**
         * <p>
         * Information about the product view.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProductViewDetail.Builder} avoiding the
         * need to create one manually via {@link ProductViewDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProductViewDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #productViewDetail(ProductViewDetail)}.
         * 
         * @param productViewDetail
         *        a consumer that will call methods on {@link ProductViewDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewDetail(ProductViewDetail)
         */
        default Builder productViewDetail(Consumer<ProductViewDetail.Builder> productViewDetail) {
            return productViewDetail(ProductViewDetail.builder().applyMutation(productViewDetail).build());
        }

        /**
         * <p>
         * Information about the provisioning artifacts (also known as versions) for the specified product.
         * </p>
         * 
         * @param provisioningArtifactSummaries
         *        Information about the provisioning artifacts (also known as versions) for the specified product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> provisioningArtifactSummaries);

        /**
         * <p>
         * Information about the provisioning artifacts (also known as versions) for the specified product.
         * </p>
         * 
         * @param provisioningArtifactSummaries
         *        Information about the provisioning artifacts (also known as versions) for the specified product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactSummaries(ProvisioningArtifactSummary... provisioningArtifactSummaries);

        /**
         * <p>
         * Information about the provisioning artifacts (also known as versions) for the specified product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisioningArtifactSummaries(List<ProvisioningArtifactSummary>)}.
         * 
         * @param provisioningArtifactSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactSummaries(java.util.Collection<ProvisioningArtifactSummary>)
         */
        Builder provisioningArtifactSummaries(Consumer<ProvisioningArtifactSummary.Builder>... provisioningArtifactSummaries);

        /**
         * <p>
         * Information about the tags associated with the product.
         * </p>
         * 
         * @param tags
         *        Information about the tags associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Information about the tags associated with the product.
         * </p>
         * 
         * @param tags
         *        Information about the tags associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Information about the tags associated with the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.servicecatalog.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Information about the TagOptions associated with the product.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(Collection<TagOptionDetail> tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the product.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(TagOptionDetail... tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #tagOptions(List<TagOptionDetail>)}.
         * 
         * @param tagOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagOptions(java.util.Collection<TagOptionDetail>)
         */
        Builder tagOptions(Consumer<TagOptionDetail.Builder>... tagOptions);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * 
         * @param budgets
         *        Information about the associated budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Collection<BudgetDetail> budgets);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * 
         * @param budgets
         *        Information about the associated budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(BudgetDetail... budgets);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.BudgetDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.servicecatalog.model.BudgetDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.BudgetDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #budgets(List<BudgetDetail>)}.
         * 
         * @param budgets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.BudgetDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgets(java.util.Collection<BudgetDetail>)
         */
        Builder budgets(Consumer<BudgetDetail.Builder>... budgets);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProductViewDetail productViewDetail;

        private List<ProvisioningArtifactSummary> provisioningArtifactSummaries = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<TagOptionDetail> tagOptions = DefaultSdkAutoConstructList.getInstance();

        private List<BudgetDetail> budgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductAsAdminResponse model) {
            super(model);
            productViewDetail(model.productViewDetail);
            provisioningArtifactSummaries(model.provisioningArtifactSummaries);
            tags(model.tags);
            tagOptions(model.tagOptions);
            budgets(model.budgets);
        }

        public final ProductViewDetail.Builder getProductViewDetail() {
            return productViewDetail != null ? productViewDetail.toBuilder() : null;
        }

        public final void setProductViewDetail(ProductViewDetail.BuilderImpl productViewDetail) {
            this.productViewDetail = productViewDetail != null ? productViewDetail.build() : null;
        }

        @Override
        public final Builder productViewDetail(ProductViewDetail productViewDetail) {
            this.productViewDetail = productViewDetail;
            return this;
        }

        public final List<ProvisioningArtifactSummary.Builder> getProvisioningArtifactSummaries() {
            List<ProvisioningArtifactSummary.Builder> result = ProvisioningArtifactSummariesCopier
                    .copyToBuilder(this.provisioningArtifactSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningArtifactSummaries(
                Collection<ProvisioningArtifactSummary.BuilderImpl> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier
                    .copyFromBuilder(provisioningArtifactSummaries);
        }

        @Override
        public final Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier.copy(provisioningArtifactSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(ProvisioningArtifactSummary... provisioningArtifactSummaries) {
            provisioningArtifactSummaries(Arrays.asList(provisioningArtifactSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(
                Consumer<ProvisioningArtifactSummary.Builder>... provisioningArtifactSummaries) {
            provisioningArtifactSummaries(Stream.of(provisioningArtifactSummaries)
                    .map(c -> ProvisioningArtifactSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagOptionDetail.Builder> getTagOptions() {
            List<TagOptionDetail.Builder> result = TagOptionDetailsCopier.copyToBuilder(this.tagOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagOptions(Collection<TagOptionDetail.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copyFromBuilder(tagOptions);
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionDetail> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionDetail... tagOptions) {
            tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionDetail.Builder>... tagOptions) {
            tagOptions(Stream.of(tagOptions).map(c -> TagOptionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BudgetDetail.Builder> getBudgets() {
            List<BudgetDetail.Builder> result = BudgetsCopier.copyToBuilder(this.budgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgets(Collection<BudgetDetail.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        @Override
        public final Builder budgets(Collection<BudgetDetail> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetDetail... budgets) {
            budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetDetail.Builder>... budgets) {
            budgets(Stream.of(budgets).map(c -> BudgetDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeProductAsAdminResponse build() {
            return new DescribeProductAsAdminResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
