/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the product's connection sync and contains the following sub-fields.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>LastSyncTime</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LastSyncStatus</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LastSyncStatusMessage</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LastSuccessfulSyncTime</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LastSuccessfulSyncProvisioningArtifactID</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastSync implements SdkPojo, Serializable, ToCopyableBuilder<LastSync.Builder, LastSync> {
    private static final SdkField<Instant> LAST_SYNC_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSyncTime").getter(getter(LastSync::lastSyncTime)).setter(setter(Builder::lastSyncTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncTime").build()).build();

    private static final SdkField<String> LAST_SYNC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastSyncStatus").getter(getter(LastSync::lastSyncStatusAsString))
            .setter(setter(Builder::lastSyncStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncStatus").build()).build();

    private static final SdkField<String> LAST_SYNC_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastSyncStatusMessage").getter(getter(LastSync::lastSyncStatusMessage))
            .setter(setter(Builder::lastSyncStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncStatusMessage").build())
            .build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_SYNC_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulSyncTime").getter(getter(LastSync::lastSuccessfulSyncTime))
            .setter(setter(Builder::lastSuccessfulSyncTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulSyncTime").build())
            .build();

    private static final SdkField<String> LAST_SUCCESSFUL_SYNC_PROVISIONING_ARTIFACT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastSuccessfulSyncProvisioningArtifactId")
            .getter(getter(LastSync::lastSuccessfulSyncProvisioningArtifactId))
            .setter(setter(Builder::lastSuccessfulSyncProvisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LastSuccessfulSyncProvisioningArtifactId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_SYNC_TIME_FIELD,
            LAST_SYNC_STATUS_FIELD, LAST_SYNC_STATUS_MESSAGE_FIELD, LAST_SUCCESSFUL_SYNC_TIME_FIELD,
            LAST_SUCCESSFUL_SYNC_PROVISIONING_ARTIFACT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastSyncTime;

    private final String lastSyncStatus;

    private final String lastSyncStatusMessage;

    private final Instant lastSuccessfulSyncTime;

    private final String lastSuccessfulSyncProvisioningArtifactId;

    private LastSync(BuilderImpl builder) {
        this.lastSyncTime = builder.lastSyncTime;
        this.lastSyncStatus = builder.lastSyncStatus;
        this.lastSyncStatusMessage = builder.lastSyncStatusMessage;
        this.lastSuccessfulSyncTime = builder.lastSuccessfulSyncTime;
        this.lastSuccessfulSyncProvisioningArtifactId = builder.lastSuccessfulSyncProvisioningArtifactId;
    }

    /**
     * <p>
     * The time of the last attempted sync from the repository to the Service Catalog product.
     * </p>
     * 
     * @return The time of the last attempted sync from the repository to the Service Catalog product.
     */
    public final Instant lastSyncTime() {
        return lastSyncTime;
    }

    /**
     * <p>
     * The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastSyncStatus}
     * will return {@link LastSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastSyncStatusAsString}.
     * </p>
     * 
     * @return The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
     * @see LastSyncStatus
     */
    public final LastSyncStatus lastSyncStatus() {
        return LastSyncStatus.fromValue(lastSyncStatus);
    }

    /**
     * <p>
     * The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastSyncStatus}
     * will return {@link LastSyncStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastSyncStatusAsString}.
     * </p>
     * 
     * @return The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
     * @see LastSyncStatus
     */
    public final String lastSyncStatusAsString() {
        return lastSyncStatus;
    }

    /**
     * <p>
     * The sync's status message.
     * </p>
     * 
     * @return The sync's status message.
     */
    public final String lastSyncStatusMessage() {
        return lastSyncStatusMessage;
    }

    /**
     * <p>
     * The time of the latest successful sync from the source repo artifact to the Service Catalog product.
     * </p>
     * 
     * @return The time of the latest successful sync from the source repo artifact to the Service Catalog product.
     */
    public final Instant lastSuccessfulSyncTime() {
        return lastSuccessfulSyncTime;
    }

    /**
     * <p>
     * The ProvisioningArtifactID of the ProvisioningArtifact created from the latest successful sync.
     * </p>
     * 
     * @return The ProvisioningArtifactID of the ProvisioningArtifact created from the latest successful sync.
     */
    public final String lastSuccessfulSyncProvisioningArtifactId() {
        return lastSuccessfulSyncProvisioningArtifactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSyncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastSyncStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulSyncProvisioningArtifactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastSync)) {
            return false;
        }
        LastSync other = (LastSync) obj;
        return Objects.equals(lastSyncTime(), other.lastSyncTime())
                && Objects.equals(lastSyncStatusAsString(), other.lastSyncStatusAsString())
                && Objects.equals(lastSyncStatusMessage(), other.lastSyncStatusMessage())
                && Objects.equals(lastSuccessfulSyncTime(), other.lastSuccessfulSyncTime())
                && Objects.equals(lastSuccessfulSyncProvisioningArtifactId(), other.lastSuccessfulSyncProvisioningArtifactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastSync").add("LastSyncTime", lastSyncTime()).add("LastSyncStatus", lastSyncStatusAsString())
                .add("LastSyncStatusMessage", lastSyncStatusMessage()).add("LastSuccessfulSyncTime", lastSuccessfulSyncTime())
                .add("LastSuccessfulSyncProvisioningArtifactId", lastSuccessfulSyncProvisioningArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastSyncTime":
            return Optional.ofNullable(clazz.cast(lastSyncTime()));
        case "LastSyncStatus":
            return Optional.ofNullable(clazz.cast(lastSyncStatusAsString()));
        case "LastSyncStatusMessage":
            return Optional.ofNullable(clazz.cast(lastSyncStatusMessage()));
        case "LastSuccessfulSyncTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulSyncTime()));
        case "LastSuccessfulSyncProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(lastSuccessfulSyncProvisioningArtifactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LastSyncTime", LAST_SYNC_TIME_FIELD);
        map.put("LastSyncStatus", LAST_SYNC_STATUS_FIELD);
        map.put("LastSyncStatusMessage", LAST_SYNC_STATUS_MESSAGE_FIELD);
        map.put("LastSuccessfulSyncTime", LAST_SUCCESSFUL_SYNC_TIME_FIELD);
        map.put("LastSuccessfulSyncProvisioningArtifactId", LAST_SUCCESSFUL_SYNC_PROVISIONING_ARTIFACT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastSync, T> g) {
        return obj -> g.apply((LastSync) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastSync> {
        /**
         * <p>
         * The time of the last attempted sync from the repository to the Service Catalog product.
         * </p>
         * 
         * @param lastSyncTime
         *        The time of the last attempted sync from the repository to the Service Catalog product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSyncTime(Instant lastSyncTime);

        /**
         * <p>
         * The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param lastSyncStatus
         *        The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
         * @see LastSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastSyncStatus
         */
        Builder lastSyncStatus(String lastSyncStatus);

        /**
         * <p>
         * The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param lastSyncStatus
         *        The current status of the sync. Responses include <code>SUCCEEDED</code> or <code>FAILED</code>.
         * @see LastSyncStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastSyncStatus
         */
        Builder lastSyncStatus(LastSyncStatus lastSyncStatus);

        /**
         * <p>
         * The sync's status message.
         * </p>
         * 
         * @param lastSyncStatusMessage
         *        The sync's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSyncStatusMessage(String lastSyncStatusMessage);

        /**
         * <p>
         * The time of the latest successful sync from the source repo artifact to the Service Catalog product.
         * </p>
         * 
         * @param lastSuccessfulSyncTime
         *        The time of the latest successful sync from the source repo artifact to the Service Catalog product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulSyncTime(Instant lastSuccessfulSyncTime);

        /**
         * <p>
         * The ProvisioningArtifactID of the ProvisioningArtifact created from the latest successful sync.
         * </p>
         * 
         * @param lastSuccessfulSyncProvisioningArtifactId
         *        The ProvisioningArtifactID of the ProvisioningArtifact created from the latest successful sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulSyncProvisioningArtifactId(String lastSuccessfulSyncProvisioningArtifactId);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastSyncTime;

        private String lastSyncStatus;

        private String lastSyncStatusMessage;

        private Instant lastSuccessfulSyncTime;

        private String lastSuccessfulSyncProvisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(LastSync model) {
            lastSyncTime(model.lastSyncTime);
            lastSyncStatus(model.lastSyncStatus);
            lastSyncStatusMessage(model.lastSyncStatusMessage);
            lastSuccessfulSyncTime(model.lastSuccessfulSyncTime);
            lastSuccessfulSyncProvisioningArtifactId(model.lastSuccessfulSyncProvisioningArtifactId);
        }

        public final Instant getLastSyncTime() {
            return lastSyncTime;
        }

        public final void setLastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
        }

        @Override
        public final Builder lastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
            return this;
        }

        public final String getLastSyncStatus() {
            return lastSyncStatus;
        }

        public final void setLastSyncStatus(String lastSyncStatus) {
            this.lastSyncStatus = lastSyncStatus;
        }

        @Override
        public final Builder lastSyncStatus(String lastSyncStatus) {
            this.lastSyncStatus = lastSyncStatus;
            return this;
        }

        @Override
        public final Builder lastSyncStatus(LastSyncStatus lastSyncStatus) {
            this.lastSyncStatus(lastSyncStatus == null ? null : lastSyncStatus.toString());
            return this;
        }

        public final String getLastSyncStatusMessage() {
            return lastSyncStatusMessage;
        }

        public final void setLastSyncStatusMessage(String lastSyncStatusMessage) {
            this.lastSyncStatusMessage = lastSyncStatusMessage;
        }

        @Override
        public final Builder lastSyncStatusMessage(String lastSyncStatusMessage) {
            this.lastSyncStatusMessage = lastSyncStatusMessage;
            return this;
        }

        public final Instant getLastSuccessfulSyncTime() {
            return lastSuccessfulSyncTime;
        }

        public final void setLastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
        }

        @Override
        public final Builder lastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
            return this;
        }

        public final String getLastSuccessfulSyncProvisioningArtifactId() {
            return lastSuccessfulSyncProvisioningArtifactId;
        }

        public final void setLastSuccessfulSyncProvisioningArtifactId(String lastSuccessfulSyncProvisioningArtifactId) {
            this.lastSuccessfulSyncProvisioningArtifactId = lastSuccessfulSyncProvisioningArtifactId;
        }

        @Override
        public final Builder lastSuccessfulSyncProvisioningArtifactId(String lastSuccessfulSyncProvisioningArtifactId) {
            this.lastSuccessfulSyncProvisioningArtifactId = lastSuccessfulSyncProvisioningArtifactId;
            return this;
        }

        @Override
        public LastSync build() {
            return new LastSync(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
