/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAcceptedPortfolioSharesRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ListAcceptedPortfolioSharesRequest.Builder, ListAcceptedPortfolioSharesRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(ListAcceptedPortfolioSharesRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListAcceptedPortfolioSharesRequest::pageToken))
            .setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListAcceptedPortfolioSharesRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PORTFOLIO_SHARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioShareType").getter(getter(ListAcceptedPortfolioSharesRequest::portfolioShareTypeAsString))
            .setter(setter(Builder::portfolioShareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, PORTFOLIO_SHARE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String pageToken;

    private final Integer pageSize;

    private final String portfolioShareType;

    private ListAcceptedPortfolioSharesRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
        this.portfolioShareType = builder.portfolioShareType;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The type of shared portfolios to list. The default is to list imported portfolios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the management
     * account or delegated administrator of your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICECATALOG</code> - Deprecated type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through account-to-account
     * sharing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #portfolioShareType} will return {@link PortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #portfolioShareTypeAsString}.
     * </p>
     * 
     * @return The type of shared portfolios to list. The default is to list imported portfolios.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the
     *         management account or delegated administrator of your organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICECATALOG</code> - Deprecated type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through
     *         account-to-account sharing.
     *         </p>
     *         </li>
     * @see PortfolioShareType
     */
    public final PortfolioShareType portfolioShareType() {
        return PortfolioShareType.fromValue(portfolioShareType);
    }

    /**
     * <p>
     * The type of shared portfolios to list. The default is to list imported portfolios.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the management
     * account or delegated administrator of your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_SERVICECATALOG</code> - Deprecated type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through account-to-account
     * sharing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #portfolioShareType} will return {@link PortfolioShareType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #portfolioShareTypeAsString}.
     * </p>
     * 
     * @return The type of shared portfolios to list. The default is to list imported portfolios.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the
     *         management account or delegated administrator of your organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_SERVICECATALOG</code> - Deprecated type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through
     *         account-to-account sharing.
     *         </p>
     *         </li>
     * @see PortfolioShareType
     */
    public final String portfolioShareTypeAsString() {
        return portfolioShareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioShareTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAcceptedPortfolioSharesRequest)) {
            return false;
        }
        ListAcceptedPortfolioSharesRequest other = (ListAcceptedPortfolioSharesRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(pageToken(), other.pageToken())
                && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(portfolioShareTypeAsString(), other.portfolioShareTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAcceptedPortfolioSharesRequest").add("AcceptLanguage", acceptLanguage())
                .add("PageToken", pageToken()).add("PageSize", pageSize())
                .add("PortfolioShareType", portfolioShareTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PortfolioShareType":
            return Optional.ofNullable(clazz.cast(portfolioShareTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("PageToken", PAGE_TOKEN_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("PortfolioShareType", PORTFOLIO_SHARE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAcceptedPortfolioSharesRequest, T> g) {
        return obj -> g.apply((ListAcceptedPortfolioSharesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAcceptedPortfolioSharesRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The type of shared portfolios to list. The default is to list imported portfolios.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the
         * management account or delegated administrator of your organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICECATALOG</code> - Deprecated type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through
         * account-to-account sharing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param portfolioShareType
         *        The type of shared portfolios to list. The default is to list imported portfolios.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the
         *        management account or delegated administrator of your organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICECATALOG</code> - Deprecated type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through
         *        account-to-account sharing.
         *        </p>
         *        </li>
         * @see PortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortfolioShareType
         */
        Builder portfolioShareType(String portfolioShareType);

        /**
         * <p>
         * The type of shared portfolios to list. The default is to list imported portfolios.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the
         * management account or delegated administrator of your organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_SERVICECATALOG</code> - Deprecated type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through
         * account-to-account sharing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param portfolioShareType
         *        The type of shared portfolios to list. The default is to list imported portfolios.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_ORGANIZATIONS</code> - List portfolios accepted and shared via organizational sharing by the
         *        management account or delegated administrator of your organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_SERVICECATALOG</code> - Deprecated type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPORTED</code> - List imported portfolios that have been accepted and shared through
         *        account-to-account sharing.
         *        </p>
         *        </li>
         * @see PortfolioShareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortfolioShareType
         */
        Builder portfolioShareType(PortfolioShareType portfolioShareType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String pageToken;

        private Integer pageSize;

        private String portfolioShareType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAcceptedPortfolioSharesRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            pageToken(model.pageToken);
            pageSize(model.pageSize);
            portfolioShareType(model.portfolioShareType);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPortfolioShareType() {
            return portfolioShareType;
        }

        public final void setPortfolioShareType(String portfolioShareType) {
            this.portfolioShareType = portfolioShareType;
        }

        @Override
        public final Builder portfolioShareType(String portfolioShareType) {
            this.portfolioShareType = portfolioShareType;
            return this;
        }

        @Override
        public final Builder portfolioShareType(PortfolioShareType portfolioShareType) {
            this.portfolioShareType(portfolioShareType == null ? null : portfolioShareType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAcceptedPortfolioSharesRequest build() {
            return new ListAcceptedPortfolioSharesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
