/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisionedProductPlansRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ListProvisionedProductPlansRequest.Builder, ListProvisionedProductPlansRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(ListProvisionedProductPlansRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionProductId").getter(getter(ListProvisionedProductPlansRequest::provisionProductId))
            .setter(setter(Builder::provisionProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build())
            .build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListProvisionedProductPlansRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListProvisionedProductPlansRequest::pageToken))
            .setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final SdkField<AccessLevelFilter> ACCESS_LEVEL_FILTER_FIELD = SdkField
            .<AccessLevelFilter> builder(MarshallingType.SDK_POJO).memberName("AccessLevelFilter")
            .getter(getter(ListProvisionedProductPlansRequest::accessLevelFilter)).setter(setter(Builder::accessLevelFilter))
            .constructor(AccessLevelFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevelFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PROVISION_PRODUCT_ID_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD, ACCESS_LEVEL_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String provisionProductId;

    private final Integer pageSize;

    private final String pageToken;

    private final AccessLevelFilter accessLevelFilter;

    private ListProvisionedProductPlansRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionProductId = builder.provisionProductId;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
        this.accessLevelFilter = builder.accessLevelFilter;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String provisionProductId() {
        return provisionProductId;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * The access level to use to obtain results. The default is <code>User</code>.
     * </p>
     * 
     * @return The access level to use to obtain results. The default is <code>User</code>.
     */
    public final AccessLevelFilter accessLevelFilter() {
        return accessLevelFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessLevelFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedProductPlansRequest)) {
            return false;
        }
        ListProvisionedProductPlansRequest other = (ListProvisionedProductPlansRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(provisionProductId(), other.provisionProductId())
                && Objects.equals(pageSize(), other.pageSize()) && Objects.equals(pageToken(), other.pageToken())
                && Objects.equals(accessLevelFilter(), other.accessLevelFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProvisionedProductPlansRequest").add("AcceptLanguage", acceptLanguage())
                .add("ProvisionProductId", provisionProductId()).add("PageSize", pageSize()).add("PageToken", pageToken())
                .add("AccessLevelFilter", accessLevelFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProvisionProductId":
            return Optional.ofNullable(clazz.cast(provisionProductId()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "AccessLevelFilter":
            return Optional.ofNullable(clazz.cast(accessLevelFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("ProvisionProductId", PROVISION_PRODUCT_ID_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("PageToken", PAGE_TOKEN_FIELD);
        map.put("AccessLevelFilter", ACCESS_LEVEL_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedProductPlansRequest, T> g) {
        return obj -> g.apply((ListProvisionedProductPlansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisionedProductPlansRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param provisionProductId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionProductId(String provisionProductId);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * The access level to use to obtain results. The default is <code>User</code>.
         * </p>
         * 
         * @param accessLevelFilter
         *        The access level to use to obtain results. The default is <code>User</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLevelFilter(AccessLevelFilter accessLevelFilter);

        /**
         * <p>
         * The access level to use to obtain results. The default is <code>User</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessLevelFilter.Builder} avoiding the
         * need to create one manually via {@link AccessLevelFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessLevelFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLevelFilter(AccessLevelFilter)}.
         * 
         * @param accessLevelFilter
         *        a consumer that will call methods on {@link AccessLevelFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLevelFilter(AccessLevelFilter)
         */
        default Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return accessLevelFilter(AccessLevelFilter.builder().applyMutation(accessLevelFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String provisionProductId;

        private Integer pageSize;

        private String pageToken;

        private AccessLevelFilter accessLevelFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedProductPlansRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            provisionProductId(model.provisionProductId);
            pageSize(model.pageSize);
            pageToken(model.pageToken);
            accessLevelFilter(model.accessLevelFilter);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProvisionProductId() {
            return provisionProductId;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return accessLevelFilter != null ? accessLevelFilter.toBuilder() : null;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProvisionedProductPlansRequest build() {
            return new ListProvisionedProductPlansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
