/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a product view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductViewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductViewSummary.Builder, ProductViewSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProductViewSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ProductViewSummary::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProductViewSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(ProductViewSummary::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortDescription").getter(getter(ProductViewSummary::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ProductViewSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DISTRIBUTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Distributor").getter(getter(ProductViewSummary::distributor)).setter(setter(Builder::distributor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributor").build()).build();

    private static final SdkField<Boolean> HAS_DEFAULT_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasDefaultPath").getter(getter(ProductViewSummary::hasDefaultPath))
            .setter(setter(Builder::hasDefaultPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasDefaultPath").build()).build();

    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportEmail").getter(getter(ProductViewSummary::supportEmail)).setter(setter(Builder::supportEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()).build();

    private static final SdkField<String> SUPPORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportDescription").getter(getter(ProductViewSummary::supportDescription))
            .setter(setter(Builder::supportDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportDescription").build())
            .build();

    private static final SdkField<String> SUPPORT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportUrl").getter(getter(ProductViewSummary::supportUrl)).setter(setter(Builder::supportUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PRODUCT_ID_FIELD,
            NAME_FIELD, OWNER_FIELD, SHORT_DESCRIPTION_FIELD, TYPE_FIELD, DISTRIBUTOR_FIELD, HAS_DEFAULT_PATH_FIELD,
            SUPPORT_EMAIL_FIELD, SUPPORT_DESCRIPTION_FIELD, SUPPORT_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String productId;

    private final String name;

    private final String owner;

    private final String shortDescription;

    private final String type;

    private final String distributor;

    private final Boolean hasDefaultPath;

    private final String supportEmail;

    private final String supportDescription;

    private final String supportUrl;

    private ProductViewSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.productId = builder.productId;
        this.name = builder.name;
        this.owner = builder.owner;
        this.shortDescription = builder.shortDescription;
        this.type = builder.type;
        this.distributor = builder.distributor;
        this.hasDefaultPath = builder.hasDefaultPath;
        this.supportEmail = builder.supportEmail;
        this.supportDescription = builder.supportDescription;
        this.supportUrl = builder.supportUrl;
    }

    /**
     * <p>
     * The product view identifier.
     * </p>
     * 
     * @return The product view identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The name of the product.
     * </p>
     * 
     * @return The name of the product.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the product. Contact the product administrator for the significance of this value.
     * </p>
     * 
     * @return The owner of the product. Contact the product administrator for the significance of this value.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * Short description of the product.
     * </p>
     * 
     * @return Short description of the product.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * The product type. Contact the product administrator for the significance of this value. If this value is
     * <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The product type. Contact the product administrator for the significance of this value. If this value is
     *         <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
     * @see ProductType
     */
    public final ProductType type() {
        return ProductType.fromValue(type);
    }

    /**
     * <p>
     * The product type. Contact the product administrator for the significance of this value. If this value is
     * <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The product type. Contact the product administrator for the significance of this value. If this value is
     *         <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
     * @see ProductType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The distributor of the product. Contact the product administrator for the significance of this value.
     * </p>
     * 
     * @return The distributor of the product. Contact the product administrator for the significance of this value.
     */
    public final String distributor() {
        return distributor;
    }

    /**
     * <p>
     * Indicates whether the product has a default path. If the product does not have a default path, call
     * <a>ListLaunchPaths</a> to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not required, and the
     * output of <a>ProductViewSummary</a> can be used directly with <a>DescribeProvisioningParameters</a>.
     * </p>
     * 
     * @return Indicates whether the product has a default path. If the product does not have a default path, call
     *         <a>ListLaunchPaths</a> to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not required,
     *         and the output of <a>ProductViewSummary</a> can be used directly with
     *         <a>DescribeProvisioningParameters</a>.
     */
    public final Boolean hasDefaultPath() {
        return hasDefaultPath;
    }

    /**
     * <p>
     * The email contact information to obtain support for this Product.
     * </p>
     * 
     * @return The email contact information to obtain support for this Product.
     */
    public final String supportEmail() {
        return supportEmail;
    }

    /**
     * <p>
     * The description of the support for this Product.
     * </p>
     * 
     * @return The description of the support for this Product.
     */
    public final String supportDescription() {
        return supportDescription;
    }

    /**
     * <p>
     * The URL information to obtain support for this Product.
     * </p>
     * 
     * @return The URL information to obtain support for this Product.
     */
    public final String supportUrl() {
        return supportUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(distributor());
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultPath());
        hashCode = 31 * hashCode + Objects.hashCode(supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(supportUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewSummary)) {
            return false;
        }
        ProductViewSummary other = (ProductViewSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(productId(), other.productId())
                && Objects.equals(name(), other.name()) && Objects.equals(owner(), other.owner())
                && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(distributor(), other.distributor())
                && Objects.equals(hasDefaultPath(), other.hasDefaultPath())
                && Objects.equals(supportEmail(), other.supportEmail())
                && Objects.equals(supportDescription(), other.supportDescription())
                && Objects.equals(supportUrl(), other.supportUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductViewSummary").add("Id", id()).add("ProductId", productId()).add("Name", name())
                .add("Owner", owner()).add("ShortDescription", shortDescription()).add("Type", typeAsString())
                .add("Distributor", distributor()).add("HasDefaultPath", hasDefaultPath()).add("SupportEmail", supportEmail())
                .add("SupportDescription", supportDescription()).add("SupportUrl", supportUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ShortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Distributor":
            return Optional.ofNullable(clazz.cast(distributor()));
        case "HasDefaultPath":
            return Optional.ofNullable(clazz.cast(hasDefaultPath()));
        case "SupportEmail":
            return Optional.ofNullable(clazz.cast(supportEmail()));
        case "SupportDescription":
            return Optional.ofNullable(clazz.cast(supportDescription()));
        case "SupportUrl":
            return Optional.ofNullable(clazz.cast(supportUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("ShortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Distributor", DISTRIBUTOR_FIELD);
        map.put("HasDefaultPath", HAS_DEFAULT_PATH_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportDescription", SUPPORT_DESCRIPTION_FIELD);
        map.put("SupportUrl", SUPPORT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductViewSummary, T> g) {
        return obj -> g.apply((ProductViewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductViewSummary> {
        /**
         * <p>
         * The product view identifier.
         * </p>
         * 
         * @param id
         *        The product view identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param productId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The name of the product.
         * </p>
         * 
         * @param name
         *        The name of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the product. Contact the product administrator for the significance of this value.
         * </p>
         * 
         * @param owner
         *        The owner of the product. Contact the product administrator for the significance of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Short description of the product.
         * </p>
         * 
         * @param shortDescription
         *        Short description of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * The product type. Contact the product administrator for the significance of this value. If this value is
         * <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
         * </p>
         * 
         * @param type
         *        The product type. Contact the product administrator for the significance of this value. If this value
         *        is <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
         * @see ProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductType
         */
        Builder type(String type);

        /**
         * <p>
         * The product type. Contact the product administrator for the significance of this value. If this value is
         * <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
         * </p>
         * 
         * @param type
         *        The product type. Contact the product administrator for the significance of this value. If this value
         *        is <code>MARKETPLACE</code>, the product was created by Amazon Web Services Marketplace.
         * @see ProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProductType
         */
        Builder type(ProductType type);

        /**
         * <p>
         * The distributor of the product. Contact the product administrator for the significance of this value.
         * </p>
         * 
         * @param distributor
         *        The distributor of the product. Contact the product administrator for the significance of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributor(String distributor);

        /**
         * <p>
         * Indicates whether the product has a default path. If the product does not have a default path, call
         * <a>ListLaunchPaths</a> to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not required, and
         * the output of <a>ProductViewSummary</a> can be used directly with <a>DescribeProvisioningParameters</a>.
         * </p>
         * 
         * @param hasDefaultPath
         *        Indicates whether the product has a default path. If the product does not have a default path, call
         *        <a>ListLaunchPaths</a> to disambiguate between paths. Otherwise, <a>ListLaunchPaths</a> is not
         *        required, and the output of <a>ProductViewSummary</a> can be used directly with
         *        <a>DescribeProvisioningParameters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasDefaultPath(Boolean hasDefaultPath);

        /**
         * <p>
         * The email contact information to obtain support for this Product.
         * </p>
         * 
         * @param supportEmail
         *        The email contact information to obtain support for this Product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportEmail(String supportEmail);

        /**
         * <p>
         * The description of the support for this Product.
         * </p>
         * 
         * @param supportDescription
         *        The description of the support for this Product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportDescription(String supportDescription);

        /**
         * <p>
         * The URL information to obtain support for this Product.
         * </p>
         * 
         * @param supportUrl
         *        The URL information to obtain support for this Product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportUrl(String supportUrl);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String productId;

        private String name;

        private String owner;

        private String shortDescription;

        private String type;

        private String distributor;

        private Boolean hasDefaultPath;

        private String supportEmail;

        private String supportDescription;

        private String supportUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewSummary model) {
            id(model.id);
            productId(model.productId);
            name(model.name);
            owner(model.owner);
            shortDescription(model.shortDescription);
            type(model.type);
            distributor(model.distributor);
            hasDefaultPath(model.hasDefaultPath);
            supportEmail(model.supportEmail);
            supportDescription(model.supportDescription);
            supportUrl(model.supportUrl);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProductType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDistributor() {
            return distributor;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final Boolean getHasDefaultPath() {
            return hasDefaultPath;
        }

        public final void setHasDefaultPath(Boolean hasDefaultPath) {
            this.hasDefaultPath = hasDefaultPath;
        }

        @Override
        public final Builder hasDefaultPath(Boolean hasDefaultPath) {
            this.hasDefaultPath = hasDefaultPath;
            return this;
        }

        public final String getSupportEmail() {
            return supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportDescription() {
            return supportDescription;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final String getSupportUrl() {
            return supportUrl;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        @Override
        public ProductViewSummary build() {
            return new ProductViewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
