/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ProvisionProductRequest.Builder, ProvisionProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(ProvisionProductRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ProvisionProductRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(ProvisionProductRequest::productName)).setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(ProvisionProductRequest::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactName").getter(getter(ProvisionProductRequest::provisioningArtifactName))
            .setter(setter(Builder::provisioningArtifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build())
            .build();

    private static final SdkField<String> PATH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PathId")
            .getter(getter(ProvisionProductRequest::pathId)).setter(setter(Builder::pathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()).build();

    private static final SdkField<String> PATH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PathName").getter(getter(ProvisionProductRequest::pathName)).setter(setter(Builder::pathName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathName").build()).build();

    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductName").getter(getter(ProvisionProductRequest::provisionedProductName))
            .setter(setter(Builder::provisionedProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build())
            .build();

    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField
            .<List<ProvisioningParameter>> builder(MarshallingType.LIST)
            .memberName("ProvisioningParameters")
            .getter(getter(ProvisionProductRequest::provisioningParameters))
            .setter(setter(Builder::provisioningParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisioningPreferences> PROVISIONING_PREFERENCES_FIELD = SdkField
            .<ProvisioningPreferences> builder(MarshallingType.SDK_POJO).memberName("ProvisioningPreferences")
            .getter(getter(ProvisionProductRequest::provisioningPreferences)).setter(setter(Builder::provisioningPreferences))
            .constructor(ProvisioningPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningPreferences").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ProvisionProductRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationArns")
            .getter(getter(ProvisionProductRequest::notificationArns))
            .setter(setter(Builder::notificationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVISION_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProvisionToken")
            .getter(getter(ProvisionProductRequest::provisionToken))
            .setter(setter(Builder::provisionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD,
            PATH_ID_FIELD, PATH_NAME_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONING_PARAMETERS_FIELD,
            PROVISIONING_PREFERENCES_FIELD, TAGS_FIELD, NOTIFICATION_ARNS_FIELD, PROVISION_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String productId;

    private final String productName;

    private final String provisioningArtifactId;

    private final String provisioningArtifactName;

    private final String pathId;

    private final String pathName;

    private final String provisionedProductName;

    private final List<ProvisioningParameter> provisioningParameters;

    private final ProvisioningPreferences provisioningPreferences;

    private final List<Tag> tags;

    private final List<String> notificationArns;

    private final String provisionToken;

    private ProvisionProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.pathId = builder.pathId;
        this.pathName = builder.pathName;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningParameters = builder.provisioningParameters;
        this.provisioningPreferences = builder.provisioningPreferences;
        this.tags = builder.tags;
        this.notificationArns = builder.notificationArns;
        this.provisionToken = builder.provisionToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The product identifier. You must provide the name or ID, but not both.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The name of the product. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the product. You must provide the name or ID, but not both.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The identifier of the provisioning artifact. You must provide the name or ID, but not both.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The name of the provisioning artifact. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the provisioning artifact. You must provide the name or ID, but not both.
     */
    public final String provisioningArtifactName() {
        return provisioningArtifactName;
    }

    /**
     * <p>
     * The path identifier of the product. This value is optional if the product has a default path, and required if the
     * product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>. You must provide the
     * name or ID, but not both.
     * </p>
     * 
     * @return The path identifier of the product. This value is optional if the product has a default path, and
     *         required if the product has more than one path. To list the paths for a product, use
     *         <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.
     */
    public final String pathId() {
        return pathId;
    }

    /**
     * <p>
     * The name of the path. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the path. You must provide the name or ID, but not both.
     */
    public final String pathName() {
        return pathName;
    }

    /**
     * <p>
     * A user-friendly name for the provisioned product. This value must be unique for the Amazon Web Services account
     * and cannot be updated after the product is provisioned.
     * </p>
     * 
     * @return A user-friendly name for the provisioned product. This value must be unique for the Amazon Web Services
     *         account and cannot be updated after the product is provisioned.
     */
    public final String provisionedProductName() {
        return provisionedProductName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningParameters() {
        return provisioningParameters != null && !(provisioningParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parameters specified by the administrator that are required for provisioning the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningParameters} method.
     * </p>
     * 
     * @return Parameters specified by the administrator that are required for provisioning the product.
     */
    public final List<ProvisioningParameter> provisioningParameters() {
        return provisioningParameters;
    }

    /**
     * <p>
     * An object that contains information about the provisioning preferences for a stack set.
     * </p>
     * 
     * @return An object that contains information about the provisioning preferences for a stack set.
     */
    public final ProvisioningPreferences provisioningPreferences() {
        return provisioningPreferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationArns() {
        return notificationArns != null && !(notificationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationArns} method.
     * </p>
     * 
     * @return Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    public final List<String> notificationArns() {
        return notificationArns;
    }

    /**
     * <p>
     * An idempotency token that uniquely identifies the provisioning request.
     * </p>
     * 
     * @return An idempotency token that uniquely identifies the provisioning request.
     */
    public final String provisionToken() {
        return provisionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(pathId());
        hashCode = 31 * hashCode + Objects.hashCode(pathName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningParameters() ? provisioningParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioningPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationArns() ? notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionProductRequest)) {
            return false;
        }
        ProvisionProductRequest other = (ProvisionProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(productId(), other.productId())
                && Objects.equals(productName(), other.productName())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(provisioningArtifactName(), other.provisioningArtifactName())
                && Objects.equals(pathId(), other.pathId()) && Objects.equals(pathName(), other.pathName())
                && Objects.equals(provisionedProductName(), other.provisionedProductName())
                && hasProvisioningParameters() == other.hasProvisioningParameters()
                && Objects.equals(provisioningParameters(), other.provisioningParameters())
                && Objects.equals(provisioningPreferences(), other.provisioningPreferences()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasNotificationArns() == other.hasNotificationArns()
                && Objects.equals(notificationArns(), other.notificationArns())
                && Objects.equals(provisionToken(), other.provisionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionProductRequest").add("AcceptLanguage", acceptLanguage()).add("ProductId", productId())
                .add("ProductName", productName()).add("ProvisioningArtifactId", provisioningArtifactId())
                .add("ProvisioningArtifactName", provisioningArtifactName()).add("PathId", pathId()).add("PathName", pathName())
                .add("ProvisionedProductName", provisionedProductName())
                .add("ProvisioningParameters", hasProvisioningParameters() ? provisioningParameters() : null)
                .add("ProvisioningPreferences", provisioningPreferences()).add("Tags", hasTags() ? tags() : null)
                .add("NotificationArns", hasNotificationArns() ? notificationArns() : null)
                .add("ProvisionToken", provisionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "ProvisioningArtifactName":
            return Optional.ofNullable(clazz.cast(provisioningArtifactName()));
        case "PathId":
            return Optional.ofNullable(clazz.cast(pathId()));
        case "PathName":
            return Optional.ofNullable(clazz.cast(pathName()));
        case "ProvisionedProductName":
            return Optional.ofNullable(clazz.cast(provisionedProductName()));
        case "ProvisioningParameters":
            return Optional.ofNullable(clazz.cast(provisioningParameters()));
        case "ProvisioningPreferences":
            return Optional.ofNullable(clazz.cast(provisioningPreferences()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NotificationArns":
            return Optional.ofNullable(clazz.cast(notificationArns()));
        case "ProvisionToken":
            return Optional.ofNullable(clazz.cast(provisionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("ProductName", PRODUCT_NAME_FIELD);
        map.put("ProvisioningArtifactId", PROVISIONING_ARTIFACT_ID_FIELD);
        map.put("ProvisioningArtifactName", PROVISIONING_ARTIFACT_NAME_FIELD);
        map.put("PathId", PATH_ID_FIELD);
        map.put("PathName", PATH_NAME_FIELD);
        map.put("ProvisionedProductName", PROVISIONED_PRODUCT_NAME_FIELD);
        map.put("ProvisioningParameters", PROVISIONING_PARAMETERS_FIELD);
        map.put("ProvisioningPreferences", PROVISIONING_PREFERENCES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NotificationArns", NOTIFICATION_ARNS_FIELD);
        map.put("ProvisionToken", PROVISION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionProductRequest, T> g) {
        return obj -> g.apply((ProvisionProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param productId
         *        The product identifier. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The name of the product. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param productName
         *        The name of the product. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The identifier of the provisioning artifact. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The name of the provisioning artifact. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param provisioningArtifactName
         *        The name of the provisioning artifact. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactName(String provisioningArtifactName);

        /**
         * <p>
         * The path identifier of the product. This value is optional if the product has a default path, and required if
         * the product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>. You must
         * provide the name or ID, but not both.
         * </p>
         * 
         * @param pathId
         *        The path identifier of the product. This value is optional if the product has a default path, and
         *        required if the product has more than one path. To list the paths for a product, use
         *        <a>ListLaunchPaths</a>. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathId(String pathId);

        /**
         * <p>
         * The name of the path. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param pathName
         *        The name of the path. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathName(String pathName);

        /**
         * <p>
         * A user-friendly name for the provisioned product. This value must be unique for the Amazon Web Services
         * account and cannot be updated after the product is provisioned.
         * </p>
         * 
         * @param provisionedProductName
         *        A user-friendly name for the provisioned product. This value must be unique for the Amazon Web
         *        Services account and cannot be updated after the product is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductName(String provisionedProductName);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * 
         * @param provisioningParameters
         *        Parameters specified by the administrator that are required for provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * 
         * @param provisioningParameters
         *        Parameters specified by the administrator that are required for provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(ProvisioningParameter... provisioningParameters);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningParameters(List<ProvisioningParameter>)}.
         * 
         * @param provisioningParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningParameters(java.util.Collection<ProvisioningParameter>)
         */
        Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters);

        /**
         * <p>
         * An object that contains information about the provisioning preferences for a stack set.
         * </p>
         * 
         * @param provisioningPreferences
         *        An object that contains information about the provisioning preferences for a stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningPreferences(ProvisioningPreferences provisioningPreferences);

        /**
         * <p>
         * An object that contains information about the provisioning preferences for a stack set.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningPreferences.Builder} avoiding
         * the need to create one manually via {@link ProvisioningPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningPreferences.Builder#build()} is called immediately
         * and its result is passed to {@link #provisioningPreferences(ProvisioningPreferences)}.
         * 
         * @param provisioningPreferences
         *        a consumer that will call methods on {@link ProvisioningPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningPreferences(ProvisioningPreferences)
         */
        default Builder provisioningPreferences(Consumer<ProvisioningPreferences.Builder> provisioningPreferences) {
            return provisioningPreferences(ProvisioningPreferences.builder().applyMutation(provisioningPreferences).build());
        }

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.servicecatalog.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * </p>
         * 
         * @param notificationArns
         *        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(Collection<String> notificationArns);

        /**
         * <p>
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * </p>
         * 
         * @param notificationArns
         *        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(String... notificationArns);

        /**
         * <p>
         * An idempotency token that uniquely identifies the provisioning request.
         * </p>
         * 
         * @param provisionToken
         *        An idempotency token that uniquely identifies the provisioning request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionToken(String provisionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String productId;

        private String productName;

        private String provisioningArtifactId;

        private String provisioningArtifactName;

        private String pathId;

        private String pathName;

        private String provisionedProductName;

        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private ProvisioningPreferences provisioningPreferences;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();

        private String provisionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            productId(model.productId);
            productName(model.productName);
            provisioningArtifactId(model.provisioningArtifactId);
            provisioningArtifactName(model.provisioningArtifactName);
            pathId(model.pathId);
            pathName(model.pathName);
            provisionedProductName(model.provisionedProductName);
            provisioningParameters(model.provisioningParameters);
            provisioningPreferences(model.provisioningPreferences);
            tags(model.tags);
            notificationArns(model.notificationArns);
            provisionToken(model.provisionToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductName() {
            return productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getProvisioningArtifactName() {
            return provisioningArtifactName;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        @Override
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final String getPathId() {
            return pathId;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final String getPathName() {
            return pathName;
        }

        public final void setPathName(String pathName) {
            this.pathName = pathName;
        }

        @Override
        public final Builder pathName(String pathName) {
            this.pathName = pathName;
            return this;
        }

        public final String getProvisionedProductName() {
            return provisionedProductName;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final List<ProvisioningParameter.Builder> getProvisioningParameters() {
            List<ProvisioningParameter.Builder> result = ProvisioningParametersCopier.copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter... provisioningParameters) {
            provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters) {
            provisioningParameters(Stream.of(provisioningParameters)
                    .map(c -> ProvisioningParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProvisioningPreferences.Builder getProvisioningPreferences() {
            return provisioningPreferences != null ? provisioningPreferences.toBuilder() : null;
        }

        public final void setProvisioningPreferences(ProvisioningPreferences.BuilderImpl provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences != null ? provisioningPreferences.build() : null;
        }

        @Override
        public final Builder provisioningPreferences(ProvisioningPreferences provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNotificationArns() {
            if (notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationArns;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String... notificationArns) {
            notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final String getProvisionToken() {
            return provisionToken;
        }

        public final void setProvisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
        }

        @Override
        public final Builder provisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionProductRequest build() {
            return new ProvisionProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
