/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a provisioning artifact. A provisioning artifact is also known as a product version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningArtifact implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningArtifact.Builder, ProvisioningArtifact> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProvisioningArtifact::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ProvisioningArtifact::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ProvisioningArtifact::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ProvisioningArtifact::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> GUIDANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Guidance").getter(getter(ProvisioningArtifact::guidanceAsString)).setter(setter(Builder::guidance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Guidance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CREATED_TIME_FIELD, GUIDANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final Instant createdTime;

    private final String guidance;

    private ProvisioningArtifact(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.guidance = builder.guidance;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the provisioning artifact.
     * </p>
     * 
     * @return The name of the provisioning artifact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the provisioning artifact.
     * </p>
     * 
     * @return The description of the provisioning artifact.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The UTC time stamp of the creation time.
     * </p>
     * 
     * @return The UTC time stamp of the creation time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guidance} will
     * return {@link ProvisioningArtifactGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #guidanceAsString}.
     * </p>
     * 
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts
     *         to use.
     * @see ProvisioningArtifactGuidance
     */
    public final ProvisioningArtifactGuidance guidance() {
        return ProvisioningArtifactGuidance.fromValue(guidance);
    }

    /**
     * <p>
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guidance} will
     * return {@link ProvisioningArtifactGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #guidanceAsString}.
     * </p>
     * 
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts
     *         to use.
     * @see ProvisioningArtifactGuidance
     */
    public final String guidanceAsString() {
        return guidance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(guidanceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifact)) {
            return false;
        }
        ProvisioningArtifact other = (ProvisioningArtifact) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(guidanceAsString(), other.guidanceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisioningArtifact").add("Id", id()).add("Name", name()).add("Description", description())
                .add("CreatedTime", createdTime()).add("Guidance", guidanceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Guidance":
            return Optional.ofNullable(clazz.cast(guidanceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("Guidance", GUIDANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifact, T> g) {
        return obj -> g.apply((ProvisioningArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningArtifact> {
        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param id
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the provisioning artifact.
         * </p>
         * 
         * @param name
         *        The name of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the provisioning artifact.
         * </p>
         * 
         * @param description
         *        The description of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The UTC time stamp of the creation time.
         * </p>
         * 
         * @param createdTime
         *        The UTC time stamp of the creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to
         * use.
         * </p>
         * 
         * @param guidance
         *        Information set by the administrator to provide guidance to end users about which provisioning
         *        artifacts to use.
         * @see ProvisioningArtifactGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactGuidance
         */
        Builder guidance(String guidance);

        /**
         * <p>
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to
         * use.
         * </p>
         * 
         * @param guidance
         *        Information set by the administrator to provide guidance to end users about which provisioning
         *        artifacts to use.
         * @see ProvisioningArtifactGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactGuidance
         */
        Builder guidance(ProvisioningArtifactGuidance guidance);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private Instant createdTime;

        private String guidance;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifact model) {
            id(model.id);
            name(model.name);
            description(model.description);
            createdTime(model.createdTime);
            guidance(model.guidance);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getGuidance() {
            return guidance;
        }

        public final void setGuidance(String guidance) {
            this.guidance = guidance;
        }

        @Override
        public final Builder guidance(String guidance) {
            this.guidance = guidance;
            return this;
        }

        @Override
        public final Builder guidance(ProvisioningArtifactGuidance guidance) {
            this.guidance(guidance == null ? null : guidance.toString());
            return this;
        }

        @Override
        public ProvisioningArtifact build() {
            return new ProvisioningArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
