/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a change to a resource attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTargetDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTargetDefinition.Builder, ResourceTargetDefinition> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(ResourceTargetDefinition::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ResourceTargetDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REQUIRES_RECREATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequiresRecreation").getter(getter(ResourceTargetDefinition::requiresRecreationAsString))
            .setter(setter(Builder::requiresRecreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresRecreation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, NAME_FIELD,
            REQUIRES_RECREATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String name;

    private final String requiresRecreation;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
    }

    /**
     * <p>
     * The attribute to be changed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResourceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to be changed.
     * @see ResourceAttribute
     */
    public final ResourceAttribute attribute() {
        return ResourceAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute to be changed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResourceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to be changed.
     * @see ResourceAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * If the attribute is <code>Properties</code>, the value is the name of the property. Otherwise, the value is null.
     * </p>
     * 
     * @return If the attribute is <code>Properties</code>, the value is the name of the property. Otherwise, the value
     *         is null.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If the attribute is <code>Properties</code>, indicates whether a change to this property causes the resource to
     * be re-created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requiresRecreation} will return {@link RequiresRecreation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requiresRecreationAsString}.
     * </p>
     * 
     * @return If the attribute is <code>Properties</code>, indicates whether a change to this property causes the
     *         resource to be re-created.
     * @see RequiresRecreation
     */
    public final RequiresRecreation requiresRecreation() {
        return RequiresRecreation.fromValue(requiresRecreation);
    }

    /**
     * <p>
     * If the attribute is <code>Properties</code>, indicates whether a change to this property causes the resource to
     * be re-created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requiresRecreation} will return {@link RequiresRecreation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requiresRecreationAsString}.
     * </p>
     * 
     * @return If the attribute is <code>Properties</code>, indicates whether a change to this property causes the
     *         resource to be re-created.
     * @see RequiresRecreation
     */
    public final String requiresRecreationAsString() {
        return requiresRecreation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requiresRecreationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(requiresRecreationAsString(), other.requiresRecreationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTargetDefinition").add("Attribute", attributeAsString()).add("Name", name())
                .add("RequiresRecreation", requiresRecreationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequiresRecreation":
            return Optional.ofNullable(clazz.cast(requiresRecreationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RequiresRecreation", REQUIRES_RECREATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTargetDefinition, T> g) {
        return obj -> g.apply((ResourceTargetDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTargetDefinition> {
        /**
         * <p>
         * The attribute to be changed.
         * </p>
         * 
         * @param attribute
         *        The attribute to be changed.
         * @see ResourceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to be changed.
         * </p>
         * 
         * @param attribute
         *        The attribute to be changed.
         * @see ResourceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(ResourceAttribute attribute);

        /**
         * <p>
         * If the attribute is <code>Properties</code>, the value is the name of the property. Otherwise, the value is
         * null.
         * </p>
         * 
         * @param name
         *        If the attribute is <code>Properties</code>, the value is the name of the property. Otherwise, the
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If the attribute is <code>Properties</code>, indicates whether a change to this property causes the resource
         * to be re-created.
         * </p>
         * 
         * @param requiresRecreation
         *        If the attribute is <code>Properties</code>, indicates whether a change to this property causes the
         *        resource to be re-created.
         * @see RequiresRecreation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(String requiresRecreation);

        /**
         * <p>
         * If the attribute is <code>Properties</code>, indicates whether a change to this property causes the resource
         * to be re-created.
         * </p>
         * 
         * @param requiresRecreation
         *        If the attribute is <code>Properties</code>, indicates whether a change to this property causes the
         *        resource to be re-created.
         * @see RequiresRecreation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(RequiresRecreation requiresRecreation);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String name;

        private String requiresRecreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            attribute(model.attribute);
            name(model.name);
            requiresRecreation(model.requiresRecreation);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequiresRecreation() {
            return requiresRecreation;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation == null ? null : requiresRecreation.toString());
            return this;
        }

        @Override
        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
