/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchProvisionedProductsResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<SearchProvisionedProductsResponse.Builder, SearchProvisionedProductsResponse> {
    private static final SdkField<List<ProvisionedProductAttribute>> PROVISIONED_PRODUCTS_FIELD = SdkField
            .<List<ProvisionedProductAttribute>> builder(MarshallingType.LIST)
            .memberName("ProvisionedProducts")
            .getter(getter(SearchProvisionedProductsResponse::provisionedProducts))
            .setter(setter(Builder::provisionedProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProducts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisionedProductAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisionedProductAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_RESULTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalResultsCount").getter(getter(SearchProvisionedProductsResponse::totalResultsCount))
            .setter(setter(Builder::totalResultsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResultsCount").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(SearchProvisionedProductsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCTS_FIELD,
            TOTAL_RESULTS_COUNT_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProvisionedProductAttribute> provisionedProducts;

    private final Integer totalResultsCount;

    private final String nextPageToken;

    private SearchProvisionedProductsResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProducts = builder.provisionedProducts;
        this.totalResultsCount = builder.totalResultsCount;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedProducts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProvisionedProducts() {
        return provisionedProducts != null && !(provisionedProducts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the provisioned products.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedProducts} method.
     * </p>
     * 
     * @return Information about the provisioned products.
     */
    public final List<ProvisionedProductAttribute> provisionedProducts() {
        return provisionedProducts;
    }

    /**
     * <p>
     * The number of provisioned products found.
     * </p>
     * 
     * @return The number of provisioned products found.
     */
    public final Integer totalResultsCount() {
        return totalResultsCount;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedProducts() ? provisionedProducts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalResultsCount());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProvisionedProductsResponse)) {
            return false;
        }
        SearchProvisionedProductsResponse other = (SearchProvisionedProductsResponse) obj;
        return hasProvisionedProducts() == other.hasProvisionedProducts()
                && Objects.equals(provisionedProducts(), other.provisionedProducts())
                && Objects.equals(totalResultsCount(), other.totalResultsCount())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchProvisionedProductsResponse")
                .add("ProvisionedProducts", hasProvisionedProducts() ? provisionedProducts() : null)
                .add("TotalResultsCount", totalResultsCount()).add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProducts":
            return Optional.ofNullable(clazz.cast(provisionedProducts()));
        case "TotalResultsCount":
            return Optional.ofNullable(clazz.cast(totalResultsCount()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProvisionedProducts", PROVISIONED_PRODUCTS_FIELD);
        map.put("TotalResultsCount", TOTAL_RESULTS_COUNT_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchProvisionedProductsResponse, T> g) {
        return obj -> g.apply((SearchProvisionedProductsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchProvisionedProductsResponse> {
        /**
         * <p>
         * Information about the provisioned products.
         * </p>
         * 
         * @param provisionedProducts
         *        Information about the provisioned products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProducts(Collection<ProvisionedProductAttribute> provisionedProducts);

        /**
         * <p>
         * Information about the provisioned products.
         * </p>
         * 
         * @param provisionedProducts
         *        Information about the provisioned products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProducts(ProvisionedProductAttribute... provisionedProducts);

        /**
         * <p>
         * Information about the provisioned products.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisionedProducts(List<ProvisionedProductAttribute>)}.
         * 
         * @param provisionedProducts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedProducts(java.util.Collection<ProvisionedProductAttribute>)
         */
        Builder provisionedProducts(Consumer<ProvisionedProductAttribute.Builder>... provisionedProducts);

        /**
         * <p>
         * The number of provisioned products found.
         * </p>
         * 
         * @param totalResultsCount
         *        The number of provisioned products found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResultsCount(Integer totalResultsCount);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProvisionedProductAttribute> provisionedProducts = DefaultSdkAutoConstructList.getInstance();

        private Integer totalResultsCount;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProvisionedProductsResponse model) {
            super(model);
            provisionedProducts(model.provisionedProducts);
            totalResultsCount(model.totalResultsCount);
            nextPageToken(model.nextPageToken);
        }

        public final List<ProvisionedProductAttribute.Builder> getProvisionedProducts() {
            List<ProvisionedProductAttribute.Builder> result = ProvisionedProductAttributesCopier
                    .copyToBuilder(this.provisionedProducts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedProducts(Collection<ProvisionedProductAttribute.BuilderImpl> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductAttributesCopier.copyFromBuilder(provisionedProducts);
        }

        @Override
        public final Builder provisionedProducts(Collection<ProvisionedProductAttribute> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductAttributesCopier.copy(provisionedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(ProvisionedProductAttribute... provisionedProducts) {
            provisionedProducts(Arrays.asList(provisionedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(Consumer<ProvisionedProductAttribute.Builder>... provisionedProducts) {
            provisionedProducts(Stream.of(provisionedProducts)
                    .map(c -> ProvisionedProductAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalResultsCount() {
            return totalResultsCount;
        }

        public final void setTotalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
        }

        @Override
        public final Builder totalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public SearchProvisionedProductsResponse build() {
            return new SearchProvisionedProductsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
