/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the configured <code>SourceConnection</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConnectionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConnectionDetail.Builder, SourceConnectionDetail> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SourceConnectionDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<SourceConnectionParameters> CONNECTION_PARAMETERS_FIELD = SdkField
            .<SourceConnectionParameters> builder(MarshallingType.SDK_POJO).memberName("ConnectionParameters")
            .getter(getter(SourceConnectionDetail::connectionParameters)).setter(setter(Builder::connectionParameters))
            .constructor(SourceConnectionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionParameters").build())
            .build();

    private static final SdkField<LastSync> LAST_SYNC_FIELD = SdkField.<LastSync> builder(MarshallingType.SDK_POJO)
            .memberName("LastSync").getter(getter(SourceConnectionDetail::lastSync)).setter(setter(Builder::lastSync))
            .constructor(LastSync::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSync").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            CONNECTION_PARAMETERS_FIELD, LAST_SYNC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final SourceConnectionParameters connectionParameters;

    private final LastSync lastSync;

    private SourceConnectionDetail(BuilderImpl builder) {
        this.type = builder.type;
        this.connectionParameters = builder.connectionParameters;
        this.lastSync = builder.lastSync;
    }

    /**
     * <p>
     * The only supported <code>SourceConnection</code> type is Codestar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The only supported <code>SourceConnection</code> type is Codestar.
     * @see SourceType
     */
    public final SourceType type() {
        return SourceType.fromValue(type);
    }

    /**
     * <p>
     * The only supported <code>SourceConnection</code> type is Codestar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The only supported <code>SourceConnection</code> type is Codestar.
     * @see SourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The connection details based on the connection <code>Type</code>.
     * </p>
     * 
     * @return The connection details based on the connection <code>Type</code>.
     */
    public final SourceConnectionParameters connectionParameters() {
        return connectionParameters;
    }

    /**
     * <p>
     * Provides details about the product's connection sync and contains the following sub-fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LastSyncTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastSyncStatus</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastSyncStatusMessage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastSuccessfulSyncTime</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastSuccessfulSyncProvisioningArtifactID</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Provides details about the product's connection sync and contains the following sub-fields. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LastSyncTime</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastSyncStatus</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastSyncStatusMessage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastSuccessfulSyncTime</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastSuccessfulSyncProvisioningArtifactID</code>
     *         </p>
     *         </li>
     */
    public final LastSync lastSync() {
        return lastSync;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(lastSync());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectionDetail)) {
            return false;
        }
        SourceConnectionDetail other = (SourceConnectionDetail) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(connectionParameters(), other.connectionParameters())
                && Objects.equals(lastSync(), other.lastSync());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConnectionDetail").add("Type", typeAsString())
                .add("ConnectionParameters", connectionParameters()).add("LastSync", lastSync()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ConnectionParameters":
            return Optional.ofNullable(clazz.cast(connectionParameters()));
        case "LastSync":
            return Optional.ofNullable(clazz.cast(lastSync()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ConnectionParameters", CONNECTION_PARAMETERS_FIELD);
        map.put("LastSync", LAST_SYNC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectionDetail, T> g) {
        return obj -> g.apply((SourceConnectionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConnectionDetail> {
        /**
         * <p>
         * The only supported <code>SourceConnection</code> type is Codestar.
         * </p>
         * 
         * @param type
         *        The only supported <code>SourceConnection</code> type is Codestar.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The only supported <code>SourceConnection</code> type is Codestar.
         * </p>
         * 
         * @param type
         *        The only supported <code>SourceConnection</code> type is Codestar.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder type(SourceType type);

        /**
         * <p>
         * The connection details based on the connection <code>Type</code>.
         * </p>
         * 
         * @param connectionParameters
         *        The connection details based on the connection <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionParameters(SourceConnectionParameters connectionParameters);

        /**
         * <p>
         * The connection details based on the connection <code>Type</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConnectionParameters.Builder}
         * avoiding the need to create one manually via {@link SourceConnectionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConnectionParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #connectionParameters(SourceConnectionParameters)}.
         * 
         * @param connectionParameters
         *        a consumer that will call methods on {@link SourceConnectionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionParameters(SourceConnectionParameters)
         */
        default Builder connectionParameters(Consumer<SourceConnectionParameters.Builder> connectionParameters) {
            return connectionParameters(SourceConnectionParameters.builder().applyMutation(connectionParameters).build());
        }

        /**
         * <p>
         * Provides details about the product's connection sync and contains the following sub-fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LastSyncTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSyncStatus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSyncStatusMessage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSuccessfulSyncTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSuccessfulSyncProvisioningArtifactID</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastSync
         *        Provides details about the product's connection sync and contains the following sub-fields. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LastSyncTime</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastSyncStatus</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastSyncStatusMessage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastSuccessfulSyncTime</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastSuccessfulSyncProvisioningArtifactID</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSync(LastSync lastSync);

        /**
         * <p>
         * Provides details about the product's connection sync and contains the following sub-fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LastSyncTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSyncStatus</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSyncStatusMessage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSuccessfulSyncTime</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastSuccessfulSyncProvisioningArtifactID</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link LastSync.Builder} avoiding the need to
         * create one manually via {@link LastSync#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastSync.Builder#build()} is called immediately and its result is
         * passed to {@link #lastSync(LastSync)}.
         * 
         * @param lastSync
         *        a consumer that will call methods on {@link LastSync.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastSync(LastSync)
         */
        default Builder lastSync(Consumer<LastSync.Builder> lastSync) {
            return lastSync(LastSync.builder().applyMutation(lastSync).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private SourceConnectionParameters connectionParameters;

        private LastSync lastSync;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectionDetail model) {
            type(model.type);
            connectionParameters(model.connectionParameters);
            lastSync(model.lastSync);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final SourceConnectionParameters.Builder getConnectionParameters() {
            return connectionParameters != null ? connectionParameters.toBuilder() : null;
        }

        public final void setConnectionParameters(SourceConnectionParameters.BuilderImpl connectionParameters) {
            this.connectionParameters = connectionParameters != null ? connectionParameters.build() : null;
        }

        @Override
        public final Builder connectionParameters(SourceConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
            return this;
        }

        public final LastSync.Builder getLastSync() {
            return lastSync != null ? lastSync.toBuilder() : null;
        }

        public final void setLastSync(LastSync.BuilderImpl lastSync) {
            this.lastSync = lastSync != null ? lastSync.build() : null;
        }

        @Override
        public final Builder lastSync(LastSync lastSync) {
            this.lastSync = lastSync;
            return this;
        }

        @Override
        public SourceConnectionDetail build() {
            return new SourceConnectionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
