/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePortfolioRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdatePortfolioRequest.Builder, UpdatePortfolioRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(UpdatePortfolioRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdatePortfolioRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdatePortfolioRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdatePortfolioRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderName").getter(getter(UpdatePortfolioRequest::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()).build();

    private static final SdkField<List<Tag>> ADD_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("AddTags")
            .getter(getter(UpdatePortfolioRequest::addTags))
            .setter(setter(Builder::addTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveTags")
            .getter(getter(UpdatePortfolioRequest::removeTags))
            .setter(setter(Builder::removeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_NAME_FIELD, ADD_TAGS_FIELD, REMOVE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String acceptLanguage;

    private final String id;

    private final String displayName;

    private final String description;

    private final String providerName;

    private final List<Tag> addTags;

    private final List<String> removeTags;

    private UpdatePortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.providerName = builder.providerName;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The portfolio identifier.
     * </p>
     * 
     * @return The portfolio identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name to use for display purposes.
     * </p>
     * 
     * @return The name to use for display purposes.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The updated description of the portfolio.
     * </p>
     * 
     * @return The updated description of the portfolio.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated name of the portfolio provider.
     * </p>
     * 
     * @return The updated name of the portfolio provider.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddTags() {
        return addTags != null && !(addTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddTags} method.
     * </p>
     * 
     * @return The tags to add.
     */
    public final List<Tag> addTags() {
        return addTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRemoveTags() {
        return removeTags != null && !(removeTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveTags} method.
     * </p>
     * 
     * @return The tags to remove.
     */
    public final List<String> removeTags() {
        return removeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddTags() ? addTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveTags() ? removeTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortfolioRequest)) {
            return false;
        }
        UpdatePortfolioRequest other = (UpdatePortfolioRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(id(), other.id())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(providerName(), other.providerName()) && hasAddTags() == other.hasAddTags()
                && Objects.equals(addTags(), other.addTags()) && hasRemoveTags() == other.hasRemoveTags()
                && Objects.equals(removeTags(), other.removeTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePortfolioRequest").add("AcceptLanguage", acceptLanguage()).add("Id", id())
                .add("DisplayName", displayName()).add("Description", description()).add("ProviderName", providerName())
                .add("AddTags", hasAddTags() ? addTags() : null).add("RemoveTags", hasRemoveTags() ? removeTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "AddTags":
            return Optional.ofNullable(clazz.cast(addTags()));
        case "RemoveTags":
            return Optional.ofNullable(clazz.cast(removeTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("AddTags", ADD_TAGS_FIELD);
        map.put("RemoveTags", REMOVE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortfolioRequest, T> g) {
        return obj -> g.apply((UpdatePortfolioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePortfolioRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The portfolio identifier.
         * </p>
         * 
         * @param id
         *        The portfolio identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name to use for display purposes.
         * </p>
         * 
         * @param displayName
         *        The name to use for display purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The updated description of the portfolio.
         * </p>
         * 
         * @param description
         *        The updated description of the portfolio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated name of the portfolio provider.
         * </p>
         * 
         * @param providerName
         *        The updated name of the portfolio provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The tags to add.
         * </p>
         * 
         * @param addTags
         *        The tags to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Collection<Tag> addTags);

        /**
         * <p>
         * The tags to add.
         * </p>
         * 
         * @param addTags
         *        The tags to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Tag... addTags);

        /**
         * <p>
         * The tags to add.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.servicecatalog.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #addTags(List<Tag>)}.
         * 
         * @param addTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalog.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addTags(java.util.Collection<Tag>)
         */
        Builder addTags(Consumer<Tag.Builder>... addTags);

        /**
         * <p>
         * The tags to remove.
         * </p>
         * 
         * @param removeTags
         *        The tags to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTags(Collection<String> removeTags);

        /**
         * <p>
         * The tags to remove.
         * </p>
         * 
         * @param removeTags
         *        The tags to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTags(String... removeTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String id;

        private String displayName;

        private String description;

        private String providerName;

        private List<Tag> addTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortfolioRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            id(model.id);
            displayName(model.displayName);
            description(model.description);
            providerName(model.providerName);
            addTags(model.addTags);
            removeTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final List<Tag.Builder> getAddTags() {
            List<Tag.Builder> result = AddTagsCopier.copyToBuilder(this.addTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Consumer<Tag.Builder>... addTags) {
            addTags(Stream.of(addTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRemoveTags() {
            if (removeTags instanceof SdkAutoConstructList) {
                return null;
            }
            return removeTags;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String... removeTags) {
            removeTags(Arrays.asList(removeTags));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortfolioRequest build() {
            return new UpdatePortfolioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
