/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the resource group integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceGroup implements SdkPojo, Serializable, ToCopyableBuilder<ResourceGroup.Builder, ResourceGroup> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ResourceGroup::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(ResourceGroup::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, ARN_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String arn;

    private final String errorMessage;

    private ResourceGroup(BuilderImpl builder) {
        this.state = builder.state;
        this.arn = builder.arn;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The state of the propagation process for the resource group. The states includes:
     * </p>
     * <p>
     * <code>CREATING </code>if the resource group is in the process of being created.
     * </p>
     * <p>
     * <code>CREATE_COMPLETE</code> if the resource group was created successfully.
     * </p>
     * <p>
     * <code>CREATE_FAILED</code> if the resource group failed to be created.
     * </p>
     * <p>
     * <code>UPDATING</code> if the resource group is in the process of being updated.
     * </p>
     * <p>
     * <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
     * </p>
     * <p>
     * <code>UPDATE_FAILED</code> if the resource group could not update successfully.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ResourceGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the propagation process for the resource group. The states includes:</p>
     *         <p>
     *         <code>CREATING </code>if the resource group is in the process of being created.
     *         </p>
     *         <p>
     *         <code>CREATE_COMPLETE</code> if the resource group was created successfully.
     *         </p>
     *         <p>
     *         <code>CREATE_FAILED</code> if the resource group failed to be created.
     *         </p>
     *         <p>
     *         <code>UPDATING</code> if the resource group is in the process of being updated.
     *         </p>
     *         <p>
     *         <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
     *         </p>
     *         <p>
     *         <code>UPDATE_FAILED</code> if the resource group could not update successfully.
     * @see ResourceGroupState
     */
    public final ResourceGroupState state() {
        return ResourceGroupState.fromValue(state);
    }

    /**
     * <p>
     * The state of the propagation process for the resource group. The states includes:
     * </p>
     * <p>
     * <code>CREATING </code>if the resource group is in the process of being created.
     * </p>
     * <p>
     * <code>CREATE_COMPLETE</code> if the resource group was created successfully.
     * </p>
     * <p>
     * <code>CREATE_FAILED</code> if the resource group failed to be created.
     * </p>
     * <p>
     * <code>UPDATING</code> if the resource group is in the process of being updated.
     * </p>
     * <p>
     * <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
     * </p>
     * <p>
     * <code>UPDATE_FAILED</code> if the resource group could not update successfully.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ResourceGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the propagation process for the resource group. The states includes:</p>
     *         <p>
     *         <code>CREATING </code>if the resource group is in the process of being created.
     *         </p>
     *         <p>
     *         <code>CREATE_COMPLETE</code> if the resource group was created successfully.
     *         </p>
     *         <p>
     *         <code>CREATE_FAILED</code> if the resource group failed to be created.
     *         </p>
     *         <p>
     *         <code>UPDATING</code> if the resource group is in the process of being updated.
     *         </p>
     *         <p>
     *         <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
     *         </p>
     *         <p>
     *         <code>UPDATE_FAILED</code> if the resource group could not update successfully.
     * @see ResourceGroupState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the resource group.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the resource group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The error message that generates when the propagation process for the resource group fails.
     * </p>
     * 
     * @return The error message that generates when the propagation process for the resource group fails.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceGroup)) {
            return false;
        }
        ResourceGroup other = (ResourceGroup) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceGroup").add("State", stateAsString()).add("Arn", arn())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceGroup, T> g) {
        return obj -> g.apply((ResourceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceGroup> {
        /**
         * <p>
         * The state of the propagation process for the resource group. The states includes:
         * </p>
         * <p>
         * <code>CREATING </code>if the resource group is in the process of being created.
         * </p>
         * <p>
         * <code>CREATE_COMPLETE</code> if the resource group was created successfully.
         * </p>
         * <p>
         * <code>CREATE_FAILED</code> if the resource group failed to be created.
         * </p>
         * <p>
         * <code>UPDATING</code> if the resource group is in the process of being updated.
         * </p>
         * <p>
         * <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
         * </p>
         * <p>
         * <code>UPDATE_FAILED</code> if the resource group could not update successfully.
         * </p>
         * 
         * @param state
         *        The state of the propagation process for the resource group. The states includes:</p>
         *        <p>
         *        <code>CREATING </code>if the resource group is in the process of being created.
         *        </p>
         *        <p>
         *        <code>CREATE_COMPLETE</code> if the resource group was created successfully.
         *        </p>
         *        <p>
         *        <code>CREATE_FAILED</code> if the resource group failed to be created.
         *        </p>
         *        <p>
         *        <code>UPDATING</code> if the resource group is in the process of being updated.
         *        </p>
         *        <p>
         *        <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
         *        </p>
         *        <p>
         *        <code>UPDATE_FAILED</code> if the resource group could not update successfully.
         * @see ResourceGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the propagation process for the resource group. The states includes:
         * </p>
         * <p>
         * <code>CREATING </code>if the resource group is in the process of being created.
         * </p>
         * <p>
         * <code>CREATE_COMPLETE</code> if the resource group was created successfully.
         * </p>
         * <p>
         * <code>CREATE_FAILED</code> if the resource group failed to be created.
         * </p>
         * <p>
         * <code>UPDATING</code> if the resource group is in the process of being updated.
         * </p>
         * <p>
         * <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
         * </p>
         * <p>
         * <code>UPDATE_FAILED</code> if the resource group could not update successfully.
         * </p>
         * 
         * @param state
         *        The state of the propagation process for the resource group. The states includes:</p>
         *        <p>
         *        <code>CREATING </code>if the resource group is in the process of being created.
         *        </p>
         *        <p>
         *        <code>CREATE_COMPLETE</code> if the resource group was created successfully.
         *        </p>
         *        <p>
         *        <code>CREATE_FAILED</code> if the resource group failed to be created.
         *        </p>
         *        <p>
         *        <code>UPDATING</code> if the resource group is in the process of being updated.
         *        </p>
         *        <p>
         *        <code>UPDATE_COMPLETE</code> if the resource group updated successfully.
         *        </p>
         *        <p>
         *        <code>UPDATE_FAILED</code> if the resource group could not update successfully.
         * @see ResourceGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceGroupState
         */
        Builder state(ResourceGroupState state);

        /**
         * <p>
         * The Amazon resource name (ARN) of the resource group.
         * </p>
         * 
         * @param arn
         *        The Amazon resource name (ARN) of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The error message that generates when the propagation process for the resource group fails.
         * </p>
         * 
         * @param errorMessage
         *        The error message that generates when the propagation process for the resource group fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String arn;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceGroup model) {
            state(model.state);
            arn(model.arn);
            errorMessage(model.errorMessage);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ResourceGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        @Transient
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public ResourceGroup build() {
            return new ResourceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
