/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service integration information about the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIntegrations implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceIntegrations.Builder, ResourceIntegrations> {
    private static final SdkField<ResourceGroup> RESOURCE_GROUP_FIELD = SdkField
            .<ResourceGroup> builder(MarshallingType.SDK_POJO).memberName("resourceGroup")
            .getter(getter(ResourceIntegrations::resourceGroup)).setter(setter(Builder::resourceGroup))
            .constructor(ResourceGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceGroup resourceGroup;

    private ResourceIntegrations(BuilderImpl builder) {
        this.resourceGroup = builder.resourceGroup;
    }

    /**
     * <p>
     * The information about the integration of Resource Groups.
     * </p>
     * 
     * @return The information about the integration of Resource Groups.
     */
    public final ResourceGroup resourceGroup() {
        return resourceGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIntegrations)) {
            return false;
        }
        ResourceIntegrations other = (ResourceIntegrations) obj;
        return Objects.equals(resourceGroup(), other.resourceGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceIntegrations").add("ResourceGroup", resourceGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceGroup":
            return Optional.ofNullable(clazz.cast(resourceGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIntegrations, T> g) {
        return obj -> g.apply((ResourceIntegrations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceIntegrations> {
        /**
         * <p>
         * The information about the integration of Resource Groups.
         * </p>
         * 
         * @param resourceGroup
         *        The information about the integration of Resource Groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroup(ResourceGroup resourceGroup);

        /**
         * <p>
         * The information about the integration of Resource Groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceGroup.Builder} avoiding the need
         * to create one manually via {@link ResourceGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceGroup(ResourceGroup)}.
         * 
         * @param resourceGroup
         *        a consumer that will call methods on {@link ResourceGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceGroup(ResourceGroup)
         */
        default Builder resourceGroup(Consumer<ResourceGroup.Builder> resourceGroup) {
            return resourceGroup(ResourceGroup.builder().applyMutation(resourceGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceGroup resourceGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIntegrations model) {
            resourceGroup(model.resourceGroup);
        }

        public final ResourceGroup.Builder getResourceGroup() {
            return resourceGroup != null ? resourceGroup.toBuilder() : null;
        }

        public final void setResourceGroup(ResourceGroup.BuilderImpl resourceGroup) {
            this.resourceGroup = resourceGroup != null ? resourceGroup.build() : null;
        }

        @Override
        public final Builder resourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        @Override
        public ResourceIntegrations build() {
            return new ResourceIntegrations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
