/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Resource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Resource::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("associationTime")
            .getter(getter(Resource::associationTime))
            .setter(setter(Builder::associationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ResourceIntegrations> INTEGRATIONS_FIELD = SdkField
            .<ResourceIntegrations> builder(MarshallingType.SDK_POJO).memberName("integrations")
            .getter(getter(Resource::integrations)).setter(setter(Builder::integrations))
            .constructor(ResourceIntegrations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            ASSOCIATION_TIME_FIELD, INTEGRATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final Instant associationTime;

    private final ResourceIntegrations integrations;

    private Resource(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.associationTime = builder.associationTime;
        this.integrations = builder.integrations;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time the resource was associated with the application.
     * </p>
     * 
     * @return The time the resource was associated with the application.
     */
    public final Instant associationTime() {
        return associationTime;
    }

    /**
     * <p>
     * The service integration information about the resource.
     * </p>
     * 
     * @return The service integration information about the resource.
     */
    public final ResourceIntegrations integrations() {
        return integrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(associationTime());
        hashCode = 31 * hashCode + Objects.hashCode(integrations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(associationTime(), other.associationTime())
                && Objects.equals(integrations(), other.integrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("Name", name()).add("Arn", arn()).add("AssociationTime", associationTime())
                .add("Integrations", integrations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "associationTime":
            return Optional.ofNullable(clazz.cast(associationTime()));
        case "integrations":
            return Optional.ofNullable(clazz.cast(integrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon resource name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon resource name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time the resource was associated with the application.
         * </p>
         * 
         * @param associationTime
         *        The time the resource was associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTime(Instant associationTime);

        /**
         * <p>
         * The service integration information about the resource.
         * </p>
         * 
         * @param integrations
         *        The service integration information about the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(ResourceIntegrations integrations);

        /**
         * <p>
         * The service integration information about the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceIntegrations.Builder} avoiding the need
         * to create one manually via {@link ResourceIntegrations#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceIntegrations.Builder#build()} is called immediately and
         * its result is passed to {@link #integrations(ResourceIntegrations)}.
         * 
         * @param integrations
         *        a consumer that will call methods on {@link ResourceIntegrations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrations(ResourceIntegrations)
         */
        default Builder integrations(Consumer<ResourceIntegrations.Builder> integrations) {
            return integrations(ResourceIntegrations.builder().applyMutation(integrations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private Instant associationTime;

        private ResourceIntegrations integrations;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            name(model.name);
            arn(model.arn);
            associationTime(model.associationTime);
            integrations(model.integrations);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getAssociationTime() {
            return associationTime;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        @Override
        @Transient
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final ResourceIntegrations.Builder getIntegrations() {
            return integrations != null ? integrations.toBuilder() : null;
        }

        public final void setIntegrations(ResourceIntegrations.BuilderImpl integrations) {
            this.integrations = integrations != null ? integrations.build() : null;
        }

        @Override
        @Transient
        public final Builder integrations(ResourceIntegrations integrations) {
            this.integrations = integrations;
            return this;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
