/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AttributeGroupDetailsListCopier {
    static List<AttributeGroupDetails> copy(Collection<? extends AttributeGroupDetails> attributeGroupDetailsListParam) {
        List<AttributeGroupDetails> list;
        if (attributeGroupDetailsListParam == null || attributeGroupDetailsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AttributeGroupDetails> modifiableList = new ArrayList<>();
            attributeGroupDetailsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AttributeGroupDetails> copyFromBuilder(
            Collection<? extends AttributeGroupDetails.Builder> attributeGroupDetailsListParam) {
        List<AttributeGroupDetails> list;
        if (attributeGroupDetailsListParam == null || attributeGroupDetailsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AttributeGroupDetails> modifiableList = new ArrayList<>();
            attributeGroupDetailsListParam.forEach(entry -> {
                AttributeGroupDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AttributeGroupDetails.Builder> copyToBuilder(
            Collection<? extends AttributeGroupDetails> attributeGroupDetailsListParam) {
        List<AttributeGroupDetails.Builder> list;
        if (attributeGroupDetailsListParam == null || attributeGroupDetailsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AttributeGroupDetails.Builder> modifiableList = new ArrayList<>();
            attributeGroupDetailsListParam.forEach(entry -> {
                AttributeGroupDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
