/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetConfigurationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetConfigurationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.PutConfigurationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.PutConfigurationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsPublisher;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesPublisher;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationPublisher;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsPublisher;

/**
 * Service client for accessing AppRegistry asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Web Services Service Catalog AppRegistry enables organizations to understand the application context of their
 * Amazon Web Services resources. AppRegistry provides a repository of your applications, their resources, and the
 * application metadata that you use within your enterprise.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServiceCatalogAppRegistryAsyncClient extends AwsClient {
    String SERVICE_NAME = "servicecatalog";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "servicecatalog-appregistry";

    /**
     * <p>
     * Associates an attribute group with an application to augment the application's metadata with the group's
     * attributes. This feature enables applications to be described with user-defined details that are
     * machine-readable, such as third-party integrations.
     * </p>
     *
     * @param associateAttributeGroupRequest
     * @return A Java Future containing the result of the AssociateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.AssociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAttributeGroupResponse> associateAttributeGroup(
            AssociateAttributeGroupRequest associateAttributeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an attribute group with an application to augment the application's metadata with the group's
     * attributes. This feature enables applications to be described with user-defined details that are
     * machine-readable, such as third-party integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAttributeGroupRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param associateAttributeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.AssociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateAttributeGroupResponse> associateAttributeGroup(
            Consumer<AssociateAttributeGroupRequest.Builder> associateAttributeGroupRequest) {
        return associateAttributeGroup(AssociateAttributeGroupRequest.builder().applyMutation(associateAttributeGroupRequest)
                .build());
    }

    /**
     * <p>
     * Associates a resource with an application. The resource can be specified by its ARN or name. The application can
     * be specified by ARN, ID, or name.
     * </p>
     *
     * @param associateResourceRequest
     * @return A Java Future containing the result of the AssociateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.AssociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResourceResponse> associateResource(AssociateResourceRequest associateResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a resource with an application. The resource can be specified by its ARN or name. The application can
     * be specified by ARN, ID, or name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateResourceRequest#builder()}
     * </p>
     *
     * @param associateResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.AssociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateResourceResponse> associateResource(
            Consumer<AssociateResourceRequest.Builder> associateResourceRequest) {
        return associateResource(AssociateResourceRequest.builder().applyMutation(associateResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full
     * control over their cloud application's metadata in a rich machine-readable format to facilitate integration with
     * automated workflows and third-party tools.
     * </p>
     *
     * @param createAttributeGroupRequest
     * @return A Java Future containing the result of the CreateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.CreateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAttributeGroupResponse> createAttributeGroup(
            CreateAttributeGroupRequest createAttributeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full
     * control over their cloud application's metadata in a rich machine-readable format to facilitate integration with
     * automated workflows and third-party tools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAttributeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param createAttributeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException The maximum number of resources per account has been reached.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.CreateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAttributeGroupResponse> createAttributeGroup(
            Consumer<CreateAttributeGroupRequest.Builder> createAttributeGroupRequest) {
        return createAttributeGroup(CreateAttributeGroupRequest.builder().applyMutation(createAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute
     * groups and resources must be disassociated from it before deleting an application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute
     * groups and resources must be disassociated from it before deleting an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
     * </p>
     *
     * @param deleteAttributeGroupRequest
     * @return A Java Future containing the result of the DeleteAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DeleteAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAttributeGroupResponse> deleteAttributeGroup(
            DeleteAttributeGroupRequest deleteAttributeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttributeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAttributeGroupRequest#builder()}
     * </p>
     *
     * @param deleteAttributeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DeleteAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAttributeGroupResponse> deleteAttributeGroup(
            Consumer<DeleteAttributeGroupRequest.Builder> deleteAttributeGroupRequest) {
        return deleteAttributeGroup(DeleteAttributeGroupRequest.builder().applyMutation(deleteAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates an attribute group from an application to remove the extra attributes contained in the attribute
     * group from the application's metadata. This operation reverts <code>AssociateAttributeGroup</code>.
     * </p>
     *
     * @param disassociateAttributeGroupRequest
     * @return A Java Future containing the result of the DisassociateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DisassociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAttributeGroupResponse> disassociateAttributeGroup(
            DisassociateAttributeGroupRequest disassociateAttributeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an attribute group from an application to remove the extra attributes contained in the attribute
     * group from the application's metadata. This operation reverts <code>AssociateAttributeGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAttributeGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param disassociateAttributeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DisassociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateAttributeGroupResponse> disassociateAttributeGroup(
            Consumer<DisassociateAttributeGroupRequest.Builder> disassociateAttributeGroupRequest) {
        return disassociateAttributeGroup(DisassociateAttributeGroupRequest.builder()
                .applyMutation(disassociateAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates a resource from application. Both the resource and the application can be specified either by ID or
     * name.
     * </p>
     *
     * @param disassociateResourceRequest
     * @return A Java Future containing the result of the DisassociateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DisassociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceResponse> disassociateResource(
            DisassociateResourceRequest disassociateResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a resource from application. Both the resource and the application can be specified either by ID or
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateResourceRequest#builder()}
     * </p>
     *
     * @param disassociateResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.DisassociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateResourceResponse> disassociateResource(
            Consumer<DisassociateResourceRequest.Builder> disassociateResourceRequest) {
        return disassociateResource(DisassociateResourceRequest.builder().applyMutation(disassociateResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID,
     * or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in
     * automated workflows if you want to make sure that the exact same application is returned or a
     * <code>ResourceNotFoundException</code> is thrown, avoiding the ABA addressing problem.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID,
     * or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in
     * automated workflows if you want to make sure that the exact same application is returned or a
     * <code>ResourceNotFoundException</code> is thrown, avoiding the ABA addressing problem.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets the resource associated with the application.
     * </p>
     *
     * @param getAssociatedResourceRequest
     * @return A Java Future containing the result of the GetAssociatedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetAssociatedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAssociatedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssociatedResourceResponse> getAssociatedResource(
            GetAssociatedResourceRequest getAssociatedResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the resource associated with the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssociatedResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssociatedResourceRequest#builder()}
     * </p>
     *
     * @param getAssociatedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAssociatedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetAssociatedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAssociatedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssociatedResourceResponse> getAssociatedResource(
            Consumer<GetAssociatedResourceRequest.Builder> getAssociatedResourceRequest) {
        return getAssociatedResource(GetAssociatedResourceRequest.builder().applyMutation(getAssociatedResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or
     * name.
     * </p>
     *
     * @param getAttributeGroupRequest
     * @return A Java Future containing the result of the GetAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAttributeGroupResponse> getAttributeGroup(GetAttributeGroupRequest getAttributeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttributeGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetAttributeGroupRequest#builder()}
     * </p>
     *
     * @param getAttributeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAttributeGroupResponse> getAttributeGroup(
            Consumer<GetAttributeGroupRequest.Builder> getAttributeGroupRequest) {
        return getAttributeGroup(GetAttributeGroupRequest.builder().applyMutation(getAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves a <code>TagKey</code> configuration from an account.
     * </p>
     *
     * @param getConfigurationRequest
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationResponse> getConfiguration(GetConfigurationRequest getConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>TagKey</code> configuration from an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.GetConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationResponse> getConfiguration(
            Consumer<GetConfigurationRequest.Builder> getConfigurationRequest) {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     * @return A Java Future containing the result of the ListAssociatedAttributeGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedAttributeGroupsResponse> listAssociatedAttributeGroups(
            ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAttributeGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssociatedAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAssociatedAttributeGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedAttributeGroupsResponse> listAssociatedAttributeGroups(
            Consumer<ListAssociatedAttributeGroupsRequest.Builder> listAssociatedAttributeGroupsRequest) {
        return listAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest.builder()
                .applyMutation(listAssociatedAttributeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsPublisher publisher = client.listAssociatedAttributeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsPublisher publisher = client.listAssociatedAttributeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAttributeGroupsPublisher listAssociatedAttributeGroupsPaginator(
            ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) {
        return new ListAssociatedAttributeGroupsPublisher(this, listAssociatedAttributeGroupsRequest);
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsPublisher publisher = client.listAssociatedAttributeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsPublisher publisher = client.listAssociatedAttributeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAttributeGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssociatedAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAttributeGroupsPublisher listAssociatedAttributeGroupsPaginator(
            Consumer<ListAssociatedAttributeGroupsRequest.Builder> listAssociatedAttributeGroupsRequest) {
        return listAssociatedAttributeGroupsPaginator(ListAssociatedAttributeGroupsRequest.builder()
                .applyMutation(listAssociatedAttributeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note>
     *
     * @param listAssociatedResourcesRequest
     * @return A Java Future containing the result of the ListAssociatedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedResourcesResponse> listAssociatedResources(
            ListAssociatedResourcesRequest listAssociatedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociatedResourcesRequest#builder()}
     * </p>
     *
     * @param listAssociatedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAssociatedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedResourcesResponse> listAssociatedResources(
            Consumer<ListAssociatedResourcesRequest.Builder> listAssociatedResourcesRequest) {
        return listAssociatedResources(ListAssociatedResourcesRequest.builder().applyMutation(listAssociatedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesPublisher publisher = client.listAssociatedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesPublisher publisher = client.listAssociatedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedResourcesPublisher listAssociatedResourcesPaginator(
            ListAssociatedResourcesRequest listAssociatedResourcesRequest) {
        return new ListAssociatedResourcesPublisher(this, listAssociatedResourcesRequest);
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesPublisher publisher = client.listAssociatedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesPublisher publisher = client.listAssociatedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociatedResourcesRequest#builder()}
     * </p>
     *
     * @param listAssociatedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedResourcesPublisher listAssociatedResourcesPaginator(
            Consumer<ListAssociatedResourcesRequest.Builder> listAssociatedResourcesRequest) {
        return listAssociatedResourcesPaginator(ListAssociatedResourcesRequest.builder()
                .applyMutation(listAssociatedResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     *
     * @param listAttributeGroupsRequest
     * @return A Java Future containing the result of the ListAttributeGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttributeGroupsResponse> listAttributeGroups(
            ListAttributeGroupsRequest listAttributeGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAttributeGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttributeGroupsResponse> listAttributeGroups(
            Consumer<ListAttributeGroupsRequest.Builder> listAttributeGroupsRequest) {
        return listAttributeGroups(ListAttributeGroupsRequest.builder().applyMutation(listAttributeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     * @return A Java Future containing the result of the ListAttributeGroupsForApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttributeGroupsForApplicationResponse> listAttributeGroupsForApplication(
            ListAttributeGroupsForApplicationRequest listAttributeGroupsForApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsForApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListAttributeGroupsForApplicationRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAttributeGroupsForApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAttributeGroupsForApplicationResponse> listAttributeGroupsForApplication(
            Consumer<ListAttributeGroupsForApplicationRequest.Builder> listAttributeGroupsForApplicationRequest) {
        return listAttributeGroupsForApplication(ListAttributeGroupsForApplicationRequest.builder()
                .applyMutation(listAttributeGroupsForApplicationRequest).build());
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationPublisher publisher = client.listAttributeGroupsForApplicationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationPublisher publisher = client.listAttributeGroupsForApplicationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsForApplicationPublisher listAttributeGroupsForApplicationPaginator(
            ListAttributeGroupsForApplicationRequest listAttributeGroupsForApplicationRequest) {
        return new ListAttributeGroupsForApplicationPublisher(this, listAttributeGroupsForApplicationRequest);
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationPublisher publisher = client.listAttributeGroupsForApplicationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationPublisher publisher = client.listAttributeGroupsForApplicationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsForApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListAttributeGroupsForApplicationRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsForApplicationPublisher listAttributeGroupsForApplicationPaginator(
            Consumer<ListAttributeGroupsForApplicationRequest.Builder> listAttributeGroupsForApplicationRequest) {
        return listAttributeGroupsForApplicationPaginator(ListAttributeGroupsForApplicationRequest.builder()
                .applyMutation(listAttributeGroupsForApplicationRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsPublisher publisher = client.listAttributeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsPublisher publisher = client.listAttributeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttributeGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsPublisher listAttributeGroupsPaginator(ListAttributeGroupsRequest listAttributeGroupsRequest) {
        return new ListAttributeGroupsPublisher(this, listAttributeGroupsRequest);
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsPublisher publisher = client.listAttributeGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsPublisher publisher = client.listAttributeGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsPublisher listAttributeGroupsPaginator(
            Consumer<ListAttributeGroupsRequest.Builder> listAttributeGroupsRequest) {
        return listAttributeGroupsPaginator(ListAttributeGroupsRequest.builder().applyMutation(listAttributeGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the tags on the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags on the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     *
     * @param putConfigurationRequest
     * @return A Java Future containing the result of the PutConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.PutConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/PutConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationResponse> putConfiguration(PutConfigurationRequest putConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link PutConfigurationRequest#builder()}
     * </p>
     *
     * @param putConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.PutConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.PutConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/PutConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationResponse> putConfiguration(
            Consumer<PutConfigurationRequest.Builder> putConfigurationRequest) {
        return putConfiguration(PutConfigurationRequest.builder().applyMutation(putConfigurationRequest).build());
    }

    /**
     * <p>
     * Syncs the resource with current AppRegistry records.
     * </p>
     * <p>
     * Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the
     * resource's AppRegistry system tags if it does not associate with the application. The caller must have
     * permissions to read and update the resource.
     * </p>
     *
     * @param syncResourceRequest
     * @return A Java Future containing the result of the SyncResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.SyncResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/SyncResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SyncResourceResponse> syncResource(SyncResourceRequest syncResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Syncs the resource with current AppRegistry records.
     * </p>
     * <p>
     * Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the
     * resource's AppRegistry system tags if it does not associate with the application. The caller must have
     * permissions to read and update the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SyncResourceRequest.Builder} avoiding the need to
     * create one manually via {@link SyncResourceRequest#builder()}
     * </p>
     *
     * @param syncResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SyncResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.SyncResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/SyncResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SyncResourceResponse> syncResource(Consumer<SyncResourceRequest.Builder> syncResourceRequest) {
        return syncResource(SyncResourceRequest.builder().applyMutation(syncResourceRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing application with new attributes.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing application with new attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>ThrottlingException The maximum number of API requests has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates an existing attribute group with new details.
     * </p>
     *
     * @param updateAttributeGroupRequest
     * @return A Java Future containing the result of the UpdateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.UpdateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAttributeGroupResponse> updateAttributeGroup(
            UpdateAttributeGroupRequest updateAttributeGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing attribute group with new details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAttributeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param updateAttributeGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateAttributeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ValidationException The request has invalid or missing parameters.</li>
     *         <li>ConflictException There was a conflict when processing the request (for example, a resource with the
     *         given name already exists within the account).</li>
     *         <li>InternalServerException The service is experiencing internal problems.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogAppRegistryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAppRegistryAsyncClient.UpdateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAttributeGroupResponse> updateAttributeGroup(
            Consumer<UpdateAttributeGroupRequest.Builder> updateAttributeGroupRequest) {
        return updateAttributeGroup(UpdateAttributeGroupRequest.builder().applyMutation(updateAttributeGroupRequest).build());
    }

    @Override
    default ServiceCatalogAppRegistryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ServiceCatalogAppRegistryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceCatalogAppRegistryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceCatalogAppRegistryAsyncClient}.
     */
    static ServiceCatalogAppRegistryAsyncClientBuilder builder() {
        return new DefaultServiceCatalogAppRegistryAsyncClientBuilder();
    }
}
