/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AttributeGroupIdsCopier;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedAttributeGroupsResponse
extends ServiceCatalogAppRegistryResponse
implements ToCopyableBuilder<Builder, ListAssociatedAttributeGroupsResponse> {
    private static final SdkField<List<String>> ATTRIBUTE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeGroups").getter(ListAssociatedAttributeGroupsResponse.getter(ListAssociatedAttributeGroupsResponse::attributeGroups)).setter(ListAssociatedAttributeGroupsResponse.setter(Builder::attributeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedAttributeGroupsResponse.getter(ListAssociatedAttributeGroupsResponse::nextToken)).setter(ListAssociatedAttributeGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> attributeGroups;
    private final String nextToken;

    private ListAssociatedAttributeGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.attributeGroups = builder.attributeGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAttributeGroups() {
        return this.attributeGroups != null && !(this.attributeGroups instanceof SdkAutoConstructList);
    }

    public final List<String> attributeGroups() {
        return this.attributeGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeGroups() ? this.attributeGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedAttributeGroupsResponse)) {
            return false;
        }
        ListAssociatedAttributeGroupsResponse other = (ListAssociatedAttributeGroupsResponse)((Object)obj);
        return this.hasAttributeGroups() == other.hasAttributeGroups() && Objects.equals(this.attributeGroups(), other.attributeGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedAttributeGroupsResponse").add("AttributeGroups", this.hasAttributeGroups() ? this.attributeGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributeGroups": {
                return Optional.ofNullable(clazz.cast(this.attributeGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedAttributeGroupsResponse, T> g) {
        return obj -> g.apply((ListAssociatedAttributeGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryResponse.BuilderImpl
    implements Builder {
        private List<String> attributeGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedAttributeGroupsResponse model) {
            super(model);
            this.attributeGroups(model.attributeGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAttributeGroups() {
            if (this.attributeGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeGroups;
        }

        public final void setAttributeGroups(Collection<String> attributeGroups) {
            this.attributeGroups = AttributeGroupIdsCopier.copy(attributeGroups);
        }

        @Override
        public final Builder attributeGroups(Collection<String> attributeGroups) {
            this.attributeGroups = AttributeGroupIdsCopier.copy(attributeGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeGroups(String ... attributeGroups) {
            this.attributeGroups(Arrays.asList(attributeGroups));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedAttributeGroupsResponse build() {
            return new ListAssociatedAttributeGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogAppRegistryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedAttributeGroupsResponse> {
        public Builder attributeGroups(Collection<String> var1);

        public Builder attributeGroups(String ... var1);

        public Builder nextToken(String var1);
    }
}

