/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes all of the AppRegistry settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppRegistryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppRegistryConfiguration.Builder, AppRegistryConfiguration> {
    private static final SdkField<TagQueryConfiguration> TAG_QUERY_CONFIGURATION_FIELD = SdkField
            .<TagQueryConfiguration> builder(MarshallingType.SDK_POJO).memberName("tagQueryConfiguration")
            .getter(getter(AppRegistryConfiguration::tagQueryConfiguration)).setter(setter(Builder::tagQueryConfiguration))
            .constructor(TagQueryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagQueryConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TAG_QUERY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TagQueryConfiguration tagQueryConfiguration;

    private AppRegistryConfiguration(BuilderImpl builder) {
        this.tagQueryConfiguration = builder.tagQueryConfiguration;
    }

    /**
     * <p>
     * Includes the definition of a <code>tagQuery</code>.
     * </p>
     * 
     * @return Includes the definition of a <code>tagQuery</code>.
     */
    public final TagQueryConfiguration tagQueryConfiguration() {
        return tagQueryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagQueryConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppRegistryConfiguration)) {
            return false;
        }
        AppRegistryConfiguration other = (AppRegistryConfiguration) obj;
        return Objects.equals(tagQueryConfiguration(), other.tagQueryConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppRegistryConfiguration").add("TagQueryConfiguration", tagQueryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tagQueryConfiguration":
            return Optional.ofNullable(clazz.cast(tagQueryConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tagQueryConfiguration", TAG_QUERY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppRegistryConfiguration, T> g) {
        return obj -> g.apply((AppRegistryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppRegistryConfiguration> {
        /**
         * <p>
         * Includes the definition of a <code>tagQuery</code>.
         * </p>
         * 
         * @param tagQueryConfiguration
         *        Includes the definition of a <code>tagQuery</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagQueryConfiguration(TagQueryConfiguration tagQueryConfiguration);

        /**
         * <p>
         * Includes the definition of a <code>tagQuery</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagQueryConfiguration.Builder} avoiding
         * the need to create one manually via {@link TagQueryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagQueryConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #tagQueryConfiguration(TagQueryConfiguration)}.
         * 
         * @param tagQueryConfiguration
         *        a consumer that will call methods on {@link TagQueryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagQueryConfiguration(TagQueryConfiguration)
         */
        default Builder tagQueryConfiguration(Consumer<TagQueryConfiguration.Builder> tagQueryConfiguration) {
            return tagQueryConfiguration(TagQueryConfiguration.builder().applyMutation(tagQueryConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TagQueryConfiguration tagQueryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AppRegistryConfiguration model) {
            tagQueryConfiguration(model.tagQueryConfiguration);
        }

        public final TagQueryConfiguration.Builder getTagQueryConfiguration() {
            return tagQueryConfiguration != null ? tagQueryConfiguration.toBuilder() : null;
        }

        public final void setTagQueryConfiguration(TagQueryConfiguration.BuilderImpl tagQueryConfiguration) {
            this.tagQueryConfiguration = tagQueryConfiguration != null ? tagQueryConfiguration.build() : null;
        }

        @Override
        public final Builder tagQueryConfiguration(TagQueryConfiguration tagQueryConfiguration) {
            this.tagQueryConfiguration = tagQueryConfiguration;
            return this;
        }

        @Override
        public AppRegistryConfiguration build() {
            return new AppRegistryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
