/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the application tag that's applied to a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationTagResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationTagResult.Builder, ApplicationTagResult> {
    private static final SdkField<String> APPLICATION_TAG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationTagStatus").getter(getter(ApplicationTagResult::applicationTagStatusAsString))
            .setter(setter(Builder::applicationTagStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationTagStatus").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(ApplicationTagResult::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<List<ResourcesListItem>> RESOURCES_FIELD = SdkField
            .<List<ResourcesListItem>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(ApplicationTagResult::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcesListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcesListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ApplicationTagResult::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_TAG_STATUS_FIELD,
            ERROR_MESSAGE_FIELD, RESOURCES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationTagStatus;

    private final String errorMessage;

    private final List<ResourcesListItem> resources;

    private final String nextToken;

    private ApplicationTagResult(BuilderImpl builder) {
        this.applicationTagStatus = builder.applicationTagStatus;
        this.errorMessage = builder.errorMessage;
        this.resources = builder.resources;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The application tag is in the process of being applied to a resource, was successfully applied to a resource, or
     * failed to apply to a resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationTagStatus} will return {@link ApplicationTagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationTagStatusAsString}.
     * </p>
     * 
     * @return The application tag is in the process of being applied to a resource, was successfully applied to a
     *         resource, or failed to apply to a resource.
     * @see ApplicationTagStatus
     */
    public final ApplicationTagStatus applicationTagStatus() {
        return ApplicationTagStatus.fromValue(applicationTagStatus);
    }

    /**
     * <p>
     * The application tag is in the process of being applied to a resource, was successfully applied to a resource, or
     * failed to apply to a resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #applicationTagStatus} will return {@link ApplicationTagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #applicationTagStatusAsString}.
     * </p>
     * 
     * @return The application tag is in the process of being applied to a resource, was successfully applied to a
     *         resource, or failed to apply to a resource.
     * @see ApplicationTagStatus
     */
    public final String applicationTagStatusAsString() {
        return applicationTagStatus;
    }

    /**
     * <p>
     * The message returned if the call fails.
     * </p>
     * 
     * @return The message returned if the call fails.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources associated with an application
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The resources associated with an application
     */
    public final List<ResourcesListItem> resources() {
        return resources;
    }

    /**
     * <p>
     * A unique pagination token for each page of results. Make the call again with the returned token to retrieve the
     * next page of results.
     * </p>
     * 
     * @return A unique pagination token for each page of results. Make the call again with the returned token to
     *         retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationTagStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationTagResult)) {
            return false;
        }
        ApplicationTagResult other = (ApplicationTagResult) obj;
        return Objects.equals(applicationTagStatusAsString(), other.applicationTagStatusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationTagResult").add("ApplicationTagStatus", applicationTagStatusAsString())
                .add("ErrorMessage", errorMessage()).add("Resources", hasResources() ? resources() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationTagStatus":
            return Optional.ofNullable(clazz.cast(applicationTagStatusAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationTagStatus", APPLICATION_TAG_STATUS_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationTagResult, T> g) {
        return obj -> g.apply((ApplicationTagResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationTagResult> {
        /**
         * <p>
         * The application tag is in the process of being applied to a resource, was successfully applied to a resource,
         * or failed to apply to a resource.
         * </p>
         * 
         * @param applicationTagStatus
         *        The application tag is in the process of being applied to a resource, was successfully applied to a
         *        resource, or failed to apply to a resource.
         * @see ApplicationTagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationTagStatus
         */
        Builder applicationTagStatus(String applicationTagStatus);

        /**
         * <p>
         * The application tag is in the process of being applied to a resource, was successfully applied to a resource,
         * or failed to apply to a resource.
         * </p>
         * 
         * @param applicationTagStatus
         *        The application tag is in the process of being applied to a resource, was successfully applied to a
         *        resource, or failed to apply to a resource.
         * @see ApplicationTagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationTagStatus
         */
        Builder applicationTagStatus(ApplicationTagStatus applicationTagStatus);

        /**
         * <p>
         * The message returned if the call fails.
         * </p>
         * 
         * @param errorMessage
         *        The message returned if the call fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The resources associated with an application
         * </p>
         * 
         * @param resources
         *        The resources associated with an application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<ResourcesListItem> resources);

        /**
         * <p>
         * The resources associated with an application
         * </p>
         * 
         * @param resources
         *        The resources associated with an application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(ResourcesListItem... resources);

        /**
         * <p>
         * The resources associated with an application
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ResourcesListItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ResourcesListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ResourcesListItem.Builder#build()} is
         * called immediately and its result is passed to {@link #resources(List<ResourcesListItem>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicecatalogappregistry.model.ResourcesListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<ResourcesListItem>)
         */
        Builder resources(Consumer<ResourcesListItem.Builder>... resources);

        /**
         * <p>
         * A unique pagination token for each page of results. Make the call again with the returned token to retrieve
         * the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token for each page of results. Make the call again with the returned token to
         *        retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private String applicationTagStatus;

        private String errorMessage;

        private List<ResourcesListItem> resources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationTagResult model) {
            applicationTagStatus(model.applicationTagStatus);
            errorMessage(model.errorMessage);
            resources(model.resources);
            nextToken(model.nextToken);
        }

        public final String getApplicationTagStatus() {
            return applicationTagStatus;
        }

        public final void setApplicationTagStatus(String applicationTagStatus) {
            this.applicationTagStatus = applicationTagStatus;
        }

        @Override
        public final Builder applicationTagStatus(String applicationTagStatus) {
            this.applicationTagStatus = applicationTagStatus;
            return this;
        }

        @Override
        public final Builder applicationTagStatus(ApplicationTagStatus applicationTagStatus) {
            this.applicationTagStatus(applicationTagStatus == null ? null : applicationTagStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<ResourcesListItem.Builder> getResources() {
            List<ResourcesListItem.Builder> result = ResourcesListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourcesListItem.BuilderImpl> resources) {
            this.resources = ResourcesListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourcesListItem> resources) {
            this.resources = ResourcesListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourcesListItem... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourcesListItem.Builder>... resources) {
            resources(Stream.of(resources).map(c -> ResourcesListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ApplicationTagResult build() {
            return new ApplicationTagResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
