/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateResourceRequest extends ServiceCatalogAppRegistryRequest implements
        ToCopyableBuilder<AssociateResourceRequest.Builder, AssociateResourceRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(AssociateResourceRequest::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(AssociateResourceRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(AssociateResourceRequest::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource").build()).build();

    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("options")
            .getter(getter(AssociateResourceRequest::optionsAsStrings))
            .setter(setter(Builder::optionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_FIELD, OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String application;

    private final String resourceType;

    private final String resource;

    private final List<String> options;

    private AssociateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.options = builder.options;
    }

    /**
     * <p>
     * The name, ID, or ARN of the application.
     * </p>
     * 
     * @return The name, ID, or ARN of the application.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * The type of resource of which the application will be associated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource of which the application will be associated.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource of which the application will be associated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource of which the application will be associated.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The name or ID of the resource of which the application will be associated.
     * </p>
     * 
     * @return The name or ID of the resource of which the application will be associated.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * Determines whether an application tag is applied or skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Determines whether an application tag is applied or skipped.
     */
    public final List<AssociationOption> options() {
        return OptionsCopier.copyStringToEnum(options);
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines whether an application tag is applied or skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Determines whether an application tag is applied or skipped.
     */
    public final List<String> optionsAsStrings() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? optionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceRequest)) {
            return false;
        }
        AssociateResourceRequest other = (AssociateResourceRequest) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resource(), other.resource()) && hasOptions() == other.hasOptions()
                && Objects.equals(optionsAsStrings(), other.optionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateResourceRequest").add("Application", application())
                .add("ResourceType", resourceTypeAsString()).add("Resource", resource())
                .add("Options", hasOptions() ? optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "options":
            return Optional.ofNullable(clazz.cast(optionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("application", APPLICATION_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateResourceRequest, T> g) {
        return obj -> g.apply((AssociateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateResourceRequest> {
        /**
         * <p>
         * The name, ID, or ARN of the application.
         * </p>
         * 
         * @param application
         *        The name, ID, or ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The type of resource of which the application will be associated.
         * </p>
         * 
         * @param resourceType
         *        The type of resource of which the application will be associated.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource of which the application will be associated.
         * </p>
         * 
         * @param resourceType
         *        The type of resource of which the application will be associated.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The name or ID of the resource of which the application will be associated.
         * </p>
         * 
         * @param resource
         *        The name or ID of the resource of which the application will be associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(Collection<String> options);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(String... options);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<AssociationOption> options);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(AssociationOption... options);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryRequest.BuilderImpl implements Builder {
        private String application;

        private String resourceType;

        private String resource;

        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResourceRequest model) {
            super(model);
            application(model.application);
            resourceType(model.resourceType);
            resource(model.resource);
            optionsWithStrings(model.options);
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Collection<String> getOptions() {
            if (options instanceof SdkAutoConstructList) {
                return null;
            }
            return options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String... options) {
            optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<AssociationOption> options) {
            this.options = OptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(AssociationOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResourceRequest build() {
            return new AssociateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
