/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAttributeGroupResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<CreateAttributeGroupResponse.Builder, CreateAttributeGroupResponse> {
    private static final SdkField<AttributeGroup> ATTRIBUTE_GROUP_FIELD = SdkField
            .<AttributeGroup> builder(MarshallingType.SDK_POJO).memberName("attributeGroup")
            .getter(getter(CreateAttributeGroupResponse::attributeGroup)).setter(setter(Builder::attributeGroup))
            .constructor(AttributeGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AttributeGroup attributeGroup;

    private CreateAttributeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.attributeGroup = builder.attributeGroup;
    }

    /**
     * <p>
     * Information about the attribute group.
     * </p>
     * 
     * @return Information about the attribute group.
     */
    public final AttributeGroup attributeGroup() {
        return attributeGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttributeGroupResponse)) {
            return false;
        }
        CreateAttributeGroupResponse other = (CreateAttributeGroupResponse) obj;
        return Objects.equals(attributeGroup(), other.attributeGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAttributeGroupResponse").add("AttributeGroup", attributeGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeGroup":
            return Optional.ofNullable(clazz.cast(attributeGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributeGroup", ATTRIBUTE_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAttributeGroupResponse, T> g) {
        return obj -> g.apply((CreateAttributeGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAttributeGroupResponse> {
        /**
         * <p>
         * Information about the attribute group.
         * </p>
         * 
         * @param attributeGroup
         *        Information about the attribute group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeGroup(AttributeGroup attributeGroup);

        /**
         * <p>
         * Information about the attribute group.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeGroup.Builder} avoiding the need
         * to create one manually via {@link AttributeGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #attributeGroup(AttributeGroup)}.
         * 
         * @param attributeGroup
         *        a consumer that will call methods on {@link AttributeGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeGroup(AttributeGroup)
         */
        default Builder attributeGroup(Consumer<AttributeGroup.Builder> attributeGroup) {
            return attributeGroup(AttributeGroup.builder().applyMutation(attributeGroup).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private AttributeGroup attributeGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAttributeGroupResponse model) {
            super(model);
            attributeGroup(model.attributeGroup);
        }

        public final AttributeGroup.Builder getAttributeGroup() {
            return attributeGroup != null ? attributeGroup.toBuilder() : null;
        }

        public final void setAttributeGroup(AttributeGroup.BuilderImpl attributeGroup) {
            this.attributeGroup = attributeGroup != null ? attributeGroup.build() : null;
        }

        @Override
        public final Builder attributeGroup(AttributeGroup attributeGroup) {
            this.attributeGroup = attributeGroup;
            return this;
        }

        @Override
        public CreateAttributeGroupResponse build() {
            return new CreateAttributeGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
