/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssociatedResourceRequest extends ServiceCatalogAppRegistryRequest implements
        ToCopyableBuilder<GetAssociatedResourceRequest.Builder, GetAssociatedResourceRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("application").getter(getter(GetAssociatedResourceRequest::application))
            .setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GetAssociatedResourceRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(GetAssociatedResourceRequest::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetAssociatedResourceRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> RESOURCE_TAG_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceTagStatus")
            .getter(getter(GetAssociatedResourceRequest::resourceTagStatusAsStrings))
            .setter(setter(Builder::resourceTagStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceTagStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetAssociatedResourceRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_FIELD, NEXT_TOKEN_FIELD, RESOURCE_TAG_STATUS_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String application;

    private final String resourceType;

    private final String resource;

    private final String nextToken;

    private final List<String> resourceTagStatus;

    private final Integer maxResults;

    private GetAssociatedResourceRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.nextToken = builder.nextToken;
        this.resourceTagStatus = builder.resourceTagStatus;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name, ID, or ARN of the application.
     * </p>
     * 
     * @return The name, ID, or ARN of the application.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * The type of resource associated with the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource associated with the application.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource associated with the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource associated with the application.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The name or ID of the resource associated with the application.
     * </p>
     * 
     * @return The name or ID of the resource associated with the application.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * A unique pagination token for each page of results. Make the call again with the returned token to retrieve the
     * next page of results.
     * </p>
     * 
     * @return A unique pagination token for each page of results. Make the call again with the returned token to
     *         retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * States whether an application tag is applied, not applied, in the process of being applied, or skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTagStatus} method.
     * </p>
     * 
     * @return States whether an application tag is applied, not applied, in the process of being applied, or skipped.
     */
    public final List<ResourceItemStatus> resourceTagStatus() {
        return GetAssociatedResourceFilterCopier.copyStringToEnum(resourceTagStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTagStatus property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTagStatus() {
        return resourceTagStatus != null && !(resourceTagStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * States whether an application tag is applied, not applied, in the process of being applied, or skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTagStatus} method.
     * </p>
     * 
     * @return States whether an application tag is applied, not applied, in the process of being applied, or skipped.
     */
    public final List<String> resourceTagStatusAsStrings() {
        return resourceTagStatus;
    }

    /**
     * <p>
     * The maximum number of results to return. If the parameter is omitted, it defaults to 25. The value is optional.
     * </p>
     * 
     * @return The maximum number of results to return. If the parameter is omitted, it defaults to 25. The value is
     *         optional.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTagStatus() ? resourceTagStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceRequest)) {
            return false;
        }
        GetAssociatedResourceRequest other = (GetAssociatedResourceRequest) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resource(), other.resource()) && Objects.equals(nextToken(), other.nextToken())
                && hasResourceTagStatus() == other.hasResourceTagStatus()
                && Objects.equals(resourceTagStatusAsStrings(), other.resourceTagStatusAsStrings())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssociatedResourceRequest").add("Application", application())
                .add("ResourceType", resourceTypeAsString()).add("Resource", resource()).add("NextToken", nextToken())
                .add("ResourceTagStatus", hasResourceTagStatus() ? resourceTagStatusAsStrings() : null)
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resourceTagStatus":
            return Optional.ofNullable(clazz.cast(resourceTagStatusAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("application", APPLICATION_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceTagStatus", RESOURCE_TAG_STATUS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedResourceRequest, T> g) {
        return obj -> g.apply((GetAssociatedResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssociatedResourceRequest> {
        /**
         * <p>
         * The name, ID, or ARN of the application.
         * </p>
         * 
         * @param application
         *        The name, ID, or ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The type of resource associated with the application.
         * </p>
         * 
         * @param resourceType
         *        The type of resource associated with the application.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource associated with the application.
         * </p>
         * 
         * @param resourceType
         *        The type of resource associated with the application.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The name or ID of the resource associated with the application.
         * </p>
         * 
         * @param resource
         *        The name or ID of the resource associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * A unique pagination token for each page of results. Make the call again with the returned token to retrieve
         * the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token for each page of results. Make the call again with the returned token to
         *        retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * States whether an application tag is applied, not applied, in the process of being applied, or skipped.
         * </p>
         * 
         * @param resourceTagStatus
         *        States whether an application tag is applied, not applied, in the process of being applied, or
         *        skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagStatusWithStrings(Collection<String> resourceTagStatus);

        /**
         * <p>
         * States whether an application tag is applied, not applied, in the process of being applied, or skipped.
         * </p>
         * 
         * @param resourceTagStatus
         *        States whether an application tag is applied, not applied, in the process of being applied, or
         *        skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagStatusWithStrings(String... resourceTagStatus);

        /**
         * <p>
         * States whether an application tag is applied, not applied, in the process of being applied, or skipped.
         * </p>
         * 
         * @param resourceTagStatus
         *        States whether an application tag is applied, not applied, in the process of being applied, or
         *        skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagStatus(Collection<ResourceItemStatus> resourceTagStatus);

        /**
         * <p>
         * States whether an application tag is applied, not applied, in the process of being applied, or skipped.
         * </p>
         * 
         * @param resourceTagStatus
         *        States whether an application tag is applied, not applied, in the process of being applied, or
         *        skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagStatus(ResourceItemStatus... resourceTagStatus);

        /**
         * <p>
         * The maximum number of results to return. If the parameter is omitted, it defaults to 25. The value is
         * optional.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. If the parameter is omitted, it defaults to 25. The value is
         *        optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryRequest.BuilderImpl implements Builder {
        private String application;

        private String resourceType;

        private String resource;

        private String nextToken;

        private List<String> resourceTagStatus = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedResourceRequest model) {
            super(model);
            application(model.application);
            resourceType(model.resourceType);
            resource(model.resource);
            nextToken(model.nextToken);
            resourceTagStatusWithStrings(model.resourceTagStatus);
            maxResults(model.maxResults);
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getResourceTagStatus() {
            if (resourceTagStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTagStatus;
        }

        public final void setResourceTagStatus(Collection<String> resourceTagStatus) {
            this.resourceTagStatus = GetAssociatedResourceFilterCopier.copy(resourceTagStatus);
        }

        @Override
        public final Builder resourceTagStatusWithStrings(Collection<String> resourceTagStatus) {
            this.resourceTagStatus = GetAssociatedResourceFilterCopier.copy(resourceTagStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagStatusWithStrings(String... resourceTagStatus) {
            resourceTagStatusWithStrings(Arrays.asList(resourceTagStatus));
            return this;
        }

        @Override
        public final Builder resourceTagStatus(Collection<ResourceItemStatus> resourceTagStatus) {
            this.resourceTagStatus = GetAssociatedResourceFilterCopier.copyEnumToString(resourceTagStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagStatus(ResourceItemStatus... resourceTagStatus) {
            resourceTagStatus(Arrays.asList(resourceTagStatus));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssociatedResourceRequest build() {
            return new GetAssociatedResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
