/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncResourceResponse
extends ServiceCatalogAppRegistryResponse
implements ToCopyableBuilder<Builder, SyncResourceResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(SyncResourceResponse.getter(SyncResourceResponse::applicationArn)).setter(SyncResourceResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(SyncResourceResponse.getter(SyncResourceResponse::resourceArn)).setter(SyncResourceResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> ACTION_TAKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionTaken").getter(SyncResourceResponse.getter(SyncResourceResponse::actionTakenAsString)).setter(SyncResourceResponse.setter(Builder::actionTaken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTaken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, RESOURCE_ARN_FIELD, ACTION_TAKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SyncResourceResponse.memberNameToFieldInitializer();
    private final String applicationArn;
    private final String resourceArn;
    private final String actionTaken;

    private SyncResourceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.resourceArn = builder.resourceArn;
        this.actionTaken = builder.actionTaken;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final SyncAction actionTaken() {
        return SyncAction.fromValue(this.actionTaken);
    }

    public final String actionTakenAsString() {
        return this.actionTaken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTakenAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncResourceResponse)) {
            return false;
        }
        SyncResourceResponse other = (SyncResourceResponse)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.actionTakenAsString(), other.actionTakenAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SyncResourceResponse").add("ApplicationArn", (Object)this.applicationArn()).add("ResourceArn", (Object)this.resourceArn()).add("ActionTaken", (Object)this.actionTakenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "actionTaken": {
                return Optional.ofNullable(clazz.cast(this.actionTakenAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("actionTaken", ACTION_TAKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyncResourceResponse, T> g) {
        return obj -> g.apply((SyncResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogAppRegistryResponse.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String resourceArn;
        private String actionTaken;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncResourceResponse model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.resourceArn(model.resourceArn);
            this.actionTaken(model.actionTaken);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getActionTaken() {
            return this.actionTaken;
        }

        public final void setActionTaken(String actionTaken) {
            this.actionTaken = actionTaken;
        }

        @Override
        public final Builder actionTaken(String actionTaken) {
            this.actionTaken = actionTaken;
            return this;
        }

        @Override
        public final Builder actionTaken(SyncAction actionTaken) {
            this.actionTaken(actionTaken == null ? null : actionTaken.toString());
            return this;
        }

        @Override
        public SyncResourceResponse build() {
            return new SyncResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceCatalogAppRegistryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SyncResourceResponse> {
        public Builder applicationArn(String var1);

        public Builder resourceArn(String var1);

        public Builder actionTaken(String var1);

        public Builder actionTaken(SyncAction var1);
    }
}

