/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAttributeGroupResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<AssociateAttributeGroupResponse.Builder, AssociateAttributeGroupResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(AssociateAttributeGroupResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> ATTRIBUTE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeGroupArn").getter(getter(AssociateAttributeGroupResponse::attributeGroupArn))
            .setter(setter(Builder::attributeGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            ATTRIBUTE_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationArn;

    private final String attributeGroupArn;

    private AssociateAttributeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.attributeGroupArn = builder.attributeGroupArn;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the application that was augmented with attributes.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the application that was augmented with attributes.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.
     */
    public final String attributeGroupArn() {
        return attributeGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(attributeGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAttributeGroupResponse)) {
            return false;
        }
        AssociateAttributeGroupResponse other = (AssociateAttributeGroupResponse) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(attributeGroupArn(), other.attributeGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAttributeGroupResponse").add("ApplicationArn", applicationArn())
                .add("AttributeGroupArn", attributeGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "attributeGroupArn":
            return Optional.ofNullable(clazz.cast(attributeGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("attributeGroupArn", ATTRIBUTE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAttributeGroupResponse, T> g) {
        return obj -> g.apply((AssociateAttributeGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAttributeGroupResponse> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the application that was augmented with attributes.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon resource name (ARN) of the application that was augmented with attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.
         * </p>
         * 
         * @param attributeGroupArn
         *        The Amazon resource name (ARN) of the attribute group that contains the application's new attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeGroupArn(String attributeGroupArn);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private String applicationArn;

        private String attributeGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAttributeGroupResponse model) {
            super(model);
            applicationArn(model.applicationArn);
            attributeGroupArn(model.attributeGroupArn);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getAttributeGroupArn() {
            return attributeGroupArn;
        }

        public final void setAttributeGroupArn(String attributeGroupArn) {
            this.attributeGroupArn = attributeGroupArn;
        }

        @Override
        public final Builder attributeGroupArn(String attributeGroupArn) {
            this.attributeGroupArn = attributeGroupArn;
            return this;
        }

        @Override
        public AssociateAttributeGroupResponse build() {
            return new AssociateAttributeGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
