/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssociatedResourceResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<GetAssociatedResourceResponse.Builder, GetAssociatedResourceResponse> {
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("resource").getter(getter(GetAssociatedResourceResponse::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("options")
            .getter(getter(GetAssociatedResourceResponse::optionsAsStrings))
            .setter(setter(Builder::optionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationTagResult> APPLICATION_TAG_RESULT_FIELD = SdkField
            .<ApplicationTagResult> builder(MarshallingType.SDK_POJO).memberName("applicationTagResult")
            .getter(getter(GetAssociatedResourceResponse::applicationTagResult)).setter(setter(Builder::applicationTagResult))
            .constructor(ApplicationTagResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationTagResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, OPTIONS_FIELD,
            APPLICATION_TAG_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Resource resource;

    private final List<String> options;

    private final ApplicationTagResult applicationTagResult;

    private GetAssociatedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.options = builder.options;
        this.applicationTagResult = builder.applicationTagResult;
    }

    /**
     * <p>
     * The resource associated with the application.
     * </p>
     * 
     * @return The resource associated with the application.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * Determines whether an application tag is applied or skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Determines whether an application tag is applied or skipped.
     */
    public final List<AssociationOption> options() {
        return OptionsCopier.copyStringToEnum(options);
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines whether an application tag is applied or skipped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Determines whether an application tag is applied or skipped.
     */
    public final List<String> optionsAsStrings() {
        return options;
    }

    /**
     * <p>
     * The result of the application that's tag applied to a resource.
     * </p>
     * 
     * @return The result of the application that's tag applied to a resource.
     */
    public final ApplicationTagResult applicationTagResult() {
        return applicationTagResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? optionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationTagResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociatedResourceResponse)) {
            return false;
        }
        GetAssociatedResourceResponse other = (GetAssociatedResourceResponse) obj;
        return Objects.equals(resource(), other.resource()) && hasOptions() == other.hasOptions()
                && Objects.equals(optionsAsStrings(), other.optionsAsStrings())
                && Objects.equals(applicationTagResult(), other.applicationTagResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssociatedResourceResponse").add("Resource", resource())
                .add("Options", hasOptions() ? optionsAsStrings() : null).add("ApplicationTagResult", applicationTagResult())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "options":
            return Optional.ofNullable(clazz.cast(optionsAsStrings()));
        case "applicationTagResult":
            return Optional.ofNullable(clazz.cast(applicationTagResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        map.put("options", OPTIONS_FIELD);
        map.put("applicationTagResult", APPLICATION_TAG_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssociatedResourceResponse, T> g) {
        return obj -> g.apply((GetAssociatedResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssociatedResourceResponse> {
        /**
         * <p>
         * The resource associated with the application.
         * </p>
         * 
         * @param resource
         *        The resource associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The resource associated with the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(Collection<String> options);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(String... options);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<AssociationOption> options);

        /**
         * <p>
         * Determines whether an application tag is applied or skipped.
         * </p>
         * 
         * @param options
         *        Determines whether an application tag is applied or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(AssociationOption... options);

        /**
         * <p>
         * The result of the application that's tag applied to a resource.
         * </p>
         * 
         * @param applicationTagResult
         *        The result of the application that's tag applied to a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTagResult(ApplicationTagResult applicationTagResult);

        /**
         * <p>
         * The result of the application that's tag applied to a resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationTagResult.Builder} avoiding
         * the need to create one manually via {@link ApplicationTagResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationTagResult.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationTagResult(ApplicationTagResult)}.
         * 
         * @param applicationTagResult
         *        a consumer that will call methods on {@link ApplicationTagResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationTagResult(ApplicationTagResult)
         */
        default Builder applicationTagResult(Consumer<ApplicationTagResult.Builder> applicationTagResult) {
            return applicationTagResult(ApplicationTagResult.builder().applyMutation(applicationTagResult).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private Resource resource;

        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private ApplicationTagResult applicationTagResult;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociatedResourceResponse model) {
            super(model);
            resource(model.resource);
            optionsWithStrings(model.options);
            applicationTagResult(model.applicationTagResult);
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Collection<String> getOptions() {
            if (options instanceof SdkAutoConstructList) {
                return null;
            }
            return options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String... options) {
            optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<AssociationOption> options) {
            this.options = OptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(AssociationOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        public final ApplicationTagResult.Builder getApplicationTagResult() {
            return applicationTagResult != null ? applicationTagResult.toBuilder() : null;
        }

        public final void setApplicationTagResult(ApplicationTagResult.BuilderImpl applicationTagResult) {
            this.applicationTagResult = applicationTagResult != null ? applicationTagResult.build() : null;
        }

        @Override
        public final Builder applicationTagResult(ApplicationTagResult applicationTagResult) {
            this.applicationTagResult = applicationTagResult;
            return this;
        }

        @Override
        public GetAssociatedResourceResponse build() {
            return new GetAssociatedResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
