/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the service integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Integrations implements SdkPojo, Serializable, ToCopyableBuilder<Integrations.Builder, Integrations> {
    private static final SdkField<ResourceGroup> RESOURCE_GROUP_FIELD = SdkField
            .<ResourceGroup> builder(MarshallingType.SDK_POJO).memberName("resourceGroup")
            .getter(getter(Integrations::resourceGroup)).setter(setter(Builder::resourceGroup))
            .constructor(ResourceGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroup").build()).build();

    private static final SdkField<ResourceGroup> APPLICATION_TAG_RESOURCE_GROUP_FIELD = SdkField
            .<ResourceGroup> builder(MarshallingType.SDK_POJO)
            .memberName("applicationTagResourceGroup")
            .getter(getter(Integrations::applicationTagResourceGroup))
            .setter(setter(Builder::applicationTagResourceGroup))
            .constructor(ResourceGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationTagResourceGroup")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_FIELD,
            APPLICATION_TAG_RESOURCE_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourceGroup resourceGroup;

    private final ResourceGroup applicationTagResourceGroup;

    private Integrations(BuilderImpl builder) {
        this.resourceGroup = builder.resourceGroup;
        this.applicationTagResourceGroup = builder.applicationTagResourceGroup;
    }

    /**
     * <p>
     * The information about the resource group integration.
     * </p>
     * 
     * @return The information about the resource group integration.
     */
    public final ResourceGroup resourceGroup() {
        return resourceGroup;
    }

    /**
     * Returns the value of the ApplicationTagResourceGroup property for this object.
     * 
     * @return The value of the ApplicationTagResourceGroup property for this object.
     */
    public final ResourceGroup applicationTagResourceGroup() {
        return applicationTagResourceGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTagResourceGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integrations)) {
            return false;
        }
        Integrations other = (Integrations) obj;
        return Objects.equals(resourceGroup(), other.resourceGroup())
                && Objects.equals(applicationTagResourceGroup(), other.applicationTagResourceGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Integrations").add("ResourceGroup", resourceGroup())
                .add("ApplicationTagResourceGroup", applicationTagResourceGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceGroup":
            return Optional.ofNullable(clazz.cast(resourceGroup()));
        case "applicationTagResourceGroup":
            return Optional.ofNullable(clazz.cast(applicationTagResourceGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceGroup", RESOURCE_GROUP_FIELD);
        map.put("applicationTagResourceGroup", APPLICATION_TAG_RESOURCE_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Integrations, T> g) {
        return obj -> g.apply((Integrations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Integrations> {
        /**
         * <p>
         * The information about the resource group integration.
         * </p>
         * 
         * @param resourceGroup
         *        The information about the resource group integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroup(ResourceGroup resourceGroup);

        /**
         * <p>
         * The information about the resource group integration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceGroup.Builder} avoiding the need
         * to create one manually via {@link ResourceGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceGroup(ResourceGroup)}.
         * 
         * @param resourceGroup
         *        a consumer that will call methods on {@link ResourceGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceGroup(ResourceGroup)
         */
        default Builder resourceGroup(Consumer<ResourceGroup.Builder> resourceGroup) {
            return resourceGroup(ResourceGroup.builder().applyMutation(resourceGroup).build());
        }

        /**
         * Sets the value of the ApplicationTagResourceGroup property for this object.
         *
         * @param applicationTagResourceGroup
         *        The new value for the ApplicationTagResourceGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTagResourceGroup(ResourceGroup applicationTagResourceGroup);

        /**
         * Sets the value of the ApplicationTagResourceGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceGroup.Builder} avoiding the need
         * to create one manually via {@link ResourceGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationTagResourceGroup(ResourceGroup)}.
         * 
         * @param applicationTagResourceGroup
         *        a consumer that will call methods on {@link ResourceGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationTagResourceGroup(ResourceGroup)
         */
        default Builder applicationTagResourceGroup(Consumer<ResourceGroup.Builder> applicationTagResourceGroup) {
            return applicationTagResourceGroup(ResourceGroup.builder().applyMutation(applicationTagResourceGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceGroup resourceGroup;

        private ResourceGroup applicationTagResourceGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(Integrations model) {
            resourceGroup(model.resourceGroup);
            applicationTagResourceGroup(model.applicationTagResourceGroup);
        }

        public final ResourceGroup.Builder getResourceGroup() {
            return resourceGroup != null ? resourceGroup.toBuilder() : null;
        }

        public final void setResourceGroup(ResourceGroup.BuilderImpl resourceGroup) {
            this.resourceGroup = resourceGroup != null ? resourceGroup.build() : null;
        }

        @Override
        public final Builder resourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this;
        }

        public final ResourceGroup.Builder getApplicationTagResourceGroup() {
            return applicationTagResourceGroup != null ? applicationTagResourceGroup.toBuilder() : null;
        }

        public final void setApplicationTagResourceGroup(ResourceGroup.BuilderImpl applicationTagResourceGroup) {
            this.applicationTagResourceGroup = applicationTagResourceGroup != null ? applicationTagResourceGroup.build() : null;
        }

        @Override
        public final Builder applicationTagResourceGroup(ResourceGroup applicationTagResourceGroup) {
            this.applicationTagResourceGroup = applicationTagResourceGroup;
            return this;
        }

        @Override
        public Integrations build() {
            return new Integrations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
