/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationRequest extends ServiceCatalogAppRegistryRequest implements
        ToCopyableBuilder<PutConfigurationRequest.Builder, PutConfigurationRequest> {
    private static final SdkField<AppRegistryConfiguration> CONFIGURATION_FIELD = SdkField
            .<AppRegistryConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(PutConfigurationRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AppRegistryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppRegistryConfiguration configuration;

    private PutConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     * 
     * @return Associates a <code>TagKey</code> configuration to an account.
     */
    public final AppRegistryConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationRequest)) {
            return false;
        }
        PutConfigurationRequest other = (PutConfigurationRequest) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationRequest").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationRequest, T> g) {
        return obj -> g.apply((PutConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ServiceCatalogAppRegistryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationRequest> {
        /**
         * <p>
         * Associates a <code>TagKey</code> configuration to an account.
         * </p>
         * 
         * @param configuration
         *        Associates a <code>TagKey</code> configuration to an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AppRegistryConfiguration configuration);

        /**
         * <p>
         * Associates a <code>TagKey</code> configuration to an account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppRegistryConfiguration.Builder}
         * avoiding the need to create one manually via {@link AppRegistryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppRegistryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AppRegistryConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AppRegistryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AppRegistryConfiguration)
         */
        default Builder configuration(Consumer<AppRegistryConfiguration.Builder> configuration) {
            return configuration(AppRegistryConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryRequest.BuilderImpl implements Builder {
        private AppRegistryConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationRequest model) {
            super(model);
            configuration(model.configuration);
        }

        public final AppRegistryConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AppRegistryConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AppRegistryConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationRequest build() {
            return new PutConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
