/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListInstancesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListInstancesResponse.Builder, ListInstancesResponse> {
    private final List<InstanceSummary> instances;

    private final String nextToken;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Summary information about the instances that are associated with the specified service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Summary information about the instances that are associated with the specified service.
     */
    public List<InstanceSummary> instances() {
        return instances;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>ListInstances</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse) obj;
        return Objects.equals(instances(), other.instances()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListInstancesResponse").add("Instances", instances()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, ListInstancesResponse> {
        /**
         * <p>
         * Summary information about the instances that are associated with the specified service.
         * </p>
         * 
         * @param instances
         *        Summary information about the instances that are associated with the specified service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<InstanceSummary> instances);

        /**
         * <p>
         * Summary information about the instances that are associated with the specified service.
         * </p>
         * 
         * @param instances
         *        Summary information about the instances that are associated with the specified service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(InstanceSummary... instances);

        /**
         * <p>
         * Summary information about the instances that are associated with the specified service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceSummary>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<InstanceSummary>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<InstanceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<InstanceSummary>)
         */
        Builder instances(Consumer<InstanceSummary.Builder>... instances);

        /**
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>ListInstances</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>ListInstances</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<InstanceSummary> instances;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            instances(model.instances);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceSummary.Builder> getInstances() {
            return instances != null ? instances.stream().map(InstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<InstanceSummary> instances) {
            this.instances = InstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceSummary... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceSummary.Builder>... instances) {
            instances(Stream.of(instances).map(c -> InstanceSummary.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<InstanceSummary.BuilderImpl> instances) {
            this.instances = InstanceSummaryListCopier.copyFromBuilder(instances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }
    }
}
